
let table;
let tb_rows;
let age_range;
let worth_range;
let gdp_range;
// var dict = {};
var splom_attr_arr = [];
let canvasWidth = 1100;
let canvasHeight = 1200;
var pos_arr = [];

function preload() {
    table = loadTable('billionaires.csv', 'csv', 'header');
}


function setup() {
    // Data processing
    tb_rows = table.getRows();
    age_range = colValsMinMax("age");
    worth_range = colValsMinMax("worth in billions");
    gdp_range = colValsMinMax("gdp");

    splom_attr_arr.push(age_range);
    splom_attr_arr.push(worth_range);
    splom_attr_arr.push(gdp_range);

    frameRate(1);
    createCanvas(canvasWidth, canvasHeight);
}


function colValsMinMax(colName) {
    var vals = []
    var name = colName;
    for (var i = 0; i < table.getRowCount(); i++) {
        if (tb_rows[i].getNum("age") !== -1) {
            if (colName == "gdp") {
                vals.push(tb_rows[i].getNum(colName)/100000000000);
                name = "gdp in 100 billions";
            }else{
                vals.push(tb_rows[i].getNum(colName));
            }
        }
    }
    let obj = {
        values: vals,
        min: min(vals),
        max: max(vals),
        name: name,
    }
    return obj;
}


function draw() {
    fill(0);

    // Setting metadata of axis and titles
    var axis_y_end_height = 0;
    var axis_x_end_width = canvasWidth;

	var plots_col_count = 3;
	var plots_col_pos_x_start = 50;
	var plots_col_width = 330;
	var plots_row_count = 4;
	var plots_row_pos_y_start = 100;
	var plots_row_height = plots_col_width;

	for (m = 1; m <= splom_attr_arr.length; m++) {
		axis_intercept_y = plots_row_pos_y_start + ((canvasHeight - 50 - plots_row_pos_y_start)/splom_attr_arr.length)*m;
		axis_y_end_height = axis_intercept_y - plots_row_height
        var axis_y_splom_attr = splom_attr_arr[m-1];

		for (i = 1; i <= splom_attr_arr.length; i++) {
            var axis_x_splom_attr = splom_attr_arr[i-1];

			axis_x_end_width = plots_col_pos_x_start + ((canvasWidth - 50 - plots_col_pos_x_start)/splom_attr_arr.length)*i;
			axis_intercept_x = axis_x_end_width - plots_col_width;

			var title_pos_y = axis_y_end_height;
			var title_pos_x = axis_intercept_x+(axis_x_end_width-axis_intercept_x)/2-30;
			var axis_y_title_pos_x = axis_intercept_x-100;
			var axis_x_title_pos_y = axis_intercept_y+60;
			var category_name;

			// Plot axis
			stroke(0);
			line(axis_intercept_x, axis_intercept_y, axis_intercept_x, axis_y_end_height);
			line(axis_x_end_width, axis_y_end_height, axis_intercept_x, axis_y_end_height);
			line(axis_intercept_x, axis_intercept_y, axis_x_end_width, axis_intercept_y);
			line(axis_x_end_width, axis_y_end_height, axis_x_end_width, axis_intercept_y);

            if (i === m) {
                fill(65,157,120);
                textSize(16);
                text(axis_x_splom_attr.name, title_pos_x-15, axis_y_end_height+(axis_intercept_y-axis_y_end_height)/2);
                continue;
            }

			// Margin for plotting and scale labels on axis
			var axis_x_scale_label_pos_y = axis_intercept_y+20;
			var axis_y_scale_label_pos_x = axis_intercept_x-30;
			var axis_x_scale_margin_px = 5;
			var axis_y_scale_margin_px = 5;

			// Plot points in scatter plot
			for (k = 0; k < age_range.values.length; k++) {
				if ((tb_rows[k].getNum("age") != -1)) {
					var x_val = axis_x_splom_attr.values[k];
					var y_val = axis_y_splom_attr.values[k];

					var pos_x = map(x_val, axis_x_splom_attr.min, axis_x_splom_attr.max, axis_intercept_x+axis_x_scale_margin_px, axis_x_end_width-axis_x_scale_margin_px);
					var pos_y = map(y_val, axis_y_splom_attr.min, axis_y_splom_attr.max, axis_intercept_y-axis_y_scale_margin_px, axis_y_end_height+axis_y_scale_margin_px);
					fill(65,157,120);
					ellipse(pos_x, pos_y, 5);

                    var d = dist(mouseX, mouseY, pos_x, pos_y);
                    if (d < 5) {
                        noStroke();
                        textSize(12);
                        fill(58,183,149);
                        var msg = axis_x_splom_attr.name + ": " + x_val;
                        msg += "\n";
                        msg += axis_y_splom_attr.name + ": " + y_val;
                        text(msg, mouseX, mouseY-15);
                    }
				}
			}

        	fill(65,157,120);

            if (m == 1) {
                //plot x label on top
    			for(label_i = 1; label_i <= 10; label_i++) {
                    textSize(12);
    			    var label_pos_x = ((axis_x_end_width-axis_x_scale_margin_px)-(axis_intercept_x+axis_x_scale_margin_px))/10*label_i + (axis_intercept_x+axis_x_scale_margin_px);
    			    text(Math.round(((axis_x_splom_attr.max-axis_x_splom_attr.min)/10*label_i + axis_x_splom_attr.min)), Math.round(label_pos_x)-5, axis_y_end_height-20);
    			    stroke(100);
    			    line(label_pos_x, axis_y_end_height-2, label_pos_x, axis_y_end_height+2);
    			}
            }

            if (m == splom_attr_arr.length) {
                //plot x label on bottom
    			for(label_i = 1; label_i <= 10; label_i++) {
                    textSize(12);
    			    var label_pos_x = ((axis_x_end_width-axis_x_scale_margin_px)-(axis_intercept_x+axis_x_scale_margin_px))/10*label_i + (axis_intercept_x+axis_x_scale_margin_px);
    			    text(Math.round(((axis_x_splom_attr.max-axis_x_splom_attr.min)/10*label_i + axis_x_splom_attr.min)), Math.round(label_pos_x)-5, axis_x_scale_label_pos_y);
    			    stroke(100);
    			    line(label_pos_x, axis_intercept_y-2, label_pos_x, axis_intercept_y+2);
    			}
            }

            if (i == 1) {
                //plot y label on left
                // plot y axis scale label
    			for(label_i = 1; label_i <= 10; label_i++) {
    			    var label_pos_y = ((axis_intercept_y-axis_y_scale_margin_px)-(axis_y_end_height+axis_y_scale_margin_px))/10*(11-label_i) + (axis_y_end_height+axis_y_scale_margin_px);
    			    text(Math.round(((axis_y_splom_attr.max-axis_y_splom_attr.min)/10*label_i + axis_y_splom_attr.min)), axis_y_scale_label_pos_x, Math.round(label_pos_y)+5);
    			    stroke(100);
    			    line(axis_intercept_x-2, label_pos_y, axis_intercept_x+2, label_pos_y);
    			}
            }

            if (i == splom_attr_arr.length) {
                //plot y label on right
    			for(label_i = 1; label_i <= 10; label_i++) {
    			    var label_pos_y = ((axis_intercept_y-axis_y_scale_margin_px)-(axis_y_end_height+axis_y_scale_margin_px))/10*(11-label_i) + (axis_y_end_height+axis_y_scale_margin_px);
    			    text(Math.round(((axis_y_splom_attr.max-axis_y_splom_attr.min)/10*label_i + axis_y_splom_attr.min)), axis_x_end_width+20, Math.round(label_pos_y)+5);
    			    stroke(100);
    			    line(axis_x_end_width-2, label_pos_y, axis_x_end_width+2, label_pos_y);
    			}
            }

		}
	}
}
