var sketch = function(sketch){

            var table;

            sketch.preload = function() {
              table = sketch.loadTable("flights.csv","csv","header")
            }
            sketch.setup = function() {
              sketch.createCanvas(600,300)
              sketch.noStroke()
            }

            sketch.draw = function() {
              sketch.background(255,255,255)
              var rows = table.getRows()
              for (var r = 0; r < rows.length; r++) {
                var from_long = rows[r].getNum("from_long")
                var from_lat = rows[r].getNum("from_lat")
                var from_country = rows[r].getString("from_country")
                var to_country = rows[r].getString("to_country")
                var distance = rows[r].getNum("distance")
                
                
                //map long, -180-180 to the width of the sketch
                var x = sketch.map(from_long,-180,180,0,sketch.width)
                //map lat, -90-90 to the height of the sketch
                var y = sketch.map(from_lat,-90,90,sketch.height,0)
                //if the flights are domestic, fill red
                if ( from_country == to_country ) {
                  sketch.fill(255,0,0,10)
                } else {
                 //otherwise fill blue
                  sketch.fill(0,0,255,10)
                }
                //map the size of the dot to the distance of the flight
                var radius = sketch.map(distance,1,15406,3,15)
                sketch.ellipse(x,y,radius,radius)
              }
            }
    
    }

var firstSketch = new p5(sketch, 'one');

var sketch = function(sketch){

    var table;
    var flights = [];

    var pg;

        var flight = function(d,flo,fla,tlo,tla,fc,tc) {
          this.distance = d
          this.from_long = flo
          this.from_lat = fla
          this.to_long = tlo
          this.to_lat = tla
          this.from_country = fc
          this.to_country = tc

          this.departureX = sketch.map(this.from_long, -180,180,0,sketch.width)
          this.departureY = sketch.map(this.from_lat, -90,90,sketch.height/2,0)
          this.arrivalX = sketch.map(this.to_long, -180,180,0,sketch.width)
          this.arrivalY = sketch.map(this.to_lat, -90,90,sketch.height,sketch.height/2)

          this.selected = function() {
            if ( sketch.dist(sketch.mouseX, sketch.mouseY, this.departureX, this.departureY) < 10 ) {
                return true
            } else {
                return false
            }
          }

          this.drawBackgroundAirport = function() {
            pg.ellipse(this.departureX, this.departureY, 5,5)
            pg.ellipse(this.arrivalX, this.arrivalY, 5,5)
          }
	
          this.drawSelectedAirport = function() {
            if ( this.selected() ) {
              sketch.fill(255,0,0,25)
              sketch.ellipse(this.departureX, this.departureY, 5,5)
              sketch.ellipse(this.arrivalX, this.arrivalY, 5,5)
            }
          }
        }

        sketch.preload = function() {
          table = sketch.loadTable("flights.csv","csv","header")
        }

        sketch.setup = function () {
          sketch.createCanvas(800, 800);
          sketch.noStroke()
          sketch.noLoop()

          var rows = table.getRows()
          for ( var i in rows ) {
            var from_airport = rows[i].getString("from_airport")
            var from_city = rows[i].getString("from_city")
            var from_country = rows[i].getString("from_country")
            var from_long = rows[i].getNum("from_long")
            var from_lat = rows[i].getNum("from_lat")
            var to_airport = rows[i].getString("to_airport")
            var to_city = rows[i].getString("to_city")
            var to_country = rows[i].getString("to_country")
            var to_long = rows[i].getNum("to_long")
            var to_lat = rows[i].getNum("to_lat")
            var airline = rows[i].getString("airline")
            var airline_country = rows[i].getString("airline_country")
            var distance = rows[i].getNum("distance")
            
            
            //new flight object
            var this_flight = new flight(distance, from_long, from_lat, to_long, to_lat, from_country, to_country)
            flights.push(this_flight)
          }

          pg = sketch.createGraphics(800,800);
          pg.background(255,255,255);
          pg.noStroke();
          pg.fill(0,0,0,1);
          for ( var i in flights ) {
            flights[i].drawBackgroundAirport()
            }
        }

        sketch.draw = function() {
          sketch.background(255,255,255)
          sketch.image(pg,0,0)
          for ( var i in flights ) {
            flights[i].drawSelectedAirport()
          }
        }

        sketch.mouseMoved = function() {
          sketch.redraw()
        }
            }

var secondSketch = new p5(sketch, 'two');