//returning to instance mode - mulitple sketches in one page
//note: for working with data you will have to start a local server:
//
var sketch = function(sketch){
    
                // what's wrong with this approach?
                // (think about the relationship between
                // the values in the CSV file and what's
                // drawn on the screen.)

                let data;

                // preload table data
                sketch.preload = function() {
                  data = sketch.loadTable(
                    'PRSA-adapted-aparrish.csv',
                        'csv',
                        'header');
                }

                sketch.setup = function() { 
                  sketch.createCanvas(640, 480);

                  // how many rows?  The rows of data represent different readings over time
                  console.log(data.getRowCount());
                  // what are the columns?  The colums represent the different kinds of readings: year, month and hour of the reading, the temperature, the dew point, etc.  (this is weather data).  These are string values.
                  console.log(data.columns);

                  sketch.background(50);
                  sketch.stroke(255);

                  // noprotect
                  for (var i = 0; i < data.getRowCount(); i++) {

                    // draw temperatures
                    let xpos = sketch.map(i, 0, data.getRowCount(), 0, sketch.width);
                    // data.getNum(m, n) evaluates to the value in the
                    // cell for row m in column n.
                    // i is the index value of the ROWS (the sheet rows read from top to bottom in the tabular data and this represents time)
                    // replace "TEMP" with some other column name (string value) to
                    // display a different column.
                      //check the console output of this file to see what you could change it to
                    sketch.point(xpos, data.getNum(i, "TEMP") + 200);//adding a value at the end here will move the numbers more toward the center of the sketch, changing the ypos of the graph

                  }
                }
    
            }

var firstSketch = new p5(sketch, 'one');


var sketch = function(sketch){
    
                let data;

            // preload table data
            sketch.preload = function() {
              data = sketch.loadTable(
                'PRSA-adapted-aparrish.csv',
                    'csv',
                    'header');
            }

            sketch.setup = function() { 
              sketch.createCanvas(640, 480);

              // how many rows?
              console.log(data.getRowCount());
              // what are the columns?
              console.log(data.columns);

              sketch.background(50);

              // getColumn evaluates to a list of all the values
              // in the column with the given name.
              let temps = data.getColumn("TEMP");
              // the min() and max() functions tell us what the lowest
              // and highest values of the array are
              //store these in minTemp, maxTemp variables
              let minTemp = sketch.min(temps);
              let maxTemp = sketch.max(temps);
              console.log("minTemp: " + minTemp);
              console.log("maxTemp: " + maxTemp);

              //
              for (var i = 0; i < data.getRowCount(); i++) {

                let val = data.getNum(i, "TEMP");
                
                let xpos = sketch.map(i, 0, data.getRowCount(), 0, sketch.width);
                // why map from height to zero (instead of from
                // zero to height?)
                //map minimum - maximum values to sketch.height - 0
                let ypos = sketch.map(val, minTemp, maxTemp, sketch.height, 0);
                  
                //map these points in white
                sketch.stroke(255);
                //or, change the color based on temp?
                //let colorTemp = sketch.map(val, -20, 45, 0, 255);
                //have colortemp run the red value (the hotter the temp, the redder the color)
                //sketch.stroke(colorTemp, 125, 125);                  //draw temperatures
                sketch.point(xpos, ypos);

              }

              // draw a line where zero is
              sketch.stroke(255, 0, 0);
              //to find where the zero would be, map 0 on min-max, scaled to sketch.height - 0
              let zeroVal = sketch.map(0, minTemp, maxTemp, sketch.height, 0);
              sketch.line(0, zeroVal, sketch.width, zeroVal);
            }
        }

var secondSketch = new p5(sketch, 'two');

var sketch = function(sketch){
    
               //plotting multiple columns
        let data;

            // preload table data
            sketch.preload = function() {
                data = sketch.loadTable(
                  'PRSA-adapted-aparrish.csv',
                        'csv',
                        'header');
            }

            // using a p5js table object, return an object having
            // the values of the given column, plus the minimum value
            // and maximum value from that column
            // defining a function here to get the min max vals of the columns
            function colValsMinMax(table, colName) {
              let vals = data.getColumn(colName);
              let obj = {
                values: vals,
                min: sketch.min(vals),
                max: sketch.max(vals),
              }
              return obj;
            }

            sketch.setup = function() { 
              sketch.createCanvas(640, 480);
              // how many rows?
              console.log(data.getRowCount());
              // what are the columns?
              console.log(data.columns);

              sketch.background(50);

              // fetch values and min/max for pm2.5 (this is a measure of particulate matter in the air, or air quality.  It can be a sign of air pollution
              //https://www.epa.gov/pm-pollution
              let pm = colValsMinMax(data, "pm2.5");
              console.log(pm.min);
              console.log(pm.max);

              // fetch values and min/max for temperature
              let temps = colValsMinMax(data, "TEMP");
              console.log(temps.min);
              console.log(temps.max);

              // noprotect
              for (var i = 0; i < data.getRowCount(); i++) {

                // draw pm2.5
                //these are going to be a sort of blue
                sketch.stroke(255, 128, 128);
                let pmXpos = sketch.map(i, 0, data.getRowCount(), 0, sketch.width);
                let pmYpos = sketch.map(pm.values[i], pm.min, pm.max, sketch.height, 0);
                sketch.point(pmXpos, pmYpos);  
                  
              }
              
              for (var i = 0; i < data.getRowCount(); i++){
                // draw temps
                sketch.stroke(128, 128, 255);
                let tempXpos = sketch.map(i, 0, data.getRowCount(), 0, sketch.width);
                let tempYpos = sketch.map(temps.values[i], temps.min, temps.max,
                                   sketch.height, 0);
                sketch.point(tempXpos, tempYpos);
                }
                
                //these sketches together will show us particulate matter mapped against temperature

            
            }
    }

var thirdSketch = new p5(sketch, 'three');

var sketch = function(sketch){
    let data;

        // preload table data
        sketch.preload = function() {
            data = sketch.loadTable(
              'PRSA-adapted-aparrish.csv',
                    'csv',
                    'header');
        }

        // using a p5js table object, return an object having
        // the values of the given column, plus the minimum value
        // and maximum value from that column
        function colValsMinMax(tab, colName) {
          let vals = data.getColumn(colName);
          let obj = {
            values: vals,
            min: sketch.min(vals),
            max: sketch.max(vals),
          }
          return obj;
        }

        sketch.setup = function() { 
          sketch.createCanvas(640, 480);
          // how many rows?
          console.log(data.getRowCount());
          // what are the columns?
          console.log(data.columns);

          sketch.background(50);
          sketch.stroke(255);

          // fetch values and min/max for pm2.5
          let pm = colValsMinMax(data, "pm2.5");
          console.log(pm.min);
          console.log(pm.max);

          // fetch values and min/max for wind speed
          let iws = colValsMinMax(data, "Iws");
          console.log(iws.min);
          console.log(iws.max);

          // noprotect
          for (var i = 0; i < data.getRowCount(); i++) {

            // x position is pm2.5; y position is wind speed
            sketch.stroke(255, 128, 128);
            let xpos = sketch.map(pm.values[i], pm.min, pm.max, 0, sketch.width);
            //map the Xpos against the Ypos for these two different sets of values - look at the graph to visualize the relationship between these two values
            let ypos = sketch.map(iws.values[i], iws.min, iws.max, sketch.height, 0);

            sketch.point(xpos, ypos);//one point maps two values - x represents the particulate matter, y represents the wind speed.  What does this tell us looking at the graph?
          }
        }
    }

var fourthSketch = new p5(sketch, 'four');