//A simple express server written in node, serving up an example app that stores data to a local JSON file and lets the user input data and add to this file.
//navigate into this main folder in your command line and run "npm start" to start the server, and go to http://localhost:5000 to see the index.html file in "public"

//first, require express; a reference to a function that we'll hold in a variable
var express = require('express');
//lets get some things together
var bodyParser = require('body-parser');
console.log('server starting....');
//we have a reference to express, so now create the app. Run the function.
var app = express();
//now listen to a port
// Set up the server
// process.env.PORT is related to deploying on heroku
var server = app.listen(process.env.PORT || 5000, listen);

// This call back just tells us that the server has started
function listen() {
  var host = server.address().address;
  var port = server.address().port;
  console.log('Example app listening at http://' + host + ':' + port);
}

//and host files on it.  Serve a static website, for example
//if we want to just serve some static files.
//this tells the app to serve the public folder at port 3000
app.use(express.static('public'));

//also need to add body parser and give it a big enough buffer - don't limit the size too much!
app.use(bodyParser.urlencoded({extended: false, limit:'100MB' }));
app.use(bodyParser.json({limit:'100MB'}));

//this is the standard format for writing get commands
app.get('/myPath', executeWhenPathIsFollowed);

//go to http://localhost:3000/myPath to see what happens
function executeWhenPathIsFollowed(request, response){
    response.send("a command executed!! And we got this back");
}

//instead of getting that data and responding with it, save some JSON
//need to use the fs module, the file system module built into node
var fs = require('fs');

//read the json file
var data = fs.readFileSync('images.json');
//parse it
var imageDB = JSON.parse(data);
//console.log(scores);


//a path to return all of the data
app.get('/all', sendAll);

function sendAll(request,response){
    response.send(imageDB);
}

app.post('/saveData', saveDrawingData);

function saveDrawingData(request,response){
    
    console.log(request.body);
    //store the reply
    var reply;
    
    var img = request.body.img;
    var name = request.body.name;
    
    console.log(img, name);
    
        var newData = {
            name: name,
            img: img
        }
        
        
        //push the new data to the array    
        imageDB["drawings"].push(newData);
        //stringify
        var jsonNewData = JSON.stringify(imageDB, null,2);
        //write to db
        fs.writeFile('images.json', jsonNewData, finished);
        function finished(err){
            if(err){
                console.log(err);
                reply = err;
            } else {
                reply = {
                    msg: "thanks for your image",
                    data: newData
                }
            }
            console.log(reply);
            response.send(reply);
        }
    
}