var nameInput;
var messageInput;

// Keep list of DOM elements for clearing later when reloading
var listItems = [];
var database;

function setup() {

  var config = {
    apiKey: "AIzaSyA7KP55lIqyse8tu8DfQOi8N8Fv184SdtU",
    authDomain: "fir-814ed.firebaseapp.com",
    databaseURL: "https://fir-814ed.firebaseio.com",
    storageBucket: "fir-814ed.appspot.com",
    messagingSenderId: "79150818476"
  };
    
    
    //initialize app
    firebase.initializeApp(config);
    //and just check see if that worked.
    console.log(firebase);
    
    database = firebase.database();
            //if we just want to store some data, send it on
            /*var ref = database.ref('entries');
            //store some data!!
            var data = {
                name: 'mjs',
                message: "a new message"
            }
            ref.push(data);*/
    //Input fields from page
    nameInput = select('#name');
    messageInput = select('#message');
    
    //button to submit tied to call
    var submit = select('#submit');
    submit.mousePressed(sendToFirebase);
    
    //load the data
    loadFirebase();
}

function loadFirebase(){
    var data = database.ref('entries/')
    data.on("value",gotData,errData);
}

function errData(error){
    console.log("something went wrong");
    console.log(error);
}

function gotData(data){
    var entries = data.val();
    console.log(entries);
    //grab all the keys, we'll use this array to parse through the object
    var keys = Object.keys(entries);
    //our array of keys
    console.log(keys);
    //clear the last html list on the page, we're about to get a new one
    clearList();
    
    //make html list
    var list = createElement('ol');
    //assign a parent container on the page
    list.parent('data');
    
    //loop through array of db entries, using the array of keys
    for(var i=0;i<keys.length;i++){
        var key = keys[i];
        //console.log(key);
        //get the individual item using the key
        var entry = entries[key];
        //at this level, the .name and .message hold the data 
        var li = createElement('li', entry.name + ': ' + entry.message);
        li.parent(list);
        listItems.push(li);
        
    }
}

//clear the html list
function clearList(){
    for(var i=0;i<listItems.length;i++){
        listItems[i].remove();
    }
}

//this is for sending, called when submit is pushed
function sendToFirebase(){
    var entries = database.ref('entries');
    
    //make the object, grab values
    var data = {
        name: nameInput.value(),
        message: messageInput.value()
    }
    var entry = entries.push(data, finished);
    console.log("Firebase generated key: " + entry.key);
    
    //reload data for the page
    function finished(err){
        if(err){
            console.log(err);
        }else{
            console.log('Data Saved!');
        }
    }
}