import mosse from 'mosse';
import jsfeat from 'jsfeat';

import findFaceWorker from './faceDetection_worker.js';

// import { drawDetection, drawFacialPoints, drawBoundingBox } from './utils/debugging.js';

/**
 * this cascade is derived from https://github.com/mtschirs/js-objectdetect implementation
 * @author Martin Tschirsich / http://www.tu-darmstadt.de/~m_t
 */
jsfeat.haar.frontalface = {complexClassifiers:[{simpleClassifiers:[{features:[[3,7,14,4,-1.],[3,9,14,2,2.]],threshold:4.0142e-003,right_val:0.83781,left_val:0.033794},{features:[[1,2,18,4,-1.],[7,2,6,4,3.]],threshold:0.015151,right_val:0.74888,left_val:0.15141},{features:[[1,7,15,9,-1.],[1,10,15,3,3.]],threshold:4.211e-003,right_val:0.63748,left_val:0.090049}],threshold:0.82269},{simpleClassifiers:[{features:[[5,6,2,6,-1.],[5,9,2,3,2.]],threshold:1.6227e-003,right_val:0.71109,left_val:0.069309},{features:[[7,5,6,3,-1.],[9,5,2,3,3.]],threshold:2.2907e-003,right_val:0.66687,left_val:0.17958},{features:[[4,0,12,9,-1.],[4,3,12,3,3.]],threshold:5.0026e-003,right_val:0.6554,left_val:0.16937},{features:[[6,9,10,8,-1.],[6,13,10,4,2.]],threshold:7.966e-003,right_val:0.091415,left_val:0.58663},{features:[[3,6,14,8,-1.],[3,10,14,4,2.]],threshold:-3.5227e-003,right_val:0.60319,left_val:0.14132},{features:[[14,1,6,10,-1.],[14,1,3,10,2.]],threshold:0.036668,right_val:0.79203,left_val:0.36757},{features:[[7,8,5,12,-1.],[7,12,5,4,3.]],threshold:9.3361e-003,right_val:0.20885,left_val:0.61614},{features:[[1,1,18,3,-1.],[7,1,6,3,3.]],threshold:8.6961e-003,right_val:0.63603,left_val:0.28362},{features:[[1,8,17,2,-1.],[1,9,17,1,2.]],threshold:1.1489e-003,right_val:0.58007,left_val:0.22236},{features:[[16,6,4,2,-1.],[16,7,4,1,2.]],threshold:-2.1485e-003,right_val:0.57871,left_val:0.24065},{features:[[5,17,2,2,-1.],[5,18,2,1,2.]],threshold:2.1219e-003,right_val:0.13622,left_val:0.55597},{features:[[14,2,6,12,-1.],[14,2,3,12,2.]],threshold:-0.093949,right_val:0.47177,left_val:0.85027},{features:[[4,0,4,12,-1.],[4,0,2,6,2.],[6,6,2,6,2.]],threshold:1.3778e-003,right_val:0.28345,left_val:0.59937},{features:[[2,11,18,8,-1.],[8,11,6,8,3.]],threshold:0.073063,right_val:0.706,left_val:0.43419},{features:[[5,7,10,2,-1.],[5,8,10,1,2.]],threshold:3.6767e-004,right_val:0.60516,left_val:0.30279},{features:[[15,11,5,3,-1.],[15,12,5,1,3.]],threshold:-6.048e-003,right_val:0.56753,left_val:0.17984}],threshold:6.9566},{simpleClassifiers:[{features:[[5,3,10,9,-1.],[5,6,10,3,3.]],threshold:-0.016511,right_val:0.14249,left_val:0.66442},{features:[[9,4,2,14,-1.],[9,11,2,7,2.]],threshold:2.7052e-003,right_val:0.12885,left_val:0.63254},{features:[[3,5,4,12,-1.],[3,9,4,4,3.]],threshold:2.807e-003,right_val:0.61932,left_val:0.12403},{features:[[4,5,12,5,-1.],[8,5,4,5,3.]],threshold:-1.5402e-003,right_val:0.567,left_val:0.14321},{features:[[5,6,10,8,-1.],[5,10,10,4,2.]],threshold:-5.6386e-004,right_val:0.59052,left_val:0.16574},{features:[[8,0,6,9,-1.],[8,3,6,3,3.]],threshold:1.9254e-003,right_val:0.57388,left_val:0.26955},{features:[[9,12,1,8,-1.],[9,16,1,4,2.]],threshold:-5.0215e-003,right_val:0.57828,left_val:0.18935},{features:[[0,7,20,6,-1.],[0,9,20,2,3.]],threshold:2.6365e-003,right_val:0.56954,left_val:0.23093},{features:[[7,0,6,17,-1.],[9,0,2,17,3.]],threshold:-1.5128e-003,right_val:0.59566,left_val:0.27596},{features:[[9,0,6,4,-1.],[11,0,2,4,3.]],threshold:-0.010157,right_val:0.5522,left_val:0.17325},{features:[[5,1,6,4,-1.],[7,1,2,4,3.]],threshold:-0.011954,right_val:0.5559,left_val:0.13394},{features:[[12,1,6,16,-1.],[14,1,2,16,3.]],threshold:4.8859e-003,right_val:0.61888,left_val:0.36287},{features:[[0,5,18,8,-1.],[0,5,9,4,2.],[9,9,9,4,2.]],threshold:-0.080133,right_val:0.54759,left_val:0.091211},{features:[[8,15,10,4,-1.],[13,15,5,2,2.],[8,17,5,2,2.]],threshold:1.0643e-003,right_val:0.57114,left_val:0.37151},{features:[[3,1,4,8,-1.],[3,1,2,4,2.],[5,5,2,4,2.]],threshold:-1.3419e-003,right_val:0.33181,left_val:0.59533},{features:[[3,6,14,10,-1.],[10,6,7,5,2.],[3,11,7,5,2.]],threshold:-0.054601,right_val:0.56028,left_val:0.18441},{features:[[2,1,6,16,-1.],[4,1,2,16,3.]],threshold:2.9072e-003,right_val:0.61317,left_val:0.35942},{features:[[0,18,20,2,-1.],[0,19,20,1,2.]],threshold:7.4719e-004,right_val:0.34596,left_val:0.59944},{features:[[8,13,4,3,-1.],[8,14,4,1,3.]],threshold:4.3014e-003,right_val:0.69908,left_val:0.41727},{features:[[9,14,2,3,-1.],[9,15,2,1,3.]],threshold:4.5018e-003,right_val:0.78015,left_val:0.45097},{features:[[0,12,9,6,-1.],[0,14,9,2,3.]],threshold:0.024139,right_val:0.13198,left_val:0.54382}],threshold:9.4985},{simpleClassifiers:[{features:[[5,7,3,4,-1.],[5,9,3,2,2.]],threshold:1.9212e-003,right_val:0.61999,left_val:0.14153},{features:[[9,3,2,16,-1.],[9,11,2,8,2.]],threshold:-1.2749e-004,right_val:0.18849,left_val:0.61911},{features:[[3,6,13,8,-1.],[3,10,13,4,2.]],threshold:5.141e-004,right_val:0.58579,left_val:0.14874},{features:[[12,3,8,2,-1.],[12,3,4,2,2.]],threshold:4.1879e-003,right_val:0.63592,left_val:0.27469},{features:[[8,8,4,12,-1.],[8,12,4,4,3.]],threshold:5.1016e-003,right_val:0.21756,left_val:0.58709},{features:[[11,3,8,6,-1.],[15,3,4,3,2.],[11,6,4,3,2.]],threshold:-2.1448e-003,right_val:0.29796,left_val:0.58809},{features:[[7,1,6,19,-1.],[9,1,2,19,3.]],threshold:-2.8977e-003,right_val:0.58766,left_val:0.23733},{features:[[9,0,6,4,-1.],[11,0,2,4,3.]],threshold:-0.021611,right_val:0.51942,left_val:0.12207},{features:[[3,1,9,3,-1.],[6,1,3,3,3.]],threshold:-4.6299e-003,right_val:0.58174,left_val:0.26312},{features:[[8,15,10,4,-1.],[13,15,5,2,2.],[8,17,5,2,2.]],threshold:5.9394e-004,right_val:0.56985,left_val:0.36386},{features:[[0,3,6,10,-1.],[3,3,3,10,2.]],threshold:0.053879,right_val:0.75594,left_val:0.43035},{features:[[3,4,15,15,-1.],[3,9,15,5,3.]],threshold:1.8887e-003,right_val:0.56134,left_val:0.21226},{features:[[6,5,8,6,-1.],[6,7,8,2,3.]],threshold:-2.3635e-003,right_val:0.26428,left_val:0.56318},{features:[[4,4,12,10,-1.],[10,4,6,5,2.],[4,9,6,5,2.]],threshold:0.024018,right_val:0.27517,left_val:0.57971},{features:[[6,4,4,4,-1.],[8,4,2,4,2.]],threshold:2.0543e-004,right_val:0.57526,left_val:0.27052},{features:[[15,11,1,2,-1.],[15,12,1,1,2.]],threshold:8.479e-004,right_val:0.23349,left_val:0.54356},{features:[[3,11,2,2,-1.],[3,12,2,1,2.]],threshold:1.4091e-003,right_val:0.20632,left_val:0.53194},{features:[[16,11,1,3,-1.],[16,12,1,1,3.]],threshold:1.4643e-003,right_val:0.30689,left_val:0.5419},{features:[[3,15,6,4,-1.],[3,15,3,2,2.],[6,17,3,2,2.]],threshold:1.6353e-003,right_val:0.61129,left_val:0.36954},{features:[[6,7,8,2,-1.],[6,8,8,1,2.]],threshold:8.3173e-004,right_val:0.60252,left_val:0.3565},{features:[[3,11,1,3,-1.],[3,12,1,1,3.]],threshold:-2.0999e-003,right_val:0.53628,left_val:0.1914},{features:[[6,0,12,2,-1.],[6,1,12,1,2.]],threshold:-7.4214e-004,right_val:0.55293,left_val:0.38356},{features:[[9,14,2,3,-1.],[9,15,2,1,3.]],threshold:3.2655e-003,right_val:0.71019,left_val:0.43129},{features:[[7,15,6,2,-1.],[7,16,6,1,2.]],threshold:8.9135e-004,right_val:0.6392,left_val:0.39848},{features:[[0,5,4,6,-1.],[0,7,4,2,3.]],threshold:-0.015284,right_val:0.54337,left_val:0.23667},{features:[[4,12,12,2,-1.],[8,12,4,2,3.]],threshold:4.8381e-003,right_val:0.32392,left_val:0.58175},{features:[[6,3,1,9,-1.],[6,6,1,3,3.]],threshold:-9.1093e-004,right_val:0.29119,left_val:0.55406},{features:[[10,17,3,2,-1.],[11,17,1,2,3.]],threshold:-6.1275e-003,right_val:0.51966,left_val:0.17753},{features:[[9,9,2,2,-1.],[9,10,2,1,2.]],threshold:-4.4576e-004,right_val:0.55336,left_val:0.30242},{features:[[7,6,6,4,-1.],[9,6,2,4,3.]],threshold:0.022647,right_val:0.69754,left_val:0.44149},{features:[[7,17,3,2,-1.],[8,17,1,2,3.]],threshold:-1.8805e-003,right_val:0.5498,left_val:0.27914},{features:[[10,17,3,3,-1.],[11,17,1,3,3.]],threshold:7.0889e-003,right_val:0.23855,left_val:0.52632},{features:[[8,12,3,2,-1.],[8,13,3,1,2.]],threshold:1.7318e-003,right_val:0.69836,left_val:0.43194},{features:[[9,3,6,2,-1.],[11,3,2,2,3.]],threshold:-6.8483e-003,right_val:0.53909,left_val:0.3082},{features:[[3,11,14,4,-1.],[3,13,14,2,2.]],threshold:-1.5063e-005,right_val:0.31204,left_val:0.55219},{features:[[1,10,18,4,-1.],[10,10,9,2,2.],[1,12,9,2,2.]],threshold:0.029476,right_val:0.17706,left_val:0.54013},{features:[[0,10,3,3,-1.],[0,11,3,1,3.]],threshold:8.1387e-003,right_val:0.1211,left_val:0.51786},{features:[[9,1,6,6,-1.],[11,1,2,6,3.]],threshold:0.020943,right_val:0.33112,left_val:0.52903},{features:[[8,7,3,6,-1.],[9,7,1,6,3.]],threshold:-9.5666e-003,right_val:0.4452,left_val:0.7472}],threshold:18.413},{simpleClassifiers:[{features:[[1,0,18,9,-1.],[1,3,18,3,3.]],threshold:-2.8207e-004,right_val:0.60767,left_val:0.20641},{features:[[12,10,2,6,-1.],[12,13,2,3,2.]],threshold:1.6791e-003,right_val:0.12554,left_val:0.5852},{features:[[0,5,19,8,-1.],[0,9,19,4,2.]],threshold:6.9828e-004,right_val:0.5729,left_val:0.094018},{features:[[7,0,6,9,-1.],[9,0,2,9,3.]],threshold:7.8959e-004,right_val:0.56943,left_val:0.1782},{features:[[5,3,6,1,-1.],[7,3,2,1,3.]],threshold:-2.856e-003,right_val:0.57887,left_val:0.16384},{features:[[11,3,6,1,-1.],[13,3,2,1,3.]],threshold:-3.8122e-003,right_val:0.55086,left_val:0.20854},{features:[[5,10,4,6,-1.],[5,13,4,3,2.]],threshold:1.5897e-003,right_val:0.18572,left_val:0.57028},{features:[[11,3,6,1,-1.],[13,3,2,1,3.]],threshold:0.010078,right_val:0.21898,left_val:0.51169},{features:[[4,4,12,6,-1.],[4,6,12,2,3.]],threshold:-0.063526,right_val:0.40438,left_val:0.71314},{features:[[15,12,2,6,-1.],[15,14,2,2,3.]],threshold:-9.1031e-003,right_val:0.5464,left_val:0.25672},{features:[[9,3,2,2,-1.],[10,3,1,2,2.]],threshold:-2.4035e-003,right_val:0.5591,left_val:0.17007},{features:[[9,3,3,1,-1.],[10,3,1,1,3.]],threshold:1.5226e-003,right_val:0.26191,left_val:0.54106},{features:[[1,1,4,14,-1.],[3,1,2,14,2.]],threshold:0.017997,right_val:0.65352,left_val:0.37324},{features:[[9,0,4,4,-1.],[11,0,2,2,2.],[9,2,2,2,2.]],threshold:-6.4538e-003,right_val:0.55374,left_val:0.26265},{features:[[7,5,1,14,-1.],[7,12,1,7,2.]],threshold:-0.011881,right_val:0.55447,left_val:0.20038},{features:[[19,0,1,4,-1.],[19,2,1,2,2.]],threshold:1.2714e-003,right_val:0.3032,left_val:0.55919},{features:[[5,5,6,4,-1.],[8,5,3,4,2.]],threshold:1.1376e-003,right_val:0.56465,left_val:0.27304},{features:[[9,18,3,2,-1.],[10,18,1,2,3.]],threshold:-4.2652e-003,right_val:0.54618,left_val:0.14059},{features:[[8,18,3,2,-1.],[9,18,1,2,3.]],threshold:-2.9603e-003,right_val:0.54593,left_val:0.1795},{features:[[4,5,12,6,-1.],[4,7,12,2,3.]],threshold:-8.8448e-003,right_val:0.28092,left_val:0.57368},{features:[[3,12,2,6,-1.],[3,14,2,2,3.]],threshold:-6.6431e-003,right_val:0.55038,left_val:0.23707},{features:[[10,8,2,12,-1.],[10,12,2,4,3.]],threshold:3.9998e-003,right_val:0.33043,left_val:0.56082},{features:[[7,18,3,2,-1.],[8,18,1,2,3.]],threshold:-4.1222e-003,right_val:0.5379,left_val:0.16401},{features:[[9,0,6,2,-1.],[11,0,2,2,3.]],threshold:0.015625,right_val:0.22886,left_val:0.52276},{features:[[5,11,9,3,-1.],[5,12,9,1,3.]],threshold:-0.010356,right_val:0.42529,left_val:0.70162},{features:[[9,0,6,2,-1.],[11,0,2,2,3.]],threshold:-8.7961e-003,right_val:0.53558,left_val:0.27673},{features:[[1,1,18,5,-1.],[7,1,6,5,3.]],threshold:0.16227,right_val:0.74426,left_val:0.43422},{features:[[8,0,4,4,-1.],[10,0,2,2,2.],[8,2,2,2,2.]],threshold:4.5543e-003,right_val:0.25821,left_val:0.57265},{features:[[3,12,1,3,-1.],[3,13,1,1,3.]],threshold:-2.1309e-003,right_val:0.5361,left_val:0.21068},{features:[[8,14,5,3,-1.],[8,15,5,1,3.]],threshold:-0.013208,right_val:0.45525,left_val:0.75938},{features:[[5,4,10,12,-1.],[5,4,5,6,2.],[10,10,5,6,2.]],threshold:-0.065997,right_val:0.5344,left_val:0.12525},{features:[[9,6,9,12,-1.],[9,10,9,4,3.]],threshold:7.9143e-003,right_val:0.5601,left_val:0.33154},{features:[[2,2,12,14,-1.],[2,2,6,7,2.],[8,9,6,7,2.]],threshold:0.020894,right_val:0.27688,left_val:0.5506}],threshold:15.324},{simpleClassifiers:[{features:[[4,7,12,2,-1.],[8,7,4,2,3.]],threshold:1.1961e-003,right_val:0.61562,left_val:0.17627},{features:[[7,4,6,4,-1.],[7,6,6,2,2.]],threshold:-1.868e-003,right_val:0.18324,left_val:0.61181},{features:[[4,5,11,8,-1.],[4,9,11,4,2.]],threshold:-1.958e-004,right_val:0.57238,left_val:0.099044},{features:[[3,10,16,4,-1.],[3,12,16,2,2.]],threshold:-8.0256e-004,right_val:0.23773,left_val:0.55799},{features:[[0,0,16,2,-1.],[0,1,16,1,2.]],threshold:-2.4511e-003,right_val:0.58589,left_val:0.22315},{features:[[7,5,6,2,-1.],[9,5,2,2,3.]],threshold:5.0362e-004,right_val:0.57941,left_val:0.2654},{features:[[3,2,6,10,-1.],[3,2,3,5,2.],[6,7,3,5,2.]],threshold:4.0293e-003,right_val:0.24849,left_val:0.58038},{features:[[10,5,8,15,-1.],[10,10,8,5,3.]],threshold:-0.014452,right_val:0.54842,left_val:0.18304},{features:[[3,14,8,6,-1.],[3,14,4,3,2.],[7,17,4,3,2.]],threshold:2.0381e-003,right_val:0.60511,left_val:0.33636},{features:[[14,2,2,2,-1.],[14,3,2,1,2.]],threshold:-1.6155e-003,right_val:0.54412,left_val:0.22866},{features:[[1,10,7,6,-1.],[1,13,7,3,2.]],threshold:3.3458e-003,right_val:0.23923,left_val:0.56259},{features:[[15,4,4,3,-1.],[15,4,2,3,2.]],threshold:1.638e-003,right_val:0.59646,left_val:0.3907},{features:[[2,9,14,6,-1.],[2,9,7,3,2.],[9,12,7,3,2.]],threshold:0.030251,right_val:0.15757,left_val:0.52485},{features:[[5,7,10,4,-1.],[5,9,10,2,2.]],threshold:0.037252,right_val:0.67484,left_val:0.41943},{features:[[6,9,8,8,-1.],[6,9,4,4,2.],[10,13,4,4,2.]],threshold:-0.02511,right_val:0.54735,left_val:0.18825},{features:[[14,1,3,2,-1.],[14,2,3,1,2.]],threshold:-5.3099e-003,right_val:0.52271,left_val:0.134},{features:[[1,4,4,2,-1.],[3,4,2,2,2.]],threshold:1.2086e-003,right_val:0.61096,left_val:0.37621},{features:[[11,10,2,8,-1.],[11,14,2,4,2.]],threshold:-0.021908,right_val:0.5404,left_val:0.26631},{features:[[0,0,5,3,-1.],[0,1,5,1,3.]],threshold:5.4117e-003,right_val:0.22323,left_val:0.53636},{features:[[2,5,18,8,-1.],[11,5,9,4,2.],[2,9,9,4,2.]],threshold:0.069946,right_val:0.24537,left_val:0.53582},{features:[[6,6,1,6,-1.],[6,9,1,3,2.]],threshold:3.452e-004,right_val:0.53769,left_val:0.24097},{features:[[19,1,1,3,-1.],[19,2,1,1,3.]],threshold:1.2628e-003,right_val:0.31557,left_val:0.54259},{features:[[7,6,6,6,-1.],[9,6,2,6,3.]],threshold:0.02272,right_val:0.65979,left_val:0.41584},{features:[[19,1,1,3,-1.],[19,2,1,1,3.]],threshold:-1.8111e-003,right_val:0.55052,left_val:0.28113},{features:[[3,13,2,3,-1.],[3,14,2,1,3.]],threshold:3.347e-003,right_val:0.18915,left_val:0.526},{features:[[8,4,8,12,-1.],[12,4,4,6,2.],[8,10,4,6,2.]],threshold:4.0792e-004,right_val:0.33442,left_val:0.56735},{features:[[5,2,6,3,-1.],[7,2,2,3,3.]],threshold:0.012735,right_val:0.23956,left_val:0.53436},{features:[[6,1,9,10,-1.],[6,6,9,5,2.]],threshold:-7.312e-003,right_val:0.40222,left_val:0.60109},{features:[[0,4,6,12,-1.],[2,4,2,12,3.]],threshold:-0.056949,right_val:0.45432,left_val:0.81992},{features:[[15,13,2,3,-1.],[15,14,2,1,3.]],threshold:-5.0117e-003,right_val:0.53577,left_val:0.22003},{features:[[7,14,5,3,-1.],[7,15,5,1,3.]],threshold:6.0334e-003,right_val:0.71818,left_val:0.44131},{features:[[15,13,3,3,-1.],[15,14,3,1,3.]],threshold:3.9437e-003,right_val:0.27917,left_val:0.54789},{features:[[6,14,8,3,-1.],[6,15,8,1,3.]],threshold:-3.6591e-003,right_val:0.39897,left_val:0.63579},{features:[[15,13,3,3,-1.],[15,14,3,1,3.]],threshold:-3.8456e-003,right_val:0.53007,left_val:0.34937},{features:[[2,13,3,3,-1.],[2,14,3,1,3.]],threshold:-7.1926e-003,right_val:0.52297,left_val:0.11196},{features:[[4,7,12,12,-1.],[10,7,6,6,2.],[4,13,6,6,2.]],threshold:-0.052799,right_val:0.54535,left_val:0.23871},{features:[[9,7,2,6,-1.],[10,7,1,6,2.]],threshold:-7.9538e-003,right_val:0.44394,left_val:0.75869},{features:[[8,9,5,2,-1.],[8,10,5,1,2.]],threshold:-2.7344e-003,right_val:0.54893,left_val:0.25655},{features:[[8,6,3,4,-1.],[9,6,1,4,3.]],threshold:-1.8508e-003,right_val:0.42525,left_val:0.67343},{features:[[9,6,2,8,-1.],[9,10,2,4,2.]],threshold:0.015919,right_val:0.22927,left_val:0.54884},{features:[[7,7,3,6,-1.],[8,7,1,6,3.]],threshold:-1.2688e-003,right_val:0.40224,left_val:0.61043},{features:[[11,3,3,3,-1.],[12,3,1,3,3.]],threshold:6.2884e-003,right_val:0.15362,left_val:0.53109},{features:[[5,4,6,1,-1.],[7,4,2,1,3.]],threshold:-6.226e-003,right_val:0.52416,left_val:0.17291},{features:[[5,6,10,3,-1.],[5,7,10,1,3.]],threshold:-0.012133,right_val:0.43252,left_val:0.65978}],threshold:21.011},{simpleClassifiers:[{features:[[7,3,6,9,-1.],[7,6,6,3,3.]],threshold:-3.9185e-003,right_val:0.14693,left_val:0.61034},{features:[[6,7,9,1,-1.],[9,7,3,1,3.]],threshold:1.5971e-003,right_val:0.58965,left_val:0.26324},{features:[[2,8,16,8,-1.],[2,12,16,4,2.]],threshold:0.01778,right_val:0.17604,left_val:0.58729},{features:[[14,6,2,6,-1.],[14,9,2,3,2.]],threshold:6.5335e-004,right_val:0.55961,left_val:0.15678},{features:[[1,5,6,15,-1.],[1,10,6,5,3.]],threshold:-2.8353e-004,right_val:0.5732,left_val:0.19132},{features:[[10,0,6,9,-1.],[10,3,6,3,3.]],threshold:1.6105e-003,right_val:0.56231,left_val:0.29149},{features:[[6,6,7,14,-1.],[6,13,7,7,2.]],threshold:-0.097751,right_val:0.56482,left_val:0.19435},{features:[[13,7,3,6,-1.],[13,9,3,2,3.]],threshold:5.5182e-004,right_val:0.55046,left_val:0.31346},{features:[[1,8,15,4,-1.],[6,8,5,4,3.]],threshold:-0.012858,right_val:0.57601,left_val:0.25365},{features:[[11,2,3,10,-1.],[11,7,3,5,2.]],threshold:4.153e-003,right_val:0.36598,left_val:0.57677},{features:[[3,7,4,6,-1.],[3,9,4,2,3.]],threshold:1.7092e-003,right_val:0.59189,left_val:0.28432},{features:[[13,3,6,10,-1.],[15,3,2,10,3.]],threshold:7.5217e-003,right_val:0.61831,left_val:0.40524},{features:[[5,7,8,10,-1.],[5,7,4,5,2.],[9,12,4,5,2.]],threshold:2.248e-003,right_val:0.31354,left_val:0.57838},{features:[[4,4,12,12,-1.],[10,4,6,6,2.],[4,10,6,6,2.]],threshold:0.052006,right_val:0.19166,left_val:0.55413},{features:[[1,4,6,9,-1.],[3,4,2,9,3.]],threshold:0.012086,right_val:0.66446,left_val:0.40327},{features:[[11,3,2,5,-1.],[11,3,1,5,2.]],threshold:1.4688e-005,right_val:0.57094,left_val:0.3536},{features:[[7,3,2,5,-1.],[8,3,1,5,2.]],threshold:7.1395e-006,right_val:0.56103,left_val:0.30374},{features:[[10,14,2,3,-1.],[10,15,2,1,3.]],threshold:-4.6002e-003,right_val:0.45803,left_val:0.71811},{features:[[5,12,6,2,-1.],[8,12,3,2,2.]],threshold:2.0059e-003,right_val:0.29537,left_val:0.5622},{features:[[9,14,2,3,-1.],[9,15,2,1,3.]],threshold:4.505e-003,right_val:0.7619,left_val:0.46154},{features:[[4,11,12,6,-1.],[4,14,12,3,2.]],threshold:0.011747,right_val:0.17725,left_val:0.53438},{features:[[11,11,5,9,-1.],[11,14,5,3,3.]],threshold:-0.058316,right_val:0.53408,left_val:0.16862},{features:[[6,15,3,2,-1.],[6,16,3,1,2.]],threshold:2.3629e-004,right_val:0.60268,left_val:0.37921},{features:[[11,0,3,5,-1.],[12,0,1,5,3.]],threshold:-7.8156e-003,right_val:0.53243,left_val:0.15129},{features:[[5,5,6,7,-1.],[8,5,3,7,2.]],threshold:-0.010876,right_val:0.53199,left_val:0.20818},{features:[[13,0,1,9,-1.],[13,3,1,3,3.]],threshold:-2.7746e-003,right_val:0.52103,left_val:0.40982},{features:[[3,2,4,8,-1.],[3,2,2,4,2.],[5,6,2,4,2.]],threshold:-7.8276e-004,right_val:0.34788,left_val:0.56933},{features:[[13,12,4,6,-1.],[13,14,4,2,3.]],threshold:0.01387,right_val:0.22577,left_val:0.53268},{features:[[3,12,4,6,-1.],[3,14,4,2,3.]],threshold:-0.023675,right_val:0.52007,left_val:0.15513},{features:[[13,11,3,4,-1.],[13,13,3,2,2.]],threshold:-1.4879e-005,right_val:0.38202,left_val:0.55006},{features:[[4,4,4,3,-1.],[4,5,4,1,3.]],threshold:3.6191e-003,right_val:0.66397,left_val:0.42387},{features:[[7,5,11,8,-1.],[7,9,11,4,2.]],threshold:-0.019817,right_val:0.53824,left_val:0.215},{features:[[7,8,3,4,-1.],[8,8,1,4,3.]],threshold:-3.8154e-003,right_val:0.42153,left_val:0.66757},{features:[[9,1,6,1,-1.],[11,1,2,1,3.]],threshold:-4.9776e-003,right_val:0.53863,left_val:0.22673},{features:[[5,5,3,3,-1.],[5,6,3,1,3.]],threshold:2.2441e-003,right_val:0.68557,left_val:0.43087},{features:[[0,9,20,6,-1.],[10,9,10,3,2.],[0,12,10,3,2.]],threshold:0.012282,right_val:0.34675,left_val:0.58366},{features:[[8,6,3,5,-1.],[9,6,1,5,3.]],threshold:-2.8549e-003,right_val:0.43115,left_val:0.70169},{features:[[11,0,1,3,-1.],[11,1,1,1,3.]],threshold:-3.7876e-003,right_val:0.52249,left_val:0.28953},{features:[[4,2,4,2,-1.],[4,3,4,1,2.]],threshold:-1.2201e-003,right_val:0.54816,left_val:0.29756},{features:[[12,6,4,3,-1.],[12,7,4,1,3.]],threshold:0.010161,right_val:0.81827,left_val:0.48888},{features:[[5,0,6,4,-1.],[7,0,2,4,3.]],threshold:-0.016175,right_val:0.524,left_val:0.14815},{features:[[9,7,3,8,-1.],[10,7,1,8,3.]],threshold:0.019292,right_val:0.73782,left_val:0.47863},{features:[[9,7,2,2,-1.],[10,7,1,2,2.]],threshold:-3.248e-003,right_val:0.44706,left_val:0.73742},{features:[[6,7,14,4,-1.],[13,7,7,2,2.],[6,9,7,2,2.]],threshold:-9.3803e-003,right_val:0.5538,left_val:0.34892},{features:[[0,5,3,6,-1.],[0,7,3,2,3.]],threshold:-0.012606,right_val:0.53154,left_val:0.23797},{features:[[13,11,3,4,-1.],[13,13,3,2,2.]],threshold:-0.025622,right_val:0.51388,left_val:0.19647},{features:[[4,11,3,4,-1.],[4,13,3,2,2.]],threshold:-7.5741e-005,right_val:0.33659,left_val:0.55905},{features:[[5,9,12,8,-1.],[11,9,6,4,2.],[5,13,6,4,2.]],threshold:-0.089211,right_val:0.51626,left_val:0.063405},{features:[[9,12,1,3,-1.],[9,13,1,1,3.]],threshold:-2.767e-003,right_val:0.44907,left_val:0.73235},{features:[[10,15,2,4,-1.],[10,17,2,2,2.]],threshold:2.7153e-004,right_val:0.59855,left_val:0.41148}],threshold:23.919},{simpleClassifiers:[{features:[[7,7,6,1,-1.],[9,7,2,1,3.]],threshold:1.4786e-003,right_val:0.66433,left_val:0.26635},{features:[[12,3,6,6,-1.],[15,3,3,3,2.],[12,6,3,3,2.]],threshold:-1.8742e-003,right_val:0.25185,left_val:0.61438},{features:[[0,4,10,6,-1.],[0,6,10,2,3.]],threshold:-1.7151e-003,right_val:0.23975,left_val:0.57663},{features:[[8,3,8,14,-1.],[12,3,4,7,2.],[8,10,4,7,2.]],threshold:-1.8939e-003,right_val:0.25291,left_val:0.5682},{features:[[4,4,7,15,-1.],[4,9,7,5,3.]],threshold:-5.3006e-003,right_val:0.55561,left_val:0.16407},{features:[[12,2,6,8,-1.],[15,2,3,4,2.],[12,6,3,4,2.]],threshold:-0.046663,right_val:0.47628,left_val:0.61232},{features:[[2,2,6,8,-1.],[2,2,3,4,2.],[5,6,3,4,2.]],threshold:-7.9431e-004,right_val:0.28394,left_val:0.57079},{features:[[2,13,18,7,-1.],[8,13,6,7,3.]],threshold:0.014892,right_val:0.60064,left_val:0.40897},{features:[[4,3,8,14,-1.],[4,3,4,7,2.],[8,10,4,7,2.]],threshold:-1.2047e-003,right_val:0.27053,left_val:0.57125},{features:[[18,1,2,6,-1.],[18,3,2,2,3.]],threshold:6.0619e-003,right_val:0.32622,left_val:0.52625},{features:[[9,11,2,3,-1.],[9,12,2,1,3.]],threshold:-2.5287e-003,right_val:0.41993,left_val:0.68538},{features:[[18,1,2,6,-1.],[18,3,2,2,3.]],threshold:-5.901e-003,right_val:0.54348,left_val:0.32663},{features:[[0,1,2,6,-1.],[0,3,2,2,3.]],threshold:5.6703e-003,right_val:0.2319,left_val:0.54684},{features:[[1,5,18,6,-1.],[1,7,18,2,3.]],threshold:-3.0304e-003,right_val:0.27082,left_val:0.55707},{features:[[0,2,6,7,-1.],[3,2,3,7,2.]],threshold:2.9804e-003,right_val:0.58906,left_val:0.37006},{features:[[7,3,6,14,-1.],[7,10,6,7,2.]],threshold:-0.075841,right_val:0.54199,left_val:0.21401},{features:[[3,7,13,10,-1.],[3,12,13,5,2.]],threshold:0.019263,right_val:0.27266,left_val:0.55268},{features:[[11,15,2,2,-1.],[11,16,2,1,2.]],threshold:1.8888e-004,right_val:0.60172,left_val:0.3958},{features:[[2,11,16,4,-1.],[2,11,8,2,2.],[10,13,8,2,2.]],threshold:0.02937,right_val:0.14358,left_val:0.52414},{features:[[13,7,6,4,-1.],[16,7,3,2,2.],[13,9,3,2,2.]],threshold:1.0418e-003,right_val:0.593,left_val:0.33854},{features:[[6,10,3,9,-1.],[6,13,3,3,3.]],threshold:2.6126e-003,right_val:0.30216,left_val:0.54854},{features:[[14,6,1,6,-1.],[14,9,1,3,2.]],threshold:9.6977e-004,right_val:0.5532,left_val:0.33753},{features:[[5,10,4,1,-1.],[7,10,2,1,2.]],threshold:5.9513e-004,right_val:0.33594,left_val:0.56317},{features:[[3,8,15,5,-1.],[8,8,5,5,3.]],threshold:-0.10157,right_val:0.52304,left_val:0.063735},{features:[[1,6,5,4,-1.],[1,8,5,2,2.]],threshold:0.036157,right_val:0.10295,left_val:0.5137},{features:[[3,1,17,6,-1.],[3,3,17,2,3.]],threshold:3.4624e-003,right_val:0.55583,left_val:0.38793},{features:[[6,7,8,2,-1.],[10,7,4,2,2.]],threshold:0.019555,right_val:0.18759,left_val:0.52501},{features:[[9,7,3,2,-1.],[10,7,1,2,3.]],threshold:-2.3121e-003,right_val:0.46796,left_val:0.6672},{features:[[8,7,3,2,-1.],[9,7,1,2,3.]],threshold:-1.8605e-003,right_val:0.43347,left_val:0.71634},{features:[[8,9,4,2,-1.],[8,10,4,1,2.]],threshold:-9.4026e-004,right_val:0.56502,left_val:0.30214},{features:[[8,8,4,3,-1.],[8,9,4,1,3.]],threshold:-5.2418e-003,right_val:0.52503,left_val:0.182},{features:[[9,5,6,4,-1.],[9,5,3,4,2.]],threshold:1.1729e-004,right_val:0.5446,left_val:0.33892},{features:[[8,13,4,3,-1.],[8,14,4,1,3.]],threshold:1.1879e-003,right_val:0.62536,left_val:0.40853},{features:[[4,7,12,6,-1.],[10,7,6,3,2.],[4,10,6,3,2.]],threshold:-0.010881,right_val:0.57001,left_val:0.33784},{features:[[8,14,4,3,-1.],[8,15,4,1,3.]],threshold:1.7355e-003,right_val:0.6523,left_val:0.42046},{features:[[9,7,3,3,-1.],[9,8,3,1,3.]],threshold:-6.5119e-003,right_val:0.54281,left_val:0.25952},{features:[[7,4,3,8,-1.],[8,4,1,8,3.]],threshold:-1.2136e-003,right_val:0.39779,left_val:0.61651},{features:[[10,0,3,6,-1.],[11,0,1,6,3.]],threshold:-0.010354,right_val:0.52195,left_val:0.1628},{features:[[6,3,4,8,-1.],[8,3,2,8,2.]],threshold:5.5859e-004,right_val:0.55036,left_val:0.31997},{features:[[14,3,6,13,-1.],[14,3,3,13,2.]],threshold:0.0153,right_val:0.61224,left_val:0.4104},{features:[[8,13,3,6,-1.],[8,16,3,3,2.]],threshold:-0.021588,right_val:0.51974,left_val:0.10349},{features:[[14,3,6,13,-1.],[14,3,3,13,2.]],threshold:-0.12835,right_val:0.48931,left_val:0.84939},{features:[[0,7,10,4,-1.],[0,7,5,2,2.],[5,9,5,2,2.]],threshold:-2.2927e-003,right_val:0.54716,left_val:0.31302},{features:[[14,3,6,13,-1.],[14,3,3,13,2.]],threshold:0.079915,right_val:0.6074,left_val:0.48563},{features:[[0,3,6,13,-1.],[3,3,3,13,2.]],threshold:-0.079441,right_val:0.46245,left_val:0.83947},{features:[[9,1,4,1,-1.],[9,1,2,1,2.]],threshold:-5.28e-003,right_val:0.53067,left_val:0.18817},{features:[[8,0,2,1,-1.],[9,0,1,1,2.]],threshold:1.0463e-003,right_val:0.25831,left_val:0.52712},{features:[[10,16,4,4,-1.],[12,16,2,2,2.],[10,18,2,2,2.]],threshold:2.6317e-004,right_val:0.57354,left_val:0.42353},{features:[[9,6,2,3,-1.],[10,6,1,3,2.]],threshold:-3.6173e-003,right_val:0.44954,left_val:0.69344},{features:[[4,5,12,2,-1.],[8,5,4,2,3.]],threshold:0.011422,right_val:0.41382,left_val:0.59009},{features:[[8,7,3,5,-1.],[9,7,1,5,3.]],threshold:-1.9963e-003,right_val:0.43272,left_val:0.64664}],threshold:24.528},{simpleClassifiers:[{features:[[6,4,8,6,-1.],[6,6,8,2,3.]],threshold:-9.9691e-003,right_val:0.24822,left_val:0.61423},{features:[[9,5,2,12,-1.],[9,11,2,6,2.]],threshold:7.3073e-004,right_val:0.2322,left_val:0.5705},{features:[[4,6,6,8,-1.],[4,10,6,4,2.]],threshold:6.4045e-004,right_val:0.58149,left_val:0.21123},{features:[[12,2,8,5,-1.],[12,2,4,5,2.]],threshold:4.5424e-003,right_val:0.58663,left_val:0.29505},{features:[[0,8,18,3,-1.],[0,9,18,1,3.]],threshold:9.2477e-005,right_val:0.57913,left_val:0.2991},{features:[[8,12,4,8,-1.],[8,16,4,4,2.]],threshold:-8.6603e-003,right_val:0.56355,left_val:0.2813},{features:[[0,2,8,5,-1.],[4,2,4,5,2.]],threshold:8.0516e-003,right_val:0.60548,left_val:0.35354},{features:[[13,11,3,4,-1.],[13,13,3,2,2.]],threshold:4.3835e-004,right_val:0.27315,left_val:0.55965},{features:[[5,11,6,1,-1.],[7,11,2,1,3.]],threshold:-9.8169e-005,right_val:0.36386,left_val:0.5978},{features:[[11,3,3,1,-1.],[12,3,1,1,3.]],threshold:-1.1299e-003,right_val:0.54327,left_val:0.27553},{features:[[7,13,5,3,-1.],[7,14,5,1,3.]],threshold:6.4356e-003,right_val:0.70698,left_val:0.43056},{features:[[11,11,7,6,-1.],[11,14,7,3,2.]],threshold:-0.056829,right_val:0.5295,left_val:0.24952},{features:[[2,11,7,6,-1.],[2,14,7,3,2.]],threshold:4.0668e-003,right_val:0.24977,left_val:0.54786},{features:[[12,14,2,6,-1.],[12,16,2,2,3.]],threshold:4.8165e-005,right_val:0.57064,left_val:0.39386},{features:[[8,14,3,3,-1.],[8,15,3,1,3.]],threshold:6.1795e-003,right_val:0.73948,left_val:0.44076},{features:[[11,0,3,5,-1.],[12,0,1,5,3.]],threshold:6.4986e-003,right_val:0.24792,left_val:0.54452},{features:[[6,1,4,9,-1.],[8,1,2,9,2.]],threshold:-1.0211e-003,right_val:0.5339,left_val:0.25448},{features:[[10,3,6,1,-1.],[12,3,2,1,3.]],threshold:-5.4248e-003,right_val:0.53241,left_val:0.27189},{features:[[8,8,3,4,-1.],[8,10,3,2,2.]],threshold:-1.056e-003,right_val:0.55345,left_val:0.31783},{features:[[8,12,4,2,-1.],[8,13,4,1,2.]],threshold:6.6466e-004,right_val:0.65582,left_val:0.42842},{features:[[5,18,4,2,-1.],[5,19,4,1,2.]],threshold:-2.7524e-004,right_val:0.38103,left_val:0.59029},{features:[[2,1,18,6,-1.],[2,3,18,2,3.]],threshold:4.2293e-003,right_val:0.57094,left_val:0.38165},{features:[[6,0,3,2,-1.],[7,0,1,2,3.]],threshold:-3.2868e-003,right_val:0.52595,left_val:0.17477},{features:[[13,8,6,2,-1.],[16,8,3,1,2.],[13,9,3,1,2.]],threshold:1.5612e-004,right_val:0.57256,left_val:0.36017},{features:[[6,10,3,6,-1.],[6,13,3,3,2.]],threshold:-7.3621e-006,right_val:0.30445,left_val:0.54019},{features:[[0,13,20,4,-1.],[10,13,10,2,2.],[0,15,10,2,2.]],threshold:-0.014767,right_val:0.55734,left_val:0.32208},{features:[[7,7,6,5,-1.],[9,7,2,5,3.]],threshold:0.02449,right_val:0.65188,left_val:0.43015},{features:[[11,0,2,2,-1.],[11,1,2,1,2.]],threshold:-3.7652e-004,right_val:0.55982,left_val:0.35646},{features:[[1,8,6,2,-1.],[1,8,3,1,2.],[4,9,3,1,2.]],threshold:7.3658e-006,right_val:0.55619,left_val:0.34908},{features:[[0,2,20,2,-1.],[10,2,10,1,2.],[0,3,10,1,2.]],threshold:-0.0151,right_val:0.53353,left_val:0.17763},{features:[[7,14,5,3,-1.],[7,15,5,1,3.]],threshold:-3.8317e-003,right_val:0.42214,left_val:0.61497},{features:[[7,13,6,6,-1.],[10,13,3,3,2.],[7,16,3,3,2.]],threshold:0.016925,right_val:0.21666,left_val:0.5413},{features:[[9,12,2,3,-1.],[9,13,2,1,3.]],threshold:-3.0478e-003,right_val:0.43546,left_val:0.64495},{features:[[16,11,1,6,-1.],[16,13,1,2,3.]],threshold:3.2141e-003,right_val:0.35232,left_val:0.54002},{features:[[3,11,1,6,-1.],[3,13,1,2,3.]],threshold:-4.0023e-003,right_val:0.53384,left_val:0.27745},{features:[[4,4,14,12,-1.],[11,4,7,6,2.],[4,10,7,6,2.]],threshold:7.4182e-003,right_val:0.37028,left_val:0.56767},{features:[[5,4,3,3,-1.],[5,5,3,1,3.]],threshold:-8.8765e-003,right_val:0.45837,left_val:0.77492},{features:[[12,3,3,3,-1.],[13,3,1,3,3.]],threshold:2.7312e-003,right_val:0.39967,left_val:0.53387},{features:[[6,6,8,3,-1.],[6,7,8,1,3.]],threshold:-2.5082e-003,right_val:0.37775,left_val:0.5612},{features:[[12,3,3,3,-1.],[13,3,1,3,3.]],threshold:-8.0541e-003,right_val:0.51792,left_val:0.29152},{features:[[3,1,4,10,-1.],[3,1,2,5,2.],[5,6,2,5,2.]],threshold:-9.7939e-004,right_val:0.37002,left_val:0.55364},{features:[[5,7,10,2,-1.],[5,7,5,2,2.]],threshold:-5.8746e-003,right_val:0.56794,left_val:0.37544},{features:[[8,7,3,3,-1.],[9,7,1,3,3.]],threshold:-4.4937e-003,right_val:0.44809,left_val:0.70197},{features:[[15,12,2,3,-1.],[15,13,2,1,3.]],threshold:-5.4389e-003,right_val:0.53134,left_val:0.23104},{features:[[7,8,3,4,-1.],[8,8,1,4,3.]],threshold:-7.5095e-004,right_val:0.41293,left_val:0.58649},{features:[[13,4,1,12,-1.],[13,10,1,6,2.]],threshold:1.4529e-005,right_val:0.56196,left_val:0.37324},{features:[[4,5,12,12,-1.],[4,5,6,6,2.],[10,11,6,6,2.]],threshold:0.040758,right_val:0.27205,left_val:0.53121},{features:[[7,14,7,3,-1.],[7,15,7,1,3.]],threshold:6.6506e-003,right_val:0.66935,left_val:0.471},{features:[[3,12,2,3,-1.],[3,13,2,1,3.]],threshold:4.5759e-003,right_val:0.16373,left_val:0.51678},{features:[[3,2,14,2,-1.],[10,2,7,1,2.],[3,3,7,1,2.]],threshold:6.5269e-003,right_val:0.29385,left_val:0.53976},{features:[[0,1,3,10,-1.],[1,1,1,10,3.]],threshold:-0.01366,right_val:0.45322,left_val:0.70865},{features:[[9,0,6,5,-1.],[11,0,2,5,3.]],threshold:0.027359,right_val:0.35892,left_val:0.52065},{features:[[5,7,6,2,-1.],[8,7,3,2,2.]],threshold:6.2198e-004,right_val:0.54411,left_val:0.35071},{features:[[7,1,6,10,-1.],[7,6,6,5,2.]],threshold:-3.3077e-003,right_val:0.40249,left_val:0.58595},{features:[[1,1,18,3,-1.],[7,1,6,3,3.]],threshold:-0.010631,right_val:0.44226,left_val:0.67433},{features:[[16,3,3,6,-1.],[16,5,3,2,3.]],threshold:0.019442,right_val:0.17979,left_val:0.52827}],threshold:27.153},{simpleClassifiers:[{features:[[6,3,7,6,-1.],[6,6,7,3,2.]],threshold:-5.5052e-003,right_val:0.26266,left_val:0.59147},{features:[[4,7,12,2,-1.],[8,7,4,2,3.]],threshold:1.9562e-003,right_val:0.57416,left_val:0.23126},{features:[[0,4,17,10,-1.],[0,9,17,5,2.]],threshold:-8.8925e-003,right_val:0.56267,left_val:0.16565},{features:[[3,4,15,16,-1.],[3,12,15,8,2.]],threshold:0.083638,right_val:0.19573,left_val:0.54234},{features:[[7,15,6,4,-1.],[7,17,6,2,2.]],threshold:1.2282e-003,right_val:0.59925,left_val:0.34179},{features:[[15,2,4,9,-1.],[15,2,2,9,2.]],threshold:5.7629e-003,right_val:0.60799,left_val:0.37196},{features:[[2,3,3,2,-1.],[2,4,3,1,2.]],threshold:-1.6417e-003,right_val:0.55769,left_val:0.25775},{features:[[13,6,7,9,-1.],[13,9,7,3,3.]],threshold:3.4113e-003,right_val:0.55142,left_val:0.29507},{features:[[8,11,4,3,-1.],[8,12,4,1,3.]],threshold:-0.011069,right_val:0.44771,left_val:0.75694},{features:[[0,2,20,6,-1.],[10,2,10,3,2.],[0,5,10,3,2.]],threshold:0.034866,right_val:0.26696,left_val:0.55837},{features:[[3,2,6,10,-1.],[3,2,3,5,2.],[6,7,3,5,2.]],threshold:6.5701e-004,right_val:0.29889,left_val:0.56273},{features:[[13,10,3,4,-1.],[13,12,3,2,2.]],threshold:-0.024339,right_val:0.51089,left_val:0.27712},{features:[[4,10,3,4,-1.],[4,12,3,2,2.]],threshold:5.9435e-004,right_val:0.31203,left_val:0.55807},{features:[[7,5,6,3,-1.],[9,5,2,3,3.]],threshold:2.2972e-003,right_val:0.56791,left_val:0.33303},{features:[[7,6,6,8,-1.],[7,10,6,4,2.]],threshold:-3.7802e-003,right_val:0.53448,left_val:0.29905},{features:[[0,11,20,6,-1.],[0,14,20,3,2.]],threshold:-0.13421,right_val:0.53926,left_val:0.14639},{features:[[4,13,4,6,-1.],[4,13,2,3,2.],[6,16,2,3,2.]],threshold:7.5225e-004,right_val:0.56927,left_val:0.3747},{features:[[6,0,8,12,-1.],[10,0,4,6,2.],[6,6,4,6,2.]],threshold:-0.040546,right_val:0.54843,left_val:0.27547},{features:[[2,0,15,2,-1.],[2,1,15,1,2.]],threshold:1.2573e-003,right_val:0.57561,left_val:0.37446},{features:[[9,12,2,3,-1.],[9,13,2,1,3.]],threshold:-7.425e-003,right_val:0.47282,left_val:0.75139},{features:[[3,12,1,2,-1.],[3,13,1,1,2.]],threshold:5.0908e-004,right_val:0.29323,left_val:0.54049},{features:[[9,11,2,3,-1.],[9,12,2,1,3.]],threshold:-1.2808e-003,right_val:0.42733,left_val:0.61698},{features:[[7,3,3,1,-1.],[8,3,1,1,3.]],threshold:-1.8349e-003,right_val:0.52065,left_val:0.20485},{features:[[17,7,3,6,-1.],[17,9,3,2,3.]],threshold:0.027485,right_val:0.16755,left_val:0.5253},{features:[[7,2,3,2,-1.],[8,2,1,2,3.]],threshold:2.2372e-003,right_val:0.27777,left_val:0.52678},{features:[[11,4,5,3,-1.],[11,5,5,1,3.]],threshold:-8.8635e-003,right_val:0.4812,left_val:0.69546},{features:[[4,4,5,3,-1.],[4,5,5,1,3.]],threshold:4.1754e-003,right_val:0.63492,left_val:0.42919},{features:[[19,3,1,2,-1.],[19,4,1,1,2.]],threshold:-1.7098e-003,right_val:0.53612,left_val:0.29305},{features:[[5,5,4,3,-1.],[5,6,4,1,3.]],threshold:6.5329e-003,right_val:0.74097,left_val:0.44953},{features:[[17,7,3,6,-1.],[17,9,3,2,3.]],threshold:-9.5373e-003,right_val:0.54165,left_val:0.31491},{features:[[0,7,3,6,-1.],[0,9,3,2,3.]],threshold:0.025311,right_val:0.13117,left_val:0.51219},{features:[[14,2,6,9,-1.],[14,5,6,3,3.]],threshold:0.036461,right_val:0.25913,left_val:0.51759},{features:[[0,4,5,6,-1.],[0,6,5,2,3.]],threshold:0.020854,right_val:0.15823,left_val:0.51371},{features:[[10,5,6,2,-1.],[12,5,2,2,3.]],threshold:-8.7208e-004,right_val:0.4399,left_val:0.55743},{features:[[4,5,6,2,-1.],[6,5,2,2,3.]],threshold:-1.5227e-005,right_val:0.37081,left_val:0.55489},{features:[[8,1,4,6,-1.],[8,3,4,2,3.]],threshold:-8.4317e-004,right_val:0.55542,left_val:0.33874},{features:[[0,2,3,6,-1.],[0,4,3,2,3.]],threshold:3.6038e-003,right_val:0.34112,left_val:0.53581},{features:[[6,6,8,3,-1.],[6,7,8,1,3.]],threshold:-6.8058e-003,right_val:0.43459,left_val:0.61252},{features:[[0,1,5,9,-1.],[0,4,5,3,3.]],threshold:-0.047022,right_val:0.51937,left_val:0.23582},{features:[[16,0,4,15,-1.],[16,0,2,15,2.]],threshold:-0.036954,right_val:0.47609,left_val:0.73231},{features:[[1,10,3,2,-1.],[1,11,3,1,2.]],threshold:1.0439e-003,right_val:0.34113,left_val:0.54195},{features:[[14,4,1,10,-1.],[14,9,1,5,2.]],threshold:-2.1051e-004,right_val:0.55549,left_val:0.28217},{features:[[0,1,4,12,-1.],[2,1,2,12,2.]],threshold:-0.080832,right_val:0.46974,left_val:0.91299},{features:[[11,11,4,2,-1.],[11,11,2,2,2.]],threshold:-3.6579e-004,right_val:0.39783,left_val:0.60227},{features:[[5,11,4,2,-1.],[7,11,2,2,2.]],threshold:-1.2546e-004,right_val:0.38455,left_val:0.56132},{features:[[3,8,15,5,-1.],[8,8,5,5,3.]],threshold:-0.068786,right_val:0.53005,left_val:0.22616},{features:[[0,0,6,10,-1.],[3,0,3,10,2.]],threshold:0.012416,right_val:0.58288,left_val:0.40757},{features:[[11,4,3,2,-1.],[12,4,1,2,3.]],threshold:-4.7175e-003,right_val:0.52678,left_val:0.28273},{features:[[8,12,3,8,-1.],[8,16,3,4,2.]],threshold:0.038137,right_val:0.10236,left_val:0.50747},{features:[[8,14,5,3,-1.],[8,15,5,1,3.]],threshold:-2.8168e-003,right_val:0.43597,left_val:0.6169},{features:[[7,14,4,3,-1.],[7,15,4,1,3.]],threshold:8.1304e-003,right_val:0.76061,left_val:0.45244},{features:[[11,4,3,2,-1.],[12,4,1,2,3.]],threshold:6.0056e-003,right_val:0.18597,left_val:0.52404},{features:[[3,15,14,4,-1.],[3,15,7,2,2.],[10,17,7,2,2.]],threshold:0.019139,right_val:0.23321,left_val:0.52094},{features:[[2,2,16,4,-1.],[10,2,8,2,2.],[2,4,8,2,2.]],threshold:0.016446,right_val:0.32642,left_val:0.54507},{features:[[0,8,6,12,-1.],[3,8,3,12,2.]],threshold:-0.037357,right_val:0.45332,left_val:0.6999},{features:[[5,7,10,2,-1.],[5,7,5,2,2.]],threshold:-0.019728,right_val:0.54128,left_val:0.26537},{features:[[9,7,2,5,-1.],[10,7,1,5,2.]],threshold:6.6973e-003,right_val:0.71387,left_val:0.44806},{features:[[13,7,6,4,-1.],[16,7,3,2,2.],[13,9,3,2,2.]],threshold:7.4458e-004,right_val:0.54713,left_val:0.42314},{features:[[0,13,8,2,-1.],[0,14,8,1,2.]],threshold:1.1791e-003,right_val:0.31305,left_val:0.53417},{features:[[13,7,6,4,-1.],[16,7,3,2,2.],[13,9,3,2,2.]],threshold:0.034981,right_val:0.34305,left_val:0.51187},{features:[[1,7,6,4,-1.],[1,7,3,2,2.],[4,9,3,2,2.]],threshold:5.686e-004,right_val:0.54686,left_val:0.35322},{features:[[12,6,1,12,-1.],[12,12,1,6,2.]],threshold:-0.011341,right_val:0.53487,left_val:0.28424},{features:[[9,5,2,6,-1.],[10,5,1,6,2.]],threshold:-6.6228e-003,right_val:0.44927,left_val:0.68836},{features:[[14,12,2,3,-1.],[14,13,2,1,3.]],threshold:-8.016e-003,right_val:0.52243,left_val:0.17099},{features:[[4,12,2,3,-1.],[4,13,2,1,3.]],threshold:1.4207e-003,right_val:0.29934,left_val:0.52908},{features:[[8,12,4,3,-1.],[8,13,4,1,3.]],threshold:-2.7802e-003,right_val:0.44605,left_val:0.64989},{features:[[5,2,2,4,-1.],[5,2,1,2,2.],[6,4,1,2,2.]],threshold:-1.4748e-003,right_val:0.53881,left_val:0.32604},{features:[[5,5,11,3,-1.],[5,6,11,1,3.]],threshold:-0.02383,right_val:0.48012,left_val:0.75289},{features:[[7,6,4,12,-1.],[7,12,4,6,2.]],threshold:6.937e-003,right_val:0.32614,left_val:0.53352},{features:[[12,13,8,5,-1.],[12,13,4,5,2.]],threshold:8.2806e-003,right_val:0.57378,left_val:0.45804},{features:[[7,6,1,12,-1.],[7,12,1,6,2.]],threshold:-0.01044,right_val:0.52338,left_val:0.25923}],threshold:34.554},{simpleClassifiers:[{features:[[1,2,6,3,-1.],[4,2,3,3,2.]],threshold:7.2007e-003,right_val:0.68498,left_val:0.32589},{features:[[9,5,6,10,-1.],[12,5,3,5,2.],[9,10,3,5,2.]],threshold:-2.8594e-003,right_val:0.25378,left_val:0.58389},{features:[[5,5,8,12,-1.],[5,5,4,6,2.],[9,11,4,6,2.]],threshold:6.8581e-004,right_val:0.28124,left_val:0.57081},{features:[[0,7,20,6,-1.],[0,9,20,2,3.]],threshold:7.958e-003,right_val:0.55443,left_val:0.25011},{features:[[4,2,2,2,-1.],[4,3,2,1,2.]],threshold:-1.2124e-003,right_val:0.54334,left_val:0.23854},{features:[[4,18,12,2,-1.],[8,18,4,2,3.]],threshold:7.9426e-003,right_val:0.62208,left_val:0.39551},{features:[[7,4,4,16,-1.],[7,12,4,8,2.]],threshold:2.4631e-003,right_val:0.29924,left_val:0.56397},{features:[[7,6,7,8,-1.],[7,10,7,4,2.]],threshold:-6.0397e-003,right_val:0.54117,left_val:0.21865},{features:[[6,3,3,1,-1.],[7,3,1,1,3.]],threshold:-1.2988e-003,right_val:0.53646,left_val:0.23507},{features:[[11,15,2,4,-1.],[11,17,2,2,2.]],threshold:2.2299e-004,right_val:0.57296,left_val:0.38041},{features:[[3,5,4,8,-1.],[3,9,4,4,2.]],threshold:1.4654e-003,right_val:0.52583,left_val:0.25102},{features:[[7,1,6,12,-1.],[7,7,6,6,2.]],threshold:-8.121e-004,right_val:0.38512,left_val:0.59928},{features:[[4,6,6,2,-1.],[6,6,2,2,3.]],threshold:-1.3836e-003,right_val:0.36366,left_val:0.56814},{features:[[16,4,4,6,-1.],[16,6,4,2,3.]],threshold:-0.027936,right_val:0.53776,left_val:0.14913},{features:[[3,3,5,2,-1.],[3,4,5,1,2.]],threshold:-4.692e-004,right_val:0.55725,left_val:0.36924},{features:[[9,11,2,3,-1.],[9,12,2,1,3.]],threshold:-4.983e-003,right_val:0.45325,left_val:0.67585},{features:[[2,16,4,2,-1.],[2,17,4,1,2.]],threshold:1.8815e-003,right_val:0.29325,left_val:0.5368},{features:[[7,13,6,6,-1.],[10,13,3,3,2.],[7,16,3,3,2.]],threshold:-0.019068,right_val:0.53301,left_val:0.16494},{features:[[7,0,3,4,-1.],[8,0,1,4,3.]],threshold:-4.6907e-003,right_val:0.51194,left_val:0.19639},{features:[[8,15,4,3,-1.],[8,16,4,1,3.]],threshold:5.9777e-003,right_val:0.70084,left_val:0.46712},{features:[[0,4,4,6,-1.],[0,6,4,2,3.]],threshold:-0.033303,right_val:0.51042,left_val:0.11554},{features:[[5,6,12,3,-1.],[9,6,4,3,3.]],threshold:0.090744,right_val:0.13062,left_val:0.51497},{features:[[7,6,6,14,-1.],[9,6,2,14,3.]],threshold:9.3556e-004,right_val:0.54399,left_val:0.36055},{features:[[9,7,3,3,-1.],[10,7,1,3,3.]],threshold:0.014902,right_val:0.76876,left_val:0.48862},{features:[[6,12,2,4,-1.],[6,14,2,2,2.]],threshold:6.1594e-004,right_val:0.32409,left_val:0.53568},{features:[[10,12,7,6,-1.],[10,14,7,2,3.]],threshold:-0.050671,right_val:0.52304,left_val:0.18486},{features:[[1,0,15,2,-1.],[1,1,15,1,2.]],threshold:6.8666e-004,right_val:0.55179,left_val:0.38406},{features:[[14,0,6,6,-1.],[14,0,3,6,2.]],threshold:8.3712e-003,right_val:0.61318,left_val:0.42886},{features:[[5,3,3,1,-1.],[6,3,1,1,3.]],threshold:-1.2953e-003,right_val:0.52807,left_val:0.29137},{features:[[14,0,6,6,-1.],[14,0,3,6,2.]],threshold:-0.041942,right_val:0.4856,left_val:0.75548},{features:[[0,3,20,10,-1.],[0,8,20,5,2.]],threshold:-0.023529,right_val:0.52561,left_val:0.28383},{features:[[14,0,6,6,-1.],[14,0,3,6,2.]],threshold:0.040857,right_val:0.62773,left_val:0.48709},{features:[[0,0,6,6,-1.],[3,0,3,6,2.]],threshold:-0.025407,right_val:0.4575,left_val:0.70997},{features:[[19,15,1,2,-1.],[19,16,1,1,2.]],threshold:-4.1415e-004,right_val:0.54694,left_val:0.40309},{features:[[0,2,4,8,-1.],[2,2,2,8,2.]],threshold:0.021824,right_val:0.67687,left_val:0.4502},{features:[[2,1,18,4,-1.],[11,1,9,2,2.],[2,3,9,2,2.]],threshold:0.014114,right_val:0.37917,left_val:0.54429},{features:[[8,12,1,2,-1.],[8,13,1,1,2.]],threshold:6.7215e-005,right_val:0.58735,left_val:0.42005},{features:[[5,2,10,6,-1.],[10,2,5,3,2.],[5,5,5,3,2.]],threshold:-7.9418e-003,right_val:0.55853,left_val:0.37926},{features:[[9,7,2,4,-1.],[10,7,1,4,2.]],threshold:-7.2144e-003,right_val:0.46035,left_val:0.72531},{features:[[9,7,3,3,-1.],[10,7,1,3,3.]],threshold:2.5817e-003,right_val:0.59002,left_val:0.46933},{features:[[4,5,12,8,-1.],[8,5,4,8,3.]],threshold:0.13409,right_val:0.18088,left_val:0.51492},{features:[[15,15,4,3,-1.],[15,16,4,1,3.]],threshold:2.2963e-003,right_val:0.37179,left_val:0.53997},{features:[[8,18,3,1,-1.],[9,18,1,1,3.]],threshold:-2.1576e-003,right_val:0.51489,left_val:0.24085},{features:[[9,13,4,3,-1.],[9,14,4,1,3.]],threshold:-4.9196e-003,right_val:0.47387,left_val:0.65736},{features:[[7,13,4,3,-1.],[7,14,4,1,3.]],threshold:1.6267e-003,right_val:0.63031,left_val:0.41928},{features:[[19,15,1,2,-1.],[19,16,1,1,2.]],threshold:3.3413e-004,right_val:0.37021,left_val:0.55403},{features:[[0,15,8,4,-1.],[0,17,8,2,2.]],threshold:-0.026698,right_val:0.51014,left_val:0.17109},{features:[[9,3,6,4,-1.],[11,3,2,4,3.]],threshold:-0.030562,right_val:0.51688,left_val:0.19042},{features:[[8,14,4,3,-1.],[8,15,4,1,3.]],threshold:2.8512e-003,right_val:0.63139,left_val:0.44475},{features:[[3,14,14,6,-1.],[3,16,14,2,3.]],threshold:-0.036211,right_val:0.53773,left_val:0.24907},{features:[[6,3,6,6,-1.],[6,6,6,3,2.]],threshold:-2.4115e-003,right_val:0.36642,left_val:0.53812},{features:[[5,11,10,6,-1.],[5,14,10,3,2.]],threshold:-7.7253e-004,right_val:0.35416,left_val:0.55302},{features:[[3,10,3,4,-1.],[4,10,1,4,3.]],threshold:2.9482e-004,right_val:0.56672,left_val:0.41327},{features:[[13,9,2,2,-1.],[13,9,1,2,2.]],threshold:-6.2335e-003,right_val:0.51987,left_val:0.098787},{features:[[5,3,6,4,-1.],[7,3,2,4,3.]],threshold:-0.026275,right_val:0.50281,left_val:0.091127},{features:[[9,7,3,3,-1.],[10,7,1,3,3.]],threshold:5.3212e-003,right_val:0.62227,left_val:0.47266},{features:[[2,12,2,3,-1.],[2,13,2,1,3.]],threshold:-4.1129e-003,right_val:0.51378,left_val:0.21575},{features:[[9,8,3,12,-1.],[9,12,3,4,3.]],threshold:3.2458e-003,right_val:0.37218,left_val:0.54108},{features:[[3,14,4,6,-1.],[3,14,2,3,2.],[5,17,2,3,2.]],threshold:-0.01636,right_val:0.46853,left_val:0.77879},{features:[[16,15,2,2,-1.],[16,16,2,1,2.]],threshold:3.2166e-004,right_val:0.42404,left_val:0.5479},{features:[[2,15,2,2,-1.],[2,16,2,1,2.]],threshold:6.4452e-004,right_val:0.35013,left_val:0.53306},{features:[[8,12,4,3,-1.],[8,13,4,1,3.]],threshold:-7.891e-003,right_val:0.47266,left_val:0.69235},{features:[[0,7,20,1,-1.],[10,7,10,1,2.]],threshold:0.048336,right_val:0.075749,left_val:0.50559},{features:[[7,6,8,3,-1.],[7,6,4,3,2.]],threshold:-7.5178e-004,right_val:0.55386,left_val:0.37837},{features:[[5,7,8,2,-1.],[9,7,4,2,2.]],threshold:-2.4954e-003,right_val:0.53596,left_val:0.30817},{features:[[9,7,3,5,-1.],[10,7,1,5,3.]],threshold:-2.2385e-003,right_val:0.46493,left_val:0.6634},{features:[[8,7,3,5,-1.],[9,7,1,5,3.]],threshold:-1.7988e-003,right_val:0.43472,left_val:0.65968},{features:[[11,1,3,5,-1.],[12,1,1,5,3.]],threshold:8.7861e-003,right_val:0.23156,left_val:0.52318},{features:[[6,2,3,6,-1.],[7,2,1,6,3.]],threshold:3.6715e-003,right_val:0.29774,left_val:0.52043},{features:[[14,14,6,5,-1.],[14,14,3,5,2.]],threshold:-0.035336,right_val:0.48615,left_val:0.72389},{features:[[9,8,2,2,-1.],[9,9,2,1,2.]],threshold:-6.9189e-004,right_val:0.52298,left_val:0.3105},{features:[[10,7,1,3,-1.],[10,8,1,1,3.]],threshold:-3.3946e-003,right_val:0.52102,left_val:0.3139},{features:[[6,6,2,2,-1.],[6,6,1,1,2.],[7,7,1,1,2.]],threshold:9.8569e-004,right_val:0.65851,left_val:0.45366},{features:[[2,11,18,4,-1.],[11,11,9,2,2.],[2,13,9,2,2.]],threshold:-0.050163,right_val:0.51989,left_val:0.18045},{features:[[6,6,2,2,-1.],[6,6,1,1,2.],[7,7,1,1,2.]],threshold:-2.2367e-003,right_val:0.46514,left_val:0.72557},{features:[[0,15,20,2,-1.],[0,16,20,1,2.]],threshold:7.4326e-004,right_val:0.58985,left_val:0.44129},{features:[[4,14,2,3,-1.],[4,15,2,1,3.]],threshold:-9.3485e-004,right_val:0.5366,left_val:0.35001},{features:[[8,14,4,3,-1.],[8,15,4,1,3.]],threshold:0.017498,right_val:0.83153,left_val:0.49122},{features:[[8,7,2,3,-1.],[8,8,2,1,3.]],threshold:-1.52e-003,right_val:0.53706,left_val:0.35703},{features:[[9,10,2,3,-1.],[9,11,2,1,3.]],threshold:7.8004e-004,right_val:0.59673,left_val:0.43538}],threshold:39.107},{simpleClassifiers:[{features:[[5,4,10,4,-1.],[5,6,10,2,2.]],threshold:-9.9946e-003,right_val:0.30545,left_val:0.61626},{features:[[9,7,6,4,-1.],[12,7,3,2,2.],[9,9,3,2,2.]],threshold:-1.1085e-003,right_val:0.31556,left_val:0.58183},{features:[[4,7,3,6,-1.],[4,9,3,2,3.]],threshold:1.0364e-003,right_val:0.56929,left_val:0.25521},{features:[[11,15,4,4,-1.],[13,15,2,2,2.],[11,17,2,2,2.]],threshold:6.8211e-004,right_val:0.59349,left_val:0.36851},{features:[[7,8,4,2,-1.],[7,9,4,1,2.]],threshold:-6.8057e-004,right_val:0.54748,left_val:0.23324},{features:[[13,1,4,3,-1.],[13,1,2,3,2.]],threshold:2.6069e-004,right_val:0.56675,left_val:0.32575},{features:[[5,15,4,4,-1.],[5,15,2,2,2.],[7,17,2,2,2.]],threshold:5.1607e-004,right_val:0.58455,left_val:0.37447},{features:[[9,5,4,7,-1.],[9,5,2,7,2.]],threshold:8.5008e-004,right_val:0.55228,left_val:0.34204},{features:[[5,6,8,3,-1.],[9,6,4,3,2.]],threshold:-1.8608e-003,right_val:0.53754,left_val:0.28044},{features:[[9,9,2,2,-1.],[9,10,2,1,2.]],threshold:-1.5034e-003,right_val:0.5499,left_val:0.25791},{features:[[7,15,5,3,-1.],[7,16,5,1,3.]],threshold:2.3479e-003,right_val:0.63137,left_val:0.41752},{features:[[11,10,4,3,-1.],[11,10,2,3,2.]],threshold:-2.888e-004,right_val:0.40527,left_val:0.58652},{features:[[6,9,8,10,-1.],[6,14,8,5,2.]],threshold:8.9405e-003,right_val:0.23187,left_val:0.52111},{features:[[10,11,6,2,-1.],[10,11,3,2,2.]],threshold:-0.019328,right_val:0.52415,left_val:0.27534},{features:[[4,11,6,2,-1.],[7,11,3,2,2.]],threshold:-2.0202e-004,right_val:0.36772,left_val:0.5723},{features:[[11,3,8,1,-1.],[11,3,4,1,2.]],threshold:2.1179e-003,right_val:0.55424,left_val:0.44661},{features:[[6,3,3,2,-1.],[7,3,1,2,3.]],threshold:-1.7744e-003,right_val:0.5301,left_val:0.28133},{features:[[14,5,6,5,-1.],[14,5,3,5,2.]],threshold:4.2234e-003,right_val:0.57954,left_val:0.43997},{features:[[7,5,2,12,-1.],[7,11,2,6,2.]],threshold:-0.014375,right_val:0.52921,left_val:0.29811},{features:[[8,11,4,3,-1.],[8,12,4,1,3.]],threshold:-0.015349,right_val:0.47482,left_val:0.77052},{features:[[4,1,2,3,-1.],[5,1,1,3,2.]],threshold:1.5152e-005,right_val:0.55769,left_val:0.37188},{features:[[18,3,2,6,-1.],[18,5,2,2,3.]],threshold:-9.1294e-003,right_val:0.52868,left_val:0.36152},{features:[[0,3,2,6,-1.],[0,5,2,2,3.]],threshold:2.2512e-003,right_val:0.34863,left_val:0.53647},{features:[[9,12,2,3,-1.],[9,13,2,1,3.]],threshold:-4.9697e-003,right_val:0.46768,left_val:0.69277},{features:[[7,13,4,3,-1.],[7,14,4,1,3.]],threshold:-0.012829,right_val:0.46607,left_val:0.77122},{features:[[18,0,2,6,-1.],[18,2,2,2,3.]],threshold:-9.366e-003,right_val:0.53513,left_val:0.3375},{features:[[0,0,2,6,-1.],[0,2,2,2,3.]],threshold:3.2452e-003,right_val:0.32896,left_val:0.53252},{features:[[8,14,6,3,-1.],[8,15,6,1,3.]],threshold:-0.011724,right_val:0.47543,left_val:0.68377},{features:[[7,4,2,4,-1.],[8,4,1,4,2.]],threshold:2.9258e-005,right_val:0.53605,left_val:0.35721},{features:[[8,5,4,6,-1.],[8,7,4,2,3.]],threshold:-2.2244e-005,right_val:0.35521,left_val:0.55414},{features:[[6,4,2,2,-1.],[7,4,1,2,2.]],threshold:5.0882e-003,right_val:0.12565,left_val:0.50708},{features:[[3,14,14,4,-1.],[10,14,7,2,2.],[3,16,7,2,2.]],threshold:0.02743,right_val:0.16258,left_val:0.52696},{features:[[6,15,6,2,-1.],[6,15,3,1,2.],[9,16,3,1,2.]],threshold:-6.4143e-003,right_val:0.45842,left_val:0.71456},{features:[[14,15,6,2,-1.],[14,16,6,1,2.]],threshold:3.348e-003,right_val:0.34947,left_val:0.53986},{features:[[2,12,12,8,-1.],[2,16,12,4,2.]],threshold:-0.082635,right_val:0.51602,left_val:0.24392},{features:[[7,7,7,2,-1.],[7,8,7,1,2.]],threshold:1.0262e-003,right_val:0.57679,left_val:0.38869},{features:[[0,2,18,2,-1.],[0,3,18,1,2.]],threshold:-1.6307e-003,right_val:0.53477,left_val:0.33895},{features:[[9,6,2,5,-1.],[9,6,1,5,2.]],threshold:2.4547e-003,right_val:0.63872,left_val:0.46014},{features:[[7,5,3,8,-1.],[8,5,1,8,3.]],threshold:-9.9477e-004,right_val:0.41204,left_val:0.57699},{features:[[9,6,3,4,-1.],[10,6,1,4,3.]],threshold:0.015409,right_val:0.70898,left_val:0.48787},{features:[[4,13,3,2,-1.],[4,14,3,1,2.]],threshold:1.1784e-003,right_val:0.28952,left_val:0.52636},{features:[[9,4,6,3,-1.],[11,4,2,3,3.]],threshold:-0.027702,right_val:0.52196,left_val:0.14988},{features:[[5,4,6,3,-1.],[7,4,2,3,3.]],threshold:-0.029505,right_val:0.49998,left_val:0.024893},{features:[[14,11,5,2,-1.],[14,12,5,1,2.]],threshold:4.5159e-004,right_val:0.40297,left_val:0.54646},{features:[[1,2,6,9,-1.],[3,2,2,9,3.]],threshold:7.1773e-003,right_val:0.58663,left_val:0.42711},{features:[[14,6,6,13,-1.],[14,6,3,13,2.]],threshold:-0.074182,right_val:0.4919,left_val:0.68742},{features:[[3,6,14,8,-1.],[3,6,7,4,2.],[10,10,7,4,2.]],threshold:-0.017254,right_val:0.53487,left_val:0.33707},{features:[[16,0,4,11,-1.],[16,0,2,11,2.]],threshold:0.014852,right_val:0.61299,left_val:0.46268},{features:[[3,4,12,12,-1.],[3,4,6,6,2.],[9,10,6,6,2.]],threshold:0.010002,right_val:0.34235,left_val:0.53461},{features:[[11,4,5,3,-1.],[11,5,5,1,3.]],threshold:2.0138e-003,right_val:0.58243,left_val:0.46438},{features:[[4,11,4,2,-1.],[4,12,4,1,2.]],threshold:1.5135e-003,right_val:0.28561,left_val:0.51964},{features:[[10,7,2,2,-1.],[10,7,1,2,2.]],threshold:3.1381e-003,right_val:0.59585,left_val:0.48382},{features:[[8,7,2,2,-1.],[9,7,1,2,2.]],threshold:-5.145e-003,right_val:0.47414,left_val:0.89203},{features:[[9,17,3,2,-1.],[10,17,1,2,3.]],threshold:-4.4737e-003,right_val:0.53373,left_val:0.20339},{features:[[5,6,3,3,-1.],[5,7,3,1,3.]],threshold:1.9628e-003,right_val:0.67259,left_val:0.45716},{features:[[10,0,3,3,-1.],[11,0,1,3,3.]],threshold:5.426e-003,right_val:0.28457,left_val:0.52711},{features:[[5,6,6,2,-1.],[5,6,3,1,2.],[8,7,3,1,2.]],threshold:4.9611e-004,right_val:0.57186,left_val:0.41383},{features:[[12,16,4,3,-1.],[12,17,4,1,3.]],threshold:9.3729e-003,right_val:0.28048,left_val:0.52252},{features:[[3,12,3,2,-1.],[3,13,3,1,2.]],threshold:6.0501e-004,right_val:0.33145,left_val:0.52368},{features:[[9,12,3,2,-1.],[9,13,3,1,2.]],threshold:5.6793e-004,right_val:0.6277,left_val:0.45311},{features:[[1,11,16,4,-1.],[1,11,8,2,2.],[9,13,8,2,2.]],threshold:0.024644,right_val:0.20171,left_val:0.51309},{features:[[12,4,3,3,-1.],[12,5,3,1,3.]],threshold:-0.01029,right_val:0.48766,left_val:0.77866},{features:[[4,4,5,3,-1.],[4,5,5,1,3.]],threshold:2.0629e-003,right_val:0.58813,left_val:0.42886},{features:[[12,16,4,3,-1.],[12,17,4,1,3.]],threshold:-5.0519e-003,right_val:0.5286,left_val:0.3524},{features:[[5,4,3,3,-1.],[5,5,3,1,3.]],threshold:-5.7693e-003,right_val:0.45881,left_val:0.68411},{features:[[9,0,2,2,-1.],[9,1,2,1,2.]],threshold:-4.579e-004,right_val:0.5486,left_val:0.35655},{features:[[8,9,4,2,-1.],[8,10,4,1,2.]],threshold:-7.5919e-004,right_val:0.52542,left_val:0.33688},{features:[[8,8,4,3,-1.],[8,9,4,1,3.]],threshold:-1.7737e-003,right_val:0.5454,left_val:0.34222},{features:[[0,13,6,3,-1.],[2,13,2,3,3.]],threshold:-8.561e-003,right_val:0.44859,left_val:0.65336},{features:[[16,14,3,2,-1.],[16,15,3,1,2.]],threshold:1.7277e-003,right_val:0.39254,left_val:0.53076},{features:[[1,18,18,2,-1.],[7,18,6,2,3.]],threshold:-0.0282,right_val:0.45886,left_val:0.68575},{features:[[16,14,3,2,-1.],[16,15,3,1,2.]],threshold:-1.7781e-003,right_val:0.53699,left_val:0.40379},{features:[[1,14,3,2,-1.],[1,15,3,1,2.]],threshold:3.3177e-004,right_val:0.37058,left_val:0.53998},{features:[[7,14,6,3,-1.],[7,15,6,1,3.]],threshold:2.6385e-003,right_val:0.64527,left_val:0.46654},{features:[[5,14,8,3,-1.],[5,15,8,1,3.]],threshold:-2.1183e-003,right_val:0.40647,left_val:0.59148},{features:[[10,6,4,14,-1.],[10,6,2,14,2.]],threshold:-0.014773,right_val:0.52948,left_val:0.3642},{features:[[6,6,4,14,-1.],[8,6,2,14,2.]],threshold:-0.016815,right_val:0.5145,left_val:0.26642},{features:[[13,5,2,3,-1.],[13,6,2,1,3.]],threshold:-6.337e-003,right_val:0.48521,left_val:0.67795},{features:[[7,16,6,1,-1.],[9,16,2,1,3.]],threshold:-4.456e-005,right_val:0.41531,left_val:0.5614},{features:[[9,12,3,3,-1.],[9,13,3,1,3.]],threshold:-1.0241e-003,right_val:0.45663,left_val:0.59645},{features:[[7,0,3,3,-1.],[8,0,1,3,3.]],threshold:-2.3162e-003,right_val:0.51882,left_val:0.29761},{features:[[4,0,16,18,-1.],[4,9,16,9,2.]],threshold:0.53218,right_val:0.22026,left_val:0.51878},{features:[[1,1,16,14,-1.],[1,8,16,7,2.]],threshold:-0.16643,right_val:0.50603,left_val:0.1866},{features:[[3,9,15,4,-1.],[8,9,5,4,3.]],threshold:0.11254,right_val:0.1185,left_val:0.52121},{features:[[6,12,7,3,-1.],[6,13,7,1,3.]],threshold:9.3047e-003,right_val:0.68261,left_val:0.45899},{features:[[14,15,2,3,-1.],[14,16,2,1,3.]],threshold:-4.6255e-003,right_val:0.5225,left_val:0.30799},{features:[[2,3,16,14,-1.],[2,3,8,7,2.],[10,10,8,7,2.]],threshold:-0.11116,right_val:0.50808,left_val:0.2101},{features:[[16,2,4,18,-1.],[18,2,2,9,2.],[16,11,2,9,2.]],threshold:-0.010888,right_val:0.47905,left_val:0.57654},{features:[[4,15,2,3,-1.],[4,16,2,1,3.]],threshold:5.8564e-003,right_val:0.15636,left_val:0.50651},{features:[[16,2,4,18,-1.],[18,2,2,9,2.],[16,11,2,9,2.]],threshold:0.054854,right_val:0.72305,left_val:0.49669},{features:[[1,1,8,3,-1.],[1,2,8,1,3.]],threshold:-0.011197,right_val:0.50988,left_val:0.2195},{features:[[8,11,4,3,-1.],[8,12,4,1,3.]],threshold:4.4069e-003,right_val:0.67709,left_val:0.47784},{features:[[5,11,5,9,-1.],[5,14,5,3,3.]],threshold:-0.063665,right_val:0.5081,left_val:0.19364},{features:[[16,0,4,11,-1.],[16,0,2,11,2.]],threshold:-9.8081e-003,right_val:0.48103,left_val:0.59991},{features:[[7,0,6,1,-1.],[9,0,2,1,3.]],threshold:-2.1717e-003,right_val:0.52355,left_val:0.33383},{features:[[16,3,3,7,-1.],[17,3,1,7,3.]],threshold:-0.013316,right_val:0.49192,left_val:0.66171},{features:[[1,3,3,7,-1.],[2,3,1,7,3.]],threshold:2.5442e-003,right_val:0.60822,left_val:0.44887},{features:[[7,8,6,12,-1.],[7,12,6,4,3.]],threshold:0.012038,right_val:0.32924,left_val:0.54094},{features:[[0,0,4,11,-1.],[2,0,2,11,2.]],threshold:-0.020701,right_val:0.4595,left_val:0.68191},{features:[[14,0,6,20,-1.],[14,0,3,20,2.]],threshold:0.027608,right_val:0.57673,left_val:0.46308},{features:[[0,3,1,2,-1.],[0,4,1,1,2.]],threshold:1.2371e-003,right_val:0.2635,left_val:0.51654},{features:[[5,5,10,8,-1.],[10,5,5,4,2.],[5,9,5,4,2.]],threshold:-0.037669,right_val:0.5279,left_val:0.25364},{features:[[4,7,12,4,-1.],[4,7,6,2,2.],[10,9,6,2,2.]],threshold:-1.8057e-003,right_val:0.55175,left_val:0.39852}],threshold:50.61},{simpleClassifiers:[{features:[[2,1,6,4,-1.],[5,1,3,4,2.]],threshold:4.4299e-003,right_val:0.63352,left_val:0.2891},{features:[[9,7,6,4,-1.],[12,7,3,2,2.],[9,9,3,2,2.]],threshold:-2.3813e-003,right_val:0.34775,left_val:0.62118},{features:[[5,6,2,6,-1.],[5,9,2,3,2.]],threshold:2.2916e-003,right_val:0.55821,left_val:0.22544},{features:[[9,16,6,4,-1.],[12,16,3,2,2.],[9,18,3,2,2.]],threshold:9.9458e-004,right_val:0.59301,left_val:0.37117},{features:[[9,4,2,12,-1.],[9,10,2,6,2.]],threshold:7.7165e-004,right_val:0.3348,left_val:0.56517},{features:[[7,1,6,18,-1.],[9,1,2,18,3.]],threshold:-1.1386e-003,right_val:0.55086,left_val:0.30691},{features:[[4,12,12,2,-1.],[8,12,4,2,3.]],threshold:-1.6403e-004,right_val:0.3699,left_val:0.57628},{features:[[8,8,6,2,-1.],[8,9,6,1,2.]],threshold:2.9794e-005,right_val:0.54379,left_val:0.26442},{features:[[8,0,3,6,-1.],[9,0,1,6,3.]],threshold:8.5775e-003,right_val:0.17957,left_val:0.50511},{features:[[11,18,3,2,-1.],[11,19,3,1,2.]],threshold:-2.6033e-004,right_val:0.44468,left_val:0.5827},{features:[[1,1,17,4,-1.],[1,3,17,2,2.]],threshold:-6.1405e-003,right_val:0.5347,left_val:0.31139},{features:[[11,8,4,12,-1.],[11,8,2,12,2.]],threshold:-0.023087,right_val:0.53312,left_val:0.32779},{features:[[8,14,4,3,-1.],[8,15,4,1,3.]],threshold:-0.014244,right_val:0.45881,left_val:0.73817},{features:[[12,3,2,17,-1.],[12,3,1,17,2.]],threshold:0.019487,right_val:0.22745,left_val:0.52566},{features:[[4,7,6,1,-1.],[6,7,2,1,3.]],threshold:-9.6681e-004,right_val:0.3815,left_val:0.55112},{features:[[18,3,2,3,-1.],[18,4,2,1,3.]],threshold:3.1475e-003,right_val:0.25437,left_val:0.54256},{features:[[8,4,3,4,-1.],[8,6,3,2,2.]],threshold:-1.8026e-004,right_val:0.34063,left_val:0.53802},{features:[[4,5,12,10,-1.],[4,10,12,5,2.]],threshold:-6.0266e-003,right_val:0.54206,left_val:0.30358},{features:[[5,18,4,2,-1.],[7,18,2,2,2.]],threshold:4.4463e-004,right_val:0.56601,left_val:0.3991},{features:[[17,2,3,6,-1.],[17,4,3,2,3.]],threshold:2.261e-003,right_val:0.39407,left_val:0.55628},{features:[[7,7,6,6,-1.],[9,7,2,6,3.]],threshold:0.051133,right_val:0.71186,left_val:0.46097},{features:[[17,2,3,6,-1.],[17,4,3,2,3.]],threshold:-0.017786,right_val:0.53221,left_val:0.23162},{features:[[8,0,3,4,-1.],[9,0,1,4,3.]],threshold:-4.968e-003,right_val:0.5122,left_val:0.23308},{features:[[9,14,2,3,-1.],[9,15,2,1,3.]],threshold:2.0668e-003,right_val:0.64555,left_val:0.46574},{features:[[0,12,6,3,-1.],[0,13,6,1,3.]],threshold:7.4414e-003,right_val:0.23616,left_val:0.51544},{features:[[8,14,4,3,-1.],[8,15,4,1,3.]],threshold:-3.6277e-003,right_val:0.44767,left_val:0.62198},{features:[[3,12,2,3,-1.],[3,13,2,1,3.]],threshold:-5.3531e-003,right_val:0.51022,left_val:0.18374},{features:[[5,6,12,7,-1.],[9,6,4,7,3.]],threshold:0.14531,right_val:0.15359,left_val:0.5146},{features:[[0,2,3,6,-1.],[0,4,3,2,3.]],threshold:2.4394e-003,right_val:0.36247,left_val:0.53437},{features:[[14,6,1,3,-1.],[14,7,1,1,3.]],threshold:-3.1283e-003,right_val:0.48456,left_val:0.6215},{features:[[2,0,3,14,-1.],[3,0,1,14,3.]],threshold:1.794e-003,right_val:0.58242,left_val:0.42993},{features:[[12,14,5,6,-1.],[12,16,5,2,3.]],threshold:0.036254,right_val:0.14395,left_val:0.52603},{features:[[4,14,5,6,-1.],[4,16,5,2,3.]],threshold:-5.1747e-003,right_val:0.5287,left_val:0.35065},{features:[[11,10,2,2,-1.],[12,10,1,1,2.],[11,11,1,1,2.]],threshold:6.5383e-004,right_val:0.6122,left_val:0.48096},{features:[[5,0,3,14,-1.],[6,0,1,14,3.]],threshold:-0.02648,right_val:0.50456,left_val:0.11394},{features:[[10,15,2,3,-1.],[10,16,2,1,3.]],threshold:-3.0441e-003,right_val:0.47947,left_val:0.63521},{features:[[0,2,2,3,-1.],[0,3,2,1,3.]],threshold:3.6994e-003,right_val:0.24985,left_val:0.51311},{features:[[5,11,12,6,-1.],[5,14,12,3,2.]],threshold:-3.6763e-004,right_val:0.37095,left_val:0.54214},{features:[[6,11,3,9,-1.],[6,14,3,3,3.]],threshold:-0.041382,right_val:0.50817,left_val:0.1895},{features:[[11,10,2,2,-1.],[12,10,1,1,2.],[11,11,1,1,2.]],threshold:-1.0533e-003,right_val:0.47836,left_val:0.64544},{features:[[5,6,1,3,-1.],[5,7,1,1,3.]],threshold:-2.1649e-003,right_val:0.44998,left_val:0.6215},{features:[[4,9,13,3,-1.],[4,10,13,1,3.]],threshold:-5.6748e-004,right_val:0.54193,left_val:0.37126},{features:[[1,7,15,6,-1.],[6,7,5,6,3.]],threshold:0.17376,right_val:0.12157,left_val:0.50236},{features:[[4,5,12,6,-1.],[8,5,4,6,3.]],threshold:-2.905e-003,right_val:0.53819,left_val:0.32403},{features:[[8,10,4,3,-1.],[8,11,4,1,3.]],threshold:1.23e-003,right_val:0.57035,left_val:0.41655},{features:[[15,14,1,3,-1.],[15,15,1,1,3.]],threshold:-5.4329e-004,right_val:0.55475,left_val:0.3854},{features:[[1,11,5,3,-1.],[1,12,5,1,3.]],threshold:-8.3297e-003,right_val:0.50971,left_val:0.22045},{features:[[7,1,7,12,-1.],[7,7,7,6,2.]],threshold:-1.0418e-004,right_val:0.4303,left_val:0.56071},{features:[[0,1,6,10,-1.],[0,1,3,5,2.],[3,6,3,5,2.]],threshold:0.031205,right_val:0.6982,left_val:0.46217},{features:[[16,1,4,3,-1.],[16,2,4,1,3.]],threshold:7.8944e-003,right_val:0.22691,left_val:0.52696},{features:[[5,5,2,3,-1.],[5,6,2,1,3.]],threshold:-4.3645e-003,right_val:0.4538,left_val:0.63592},{features:[[12,2,3,5,-1.],[13,2,1,5,3.]],threshold:7.6793e-003,right_val:0.27405,left_val:0.52748},{features:[[0,3,4,6,-1.],[0,5,4,2,3.]],threshold:-0.025431,right_val:0.50717,left_val:0.20385},{features:[[8,12,4,2,-1.],[8,13,4,1,2.]],threshold:8.2001e-004,right_val:0.61199,left_val:0.45875},{features:[[8,18,3,1,-1.],[9,18,1,1,3.]],threshold:2.9285e-003,right_val:0.20282,left_val:0.50713},{features:[[11,10,2,2,-1.],[12,10,1,1,2.],[11,11,1,1,2.]],threshold:4.5256e-005,right_val:0.54308,left_val:0.48121},{features:[[7,10,2,2,-1.],[7,10,1,1,2.],[8,11,1,1,2.]],threshold:1.3158e-003,right_val:0.67793,left_val:0.46258},{features:[[11,11,4,4,-1.],[11,13,4,2,2.]],threshold:1.587e-003,right_val:0.34315,left_val:0.53863},{features:[[8,12,3,8,-1.],[9,12,1,8,3.]],threshold:-0.02154,right_val:0.50032,left_val:0.025943},{features:[[13,0,6,3,-1.],[13,1,6,1,3.]],threshold:0.014334,right_val:0.15906,left_val:0.52028},{features:[[8,8,3,4,-1.],[9,8,1,4,3.]],threshold:-8.3881e-003,right_val:0.4648,left_val:0.72825},{features:[[5,7,10,10,-1.],[10,7,5,5,2.],[5,12,5,5,2.]],threshold:9.1907e-003,right_val:0.39232,left_val:0.55624},{features:[[3,18,8,2,-1.],[3,18,4,1,2.],[7,19,4,1,2.]],threshold:-5.8453e-003,right_val:0.46291,left_val:0.68034},{features:[[10,2,6,8,-1.],[12,2,2,8,3.]],threshold:-0.054708,right_val:0.52061,left_val:0.25617},{features:[[4,2,6,8,-1.],[6,2,2,8,3.]],threshold:9.1143e-003,right_val:0.30539,left_val:0.51896},{features:[[11,0,3,7,-1.],[12,0,1,7,3.]],threshold:-0.015575,right_val:0.51691,left_val:0.12951},{features:[[7,11,2,1,-1.],[8,11,1,1,2.]],threshold:-1.2051e-004,right_val:0.42308,left_val:0.57351},{features:[[15,14,1,3,-1.],[15,15,1,1,3.]],threshold:1.2274e-003,right_val:0.40798,left_val:0.52899},{features:[[7,15,2,2,-1.],[7,15,1,1,2.],[8,16,1,1,2.]],threshold:-1.2187e-003,right_val:0.45744,left_val:0.65756},{features:[[15,14,1,3,-1.],[15,15,1,1,3.]],threshold:-3.3257e-003,right_val:0.5195,left_val:0.3628},{features:[[6,0,3,7,-1.],[7,0,1,7,3.]],threshold:-0.013288,right_val:0.50435,left_val:0.12843},{features:[[18,1,2,7,-1.],[18,1,1,7,2.]],threshold:-3.384e-003,right_val:0.47575,left_val:0.62922},{features:[[2,0,8,20,-1.],[2,10,8,10,2.]],threshold:-0.21954,right_val:0.5065,left_val:0.14877},{features:[[3,0,15,6,-1.],[3,2,15,2,3.]],threshold:4.9112e-003,right_val:0.56658,left_val:0.42561},{features:[[4,3,12,2,-1.],[4,4,12,1,2.]],threshold:-1.8745e-004,right_val:0.55869,left_val:0.40041},{features:[[16,0,4,5,-1.],[16,0,2,5,2.]],threshold:-5.2179e-003,right_val:0.48127,left_val:0.60091},{features:[[7,0,3,4,-1.],[8,0,1,4,3.]],threshold:-1.1112e-003,right_val:0.52871,left_val:0.35149},{features:[[16,0,4,5,-1.],[16,0,2,5,2.]],threshold:4.4036e-003,right_val:0.59241,left_val:0.46423},{features:[[1,7,6,13,-1.],[3,7,2,13,3.]],threshold:0.12299,right_val:0.069152,left_val:0.50255},{features:[[16,0,4,5,-1.],[16,0,2,5,2.]],threshold:-0.012314,right_val:0.4934,left_val:0.58846},{features:[[0,0,4,5,-1.],[2,0,2,5,2.]],threshold:4.1471e-003,right_val:0.58935,left_val:0.43722},{features:[[14,12,3,6,-1.],[14,14,3,2,3.]],threshold:-3.5503e-003,right_val:0.53963,left_val:0.43276},{features:[[3,12,3,6,-1.],[3,14,3,2,3.]],threshold:-0.019224,right_val:0.50683,left_val:0.19131},{features:[[16,1,4,3,-1.],[16,2,4,1,3.]],threshold:1.4395e-003,right_val:0.42435,left_val:0.53082},{features:[[8,7,2,10,-1.],[8,7,1,5,2.],[9,12,1,5,2.]],threshold:-6.7752e-003,right_val:0.45401,left_val:0.63654},{features:[[11,11,4,4,-1.],[11,13,4,2,2.]],threshold:7.012e-003,right_val:0.30262,left_val:0.51898},{features:[[0,1,4,3,-1.],[0,2,4,1,3.]],threshold:5.4015e-003,right_val:0.25577,left_val:0.51051},{features:[[13,4,1,3,-1.],[13,5,1,1,3.]],threshold:9.0275e-004,right_val:0.58618,left_val:0.46969},{features:[[7,15,3,5,-1.],[8,15,1,5,3.]],threshold:0.011474,right_val:0.15272,left_val:0.50536},{features:[[9,7,3,5,-1.],[10,7,1,5,3.]],threshold:-6.7023e-003,right_val:0.48906,left_val:0.6509},{features:[[8,7,3,5,-1.],[9,7,1,5,3.]],threshold:-2.0463e-003,right_val:0.45146,left_val:0.62418},{features:[[10,6,4,14,-1.],[10,6,2,14,2.]],threshold:-9.9952e-003,right_val:0.5401,left_val:0.34328},{features:[[0,5,5,6,-1.],[0,7,5,2,3.]],threshold:-0.035701,right_val:0.50741,left_val:0.18781},{features:[[9,5,6,4,-1.],[9,5,3,4,2.]],threshold:4.5585e-004,right_val:0.54026,left_val:0.38053},{features:[[0,0,18,10,-1.],[6,0,6,10,3.]],threshold:-0.054261,right_val:0.45951,left_val:0.68437},{features:[[10,6,4,14,-1.],[10,6,2,14,2.]],threshold:6.06e-003,right_val:0.45005,left_val:0.55029},{features:[[6,6,4,14,-1.],[8,6,2,14,2.]],threshold:-6.4792e-003,right_val:0.53108,left_val:0.33689},{features:[[13,4,1,3,-1.],[13,5,1,1,3.]],threshold:-1.4939e-003,right_val:0.47562,left_val:0.64876},{features:[[5,1,2,3,-1.],[6,1,1,3,2.]],threshold:1.4611e-005,right_val:0.54511,left_val:0.40346},{features:[[18,1,2,18,-1.],[19,1,1,9,2.],[18,10,1,9,2.]],threshold:-7.2322e-003,right_val:0.48247,left_val:0.63869},{features:[[2,1,4,3,-1.],[2,2,4,1,3.]],threshold:-4.0646e-003,right_val:0.51573,left_val:0.29864},{features:[[18,1,2,18,-1.],[19,1,1,9,2.],[18,10,1,9,2.]],threshold:0.030463,right_val:0.716,left_val:0.50222},{features:[[1,14,4,6,-1.],[1,14,2,3,2.],[3,17,2,3,2.]],threshold:-8.0545e-003,right_val:0.46193,left_val:0.64925},{features:[[10,11,7,6,-1.],[10,13,7,2,3.]],threshold:0.039505,right_val:0.24506,left_val:0.51506},{features:[[0,10,6,10,-1.],[0,10,3,5,2.],[3,15,3,5,2.]],threshold:8.453e-003,right_val:0.6394,left_val:0.45737},{features:[[11,0,3,4,-1.],[12,0,1,4,3.]],threshold:-1.1688e-003,right_val:0.54837,left_val:0.38655},{features:[[5,10,5,6,-1.],[5,13,5,3,2.]],threshold:2.8071e-003,right_val:0.27015,left_val:0.51286},{features:[[14,6,1,8,-1.],[14,10,1,4,2.]],threshold:4.7365e-004,right_val:0.53875,left_val:0.40516},{features:[[1,7,18,6,-1.],[1,7,9,3,2.],[10,10,9,3,2.]],threshold:0.011741,right_val:0.37194,left_val:0.5296},{features:[[9,7,2,2,-1.],[9,7,1,2,2.]],threshold:3.1833e-003,right_val:0.68951,left_val:0.47894},{features:[[5,9,4,5,-1.],[7,9,2,5,2.]],threshold:7.0242e-004,right_val:0.39181,left_val:0.53845}],threshold:54.62},{simpleClassifiers:[{features:[[7,6,6,3,-1.],[9,6,2,3,3.]],threshold:0.01706,right_val:0.71425,left_val:0.39485},{features:[[1,0,18,4,-1.],[7,0,6,4,3.]],threshold:0.021841,right_val:0.609,left_val:0.33703},{features:[[7,15,2,4,-1.],[7,17,2,2,2.]],threshold:2.452e-004,right_val:0.59879,left_val:0.35006},{features:[[1,0,19,9,-1.],[1,3,19,3,3.]],threshold:8.3273e-003,right_val:0.56972,left_val:0.32675},{features:[[3,7,3,6,-1.],[3,9,3,2,3.]],threshold:5.7148e-004,right_val:0.55317,left_val:0.30446},{features:[[13,7,4,4,-1.],[15,7,2,2,2.],[13,9,2,2,2.]],threshold:6.7374e-004,right_val:0.56726,left_val:0.365},{features:[[3,7,4,4,-1.],[3,7,2,2,2.],[5,9,2,2,2.]],threshold:3.4682e-005,right_val:0.53887,left_val:0.33135},{features:[[9,6,10,8,-1.],[9,10,10,4,2.]],threshold:-5.8563e-003,right_val:0.54988,left_val:0.26979},{features:[[3,8,14,12,-1.],[3,14,14,6,2.]],threshold:8.5102e-003,right_val:0.27629,left_val:0.52694},{features:[[6,5,10,12,-1.],[11,5,5,6,2.],[6,11,5,6,2.]],threshold:-0.069817,right_val:0.52592,left_val:0.29096},{features:[[9,11,2,3,-1.],[9,12,2,1,3.]],threshold:-8.6114e-004,right_val:0.40737,left_val:0.58926},{features:[[9,5,6,5,-1.],[9,5,3,5,2.]],threshold:9.7149e-004,right_val:0.54159,left_val:0.35236},{features:[[9,4,2,4,-1.],[9,6,2,2,2.]],threshold:-1.4727e-005,right_val:0.35032,left_val:0.5423},{features:[[9,5,6,5,-1.],[9,5,3,5,2.]],threshold:0.04842,right_val:0.34112,left_val:0.51939},{features:[[5,5,6,5,-1.],[8,5,3,5,2.]],threshold:1.3257e-003,right_val:0.53354,left_val:0.31578},{features:[[11,2,6,1,-1.],[13,2,2,1,3.]],threshold:1.4922e-005,right_val:0.55366,left_val:0.44513},{features:[[3,2,6,1,-1.],[5,2,2,1,3.]],threshold:-2.7173e-003,right_val:0.52481,left_val:0.30317},{features:[[13,5,2,3,-1.],[13,6,2,1,3.]],threshold:2.922e-003,right_val:0.6606,left_val:0.47815},{features:[[0,10,1,4,-1.],[0,12,1,2,2.]],threshold:-1.9805e-003,right_val:0.52876,left_val:0.31863},{features:[[13,5,2,3,-1.],[13,6,2,1,3.]],threshold:-4.0012e-003,right_val:0.47499,left_val:0.64136},{features:[[8,18,3,2,-1.],[9,18,1,2,3.]],threshold:-4.3492e-003,right_val:0.5099,left_val:0.15075},{features:[[6,15,9,2,-1.],[6,16,9,1,2.]],threshold:1.3491e-003,right_val:0.58812,left_val:0.43162},{features:[[8,14,4,3,-1.],[8,15,4,1,3.]],threshold:0.018597,right_val:0.90898,left_val:0.47356},{features:[[18,4,2,4,-1.],[18,6,2,2,2.]],threshold:-1.8562e-003,right_val:0.55778,left_val:0.35532},{features:[[5,5,2,3,-1.],[5,6,2,1,3.]],threshold:2.294e-003,right_val:0.65809,left_val:0.45001},{features:[[15,16,3,2,-1.],[15,17,3,1,2.]],threshold:2.9983e-004,right_val:0.39759,left_val:0.56292},{features:[[0,0,3,9,-1.],[0,3,3,3,3.]],threshold:3.5455e-003,right_val:0.36055,left_val:0.53815},{features:[[9,7,3,3,-1.],[9,8,3,1,3.]],threshold:9.6105e-003,right_val:0.17967,left_val:0.5256},{features:[[8,7,3,3,-1.],[8,8,3,1,3.]],threshold:-6.2783e-003,right_val:0.5114,left_val:0.22729},{features:[[9,5,2,6,-1.],[9,5,1,6,2.]],threshold:3.4598e-003,right_val:0.66082,left_val:0.46263},{features:[[8,6,3,4,-1.],[9,6,1,4,3.]],threshold:-1.3112e-003,right_val:0.44369,left_val:0.63175},{features:[[7,6,8,12,-1.],[11,6,4,6,2.],[7,12,4,6,2.]],threshold:2.6876e-003,right_val:0.4054,left_val:0.54211},{features:[[5,6,8,12,-1.],[5,6,4,6,2.],[9,12,4,6,2.]],threshold:3.9118e-003,right_val:0.32735,left_val:0.53585},{features:[[12,4,3,3,-1.],[12,5,3,1,3.]],threshold:-0.014206,right_val:0.49758,left_val:0.77936},{features:[[2,16,3,2,-1.],[2,17,3,1,2.]],threshold:7.1706e-004,right_val:0.35609,left_val:0.52973},{features:[[12,4,3,3,-1.],[12,5,3,1,3.]],threshold:1.6635e-003,right_val:0.58165,left_val:0.46781},{features:[[2,12,6,6,-1.],[2,14,6,2,3.]],threshold:3.3686e-003,right_val:0.34464,left_val:0.52767},{features:[[7,13,6,3,-1.],[7,14,6,1,3.]],threshold:0.0128,right_val:0.74722,left_val:0.48347},{features:[[6,14,6,3,-1.],[6,15,6,1,3.]],threshold:3.3901e-003,right_val:0.64017,left_val:0.45119},{features:[[14,15,5,3,-1.],[14,16,5,1,3.]],threshold:4.7071e-003,right_val:0.35552,left_val:0.53357},{features:[[5,4,3,3,-1.],[5,5,3,1,3.]],threshold:1.4819e-003,right_val:0.57727,left_val:0.42507},{features:[[14,15,5,3,-1.],[14,16,5,1,3.]],threshold:-6.9996e-003,right_val:0.52929,left_val:0.30033},{features:[[5,3,6,2,-1.],[7,3,2,2,3.]],threshold:0.015939,right_val:0.16756,left_val:0.50673},{features:[[8,15,4,3,-1.],[8,16,4,1,3.]],threshold:7.6377e-003,right_val:0.70856,left_val:0.47951},{features:[[1,15,5,3,-1.],[1,16,5,1,3.]],threshold:6.7334e-003,right_val:0.21625,left_val:0.51331},{features:[[8,13,4,6,-1.],[10,13,2,3,2.],[8,16,2,3,2.]],threshold:-0.012859,right_val:0.52514,left_val:0.19388},{features:[[7,8,3,3,-1.],[8,8,1,3,3.]],threshold:-6.2271e-004,right_val:0.41979,left_val:0.56865},{features:[[12,0,5,4,-1.],[12,2,5,2,2.]],threshold:-5.2652e-004,right_val:0.54297,left_val:0.42242},{features:[[0,2,20,2,-1.],[0,2,10,1,2.],[10,3,10,1,2.]],threshold:0.011075,right_val:0.25145,left_val:0.51138},{features:[[1,0,18,4,-1.],[7,0,6,4,3.]],threshold:-0.036728,right_val:0.48496,left_val:0.71947},{features:[[4,3,6,1,-1.],[6,3,2,1,3.]],threshold:-2.8207e-004,right_val:0.53944,left_val:0.38403},{features:[[4,18,13,2,-1.],[4,19,13,1,2.]],threshold:-2.749e-003,right_val:0.45692,left_val:0.59371},{features:[[2,10,3,6,-1.],[2,12,3,2,3.]],threshold:0.010048,right_val:0.28023,left_val:0.51386},{features:[[14,12,6,8,-1.],[17,12,3,4,2.],[14,16,3,4,2.]],threshold:-8.1498e-003,right_val:0.46361,left_val:0.609},{features:[[4,13,10,6,-1.],[4,13,5,3,2.],[9,16,5,3,2.]],threshold:-6.8834e-003,right_val:0.52547,left_val:0.34586},{features:[[14,12,1,2,-1.],[14,13,1,1,2.]],threshold:-1.4039e-005,right_val:0.40821,left_val:0.56931},{features:[[8,13,4,3,-1.],[8,14,4,1,3.]],threshold:1.5498e-003,right_val:0.58065,left_val:0.43505},{features:[[14,12,2,2,-1.],[14,13,2,1,2.]],threshold:-6.7841e-003,right_val:0.51828,left_val:0.14689},{features:[[4,12,2,2,-1.],[4,13,2,1,2.]],threshold:2.1706e-004,right_val:0.34562,left_val:0.52935},{features:[[8,12,9,2,-1.],[8,13,9,1,2.]],threshold:3.1199e-004,right_val:0.59424,left_val:0.46525},{features:[[9,14,2,3,-1.],[9,15,2,1,3.]],threshold:5.4508e-003,right_val:0.70248,left_val:0.46535},{features:[[11,10,3,6,-1.],[11,13,3,3,2.]],threshold:-2.5819e-004,right_val:0.3769,left_val:0.54973},{features:[[5,6,9,12,-1.],[5,12,9,6,2.]],threshold:-0.017443,right_val:0.54575,left_val:0.39191},{features:[[11,10,3,6,-1.],[11,13,3,3,2.]],threshold:-0.045344,right_val:0.51549,left_val:0.16314},{features:[[6,10,3,6,-1.],[6,13,3,3,2.]],threshold:1.9191e-003,right_val:0.27919,left_val:0.51459},{features:[[5,4,11,3,-1.],[5,5,11,1,3.]],threshold:-6.0178e-003,right_val:0.47563,left_val:0.65176},{features:[[7,1,5,10,-1.],[7,6,5,5,2.]],threshold:-4.0721e-003,right_val:0.40927,left_val:0.55147},{features:[[2,8,18,2,-1.],[2,9,18,1,2.]],threshold:3.9855e-004,right_val:0.52856,left_val:0.31652},{features:[[7,17,5,3,-1.],[7,18,5,1,3.]],threshold:-6.5419e-003,right_val:0.46528,left_val:0.68534},{features:[[5,9,12,1,-1.],[9,9,4,1,3.]],threshold:3.4845e-003,right_val:0.45028,left_val:0.54846},{features:[[0,14,6,6,-1.],[0,14,3,3,2.],[3,17,3,3,2.]],threshold:-0.013697,right_val:0.45726,left_val:0.63958},{features:[[5,9,12,1,-1.],[9,9,4,1,3.]],threshold:-0.017347,right_val:0.51816,left_val:0.27511},{features:[[3,9,12,1,-1.],[7,9,4,1,3.]],threshold:-4.0885e-003,right_val:0.5195,left_val:0.33256},{features:[[14,10,6,7,-1.],[14,10,3,7,2.]],threshold:-9.4688e-003,right_val:0.48518,left_val:0.59423},{features:[[1,0,16,2,-1.],[1,1,16,1,2.]],threshold:1.7085e-003,right_val:0.55198,left_val:0.41671},{features:[[10,9,10,9,-1.],[10,12,10,3,3.]],threshold:9.4809e-003,right_val:0.42085,left_val:0.54339},{features:[[0,1,10,2,-1.],[5,1,5,2,2.]],threshold:-4.739e-003,right_val:0.45607,left_val:0.64072},{features:[[17,3,2,3,-1.],[17,4,2,1,3.]],threshold:6.5761e-003,right_val:0.22582,left_val:0.52146},{features:[[1,3,2,3,-1.],[1,4,2,1,3.]],threshold:-2.1691e-003,right_val:0.51567,left_val:0.31515},{features:[[9,7,3,6,-1.],[10,7,1,6,3.]],threshold:0.01466,right_val:0.66899,left_val:0.48708},{features:[[6,5,4,3,-1.],[8,5,2,3,2.]],threshold:1.7232e-004,right_val:0.52511,left_val:0.35697},{features:[[7,5,6,6,-1.],[9,5,2,6,3.]],threshold:-0.021804,right_val:0.49663,left_val:0.88259},{features:[[3,4,12,12,-1.],[3,4,6,6,2.],[9,10,6,6,2.]],threshold:-0.094736,right_val:0.50611,left_val:0.14462},{features:[[9,2,6,15,-1.],[11,2,2,15,3.]],threshold:5.5826e-003,right_val:0.42381,left_val:0.53965},{features:[[2,2,6,17,-1.],[4,2,2,17,3.]],threshold:1.9517e-003,right_val:0.54978,left_val:0.41704},{features:[[14,10,6,7,-1.],[14,10,3,7,2.]],threshold:0.01215,right_val:0.56643,left_val:0.46984},{features:[[0,10,6,7,-1.],[3,10,3,7,2.]],threshold:-7.517e-003,right_val:0.44631,left_val:0.62678},{features:[[9,2,6,15,-1.],[11,2,2,15,3.]],threshold:-0.071668,right_val:0.5221,left_val:0.3097},{features:[[5,2,6,15,-1.],[7,2,2,15,3.]],threshold:-0.088292,right_val:0.50064,left_val:0.081124},{features:[[17,9,3,6,-1.],[17,11,3,2,3.]],threshold:0.031063,right_val:0.12823,left_val:0.51555},{features:[[6,7,6,6,-1.],[8,7,2,6,3.]],threshold:0.046622,right_val:0.7364,left_val:0.46998},{features:[[1,10,18,6,-1.],[10,10,9,3,2.],[1,13,9,3,2.]],threshold:-0.012189,right_val:0.5519,left_val:0.39205},{features:[[0,9,10,9,-1.],[0,12,10,3,3.]],threshold:0.013016,right_val:0.36851,left_val:0.52607},{features:[[8,15,4,3,-1.],[8,16,4,1,3.]],threshold:-3.4953e-003,right_val:0.47163,left_val:0.63393},{features:[[5,12,3,4,-1.],[5,14,3,2,2.]],threshold:-4.4015e-005,right_val:0.37762,left_val:0.5333},{features:[[3,3,16,12,-1.],[3,9,16,6,2.]],threshold:-0.10966,right_val:0.51983,left_val:0.17653},{features:[[1,1,12,12,-1.],[1,1,6,6,2.],[7,7,6,6,2.]],threshold:-9.028e-004,right_val:0.38389,left_val:0.53242},{features:[[10,4,2,4,-1.],[11,4,1,2,2.],[10,6,1,2,2.]],threshold:7.1127e-004,right_val:0.57552,left_val:0.46479},{features:[[0,9,10,2,-1.],[0,9,5,1,2.],[5,10,5,1,2.]],threshold:-3.125e-003,right_val:0.51668,left_val:0.32367},{features:[[9,11,3,3,-1.],[9,12,3,1,3.]],threshold:2.4145e-003,right_val:0.64597,left_val:0.47874},{features:[[3,12,9,2,-1.],[3,13,9,1,2.]],threshold:4.4391e-004,right_val:0.60103,left_val:0.44093},{features:[[9,9,2,2,-1.],[9,10,2,1,2.]],threshold:-2.2611e-004,right_val:0.54933,left_val:0.40381}],threshold:50.17},{simpleClassifiers:[{features:[[3,4,13,6,-1.],[3,6,13,2,3.]],threshold:-0.046901,right_val:0.37438,left_val:0.66002},{features:[[9,7,6,4,-1.],[12,7,3,2,2.],[9,9,3,2,2.]],threshold:-1.4568e-003,right_val:0.34378,left_val:0.5784},{features:[[1,0,6,8,-1.],[4,0,3,8,2.]],threshold:5.5598e-003,right_val:0.59082,left_val:0.36223},{features:[[9,5,2,12,-1.],[9,11,2,6,2.]],threshold:7.317e-004,right_val:0.28736,left_val:0.55004},{features:[[4,4,3,10,-1.],[4,9,3,5,2.]],threshold:1.3318e-003,right_val:0.5431,left_val:0.26732},{features:[[6,17,8,3,-1.],[6,18,8,1,3.]],threshold:2.4347e-004,right_val:0.57414,left_val:0.3855},{features:[[0,5,10,6,-1.],[0,7,10,2,3.]],threshold:-3.0512e-003,right_val:0.34628,left_val:0.55032},{features:[[13,2,3,2,-1.],[13,3,3,1,2.]],threshold:-6.8657e-004,right_val:0.54295,left_val:0.32912},{features:[[7,5,4,5,-1.],[9,5,2,5,2.]],threshold:1.4668e-003,right_val:0.53518,left_val:0.35884},{features:[[12,14,3,6,-1.],[12,16,3,2,3.]],threshold:3.2022e-004,right_val:0.57002,left_val:0.42968},{features:[[1,11,8,2,-1.],[1,12,8,1,2.]],threshold:7.4122e-004,right_val:0.33669,left_val:0.52822},{features:[[7,13,6,3,-1.],[7,14,6,1,3.]],threshold:3.833e-003,right_val:0.62573,left_val:0.45596},{features:[[0,5,3,6,-1.],[0,7,3,2,3.]],threshold:-0.015456,right_val:0.51295,left_val:0.23501},{features:[[13,2,3,2,-1.],[13,3,3,1,2.]],threshold:2.6797e-003,right_val:0.41551,left_val:0.53294},{features:[[4,14,4,6,-1.],[4,14,2,3,2.],[6,17,2,3,2.]],threshold:2.8297e-003,right_val:0.58045,left_val:0.42731},{features:[[13,2,3,2,-1.],[13,3,3,1,2.]],threshold:-3.9444e-003,right_val:0.52027,left_val:0.29126},{features:[[8,2,4,12,-1.],[8,6,4,4,3.]],threshold:2.718e-003,right_val:0.35857,left_val:0.53077},{features:[[14,0,6,8,-1.],[17,0,3,4,2.],[14,4,3,4,2.]],threshold:5.9078e-003,right_val:0.59416,left_val:0.47038},{features:[[7,17,3,2,-1.],[8,17,1,2,3.]],threshold:-4.224e-003,right_val:0.50888,left_val:0.21416},{features:[[8,12,4,2,-1.],[8,13,4,1,2.]],threshold:4.0726e-003,right_val:0.68411,left_val:0.47664},{features:[[6,0,8,12,-1.],[6,0,4,6,2.],[10,6,4,6,2.]],threshold:0.01015,right_val:0.37485,left_val:0.53608},{features:[[14,0,2,10,-1.],[15,0,1,5,2.],[14,5,1,5,2.]],threshold:-1.8865e-004,right_val:0.38538,left_val:0.57201},{features:[[5,3,8,6,-1.],[5,3,4,3,2.],[9,6,4,3,2.]],threshold:-4.8864e-003,right_val:0.5341,left_val:0.36931},{features:[[14,0,6,10,-1.],[17,0,3,5,2.],[14,5,3,5,2.]],threshold:0.026158,right_val:0.606,left_val:0.49624},{features:[[9,14,1,2,-1.],[9,15,1,1,2.]],threshold:4.8561e-004,right_val:0.60125,left_val:0.44389},{features:[[15,10,4,3,-1.],[15,11,4,1,3.]],threshold:0.011269,right_val:0.18404,left_val:0.52443},{features:[[8,14,2,3,-1.],[8,15,2,1,3.]],threshold:-2.8115e-003,right_val:0.44099,left_val:0.60603},{features:[[3,13,14,4,-1.],[10,13,7,2,2.],[3,15,7,2,2.]],threshold:-5.6113e-003,right_val:0.55892,left_val:0.38912},{features:[[1,10,4,3,-1.],[1,11,4,1,3.]],threshold:8.568e-003,right_val:0.20626,left_val:0.50693},{features:[[9,11,6,1,-1.],[11,11,2,1,3.]],threshold:-3.8173e-004,right_val:0.41926,left_val:0.58822},{features:[[5,11,6,1,-1.],[7,11,2,1,3.]],threshold:-1.768e-004,right_val:0.40034,left_val:0.55336},{features:[[3,5,16,15,-1.],[3,10,16,5,3.]],threshold:6.5113e-003,right_val:0.54442,left_val:0.33101},{features:[[6,12,4,2,-1.],[8,12,2,2,2.]],threshold:-6.5949e-005,right_val:0.39449,left_val:0.54338},{features:[[4,4,12,10,-1.],[10,4,6,5,2.],[4,9,6,5,2.]],threshold:6.9939e-003,right_val:0.41927,left_val:0.56004},{features:[[8,6,3,4,-1.],[9,6,1,4,3.]],threshold:-4.6744e-003,right_val:0.4605,left_val:0.66855},{features:[[8,12,4,8,-1.],[10,12,2,4,2.],[8,16,2,4,2.]],threshold:0.01159,right_val:0.29268,left_val:0.53571},{features:[[8,14,4,3,-1.],[8,15,4,1,3.]],threshold:0.013008,right_val:0.73075,left_val:0.46798},{features:[[12,2,3,2,-1.],[13,2,1,2,3.]],threshold:-1.1009e-003,right_val:0.54151,left_val:0.39375},{features:[[8,15,3,2,-1.],[8,16,3,1,2.]],threshold:6.0473e-004,right_val:0.5604,left_val:0.42424},{features:[[6,0,9,14,-1.],[9,0,3,14,3.]],threshold:-0.014495,right_val:0.52932,left_val:0.36312},{features:[[9,6,2,3,-1.],[10,6,1,3,2.]],threshold:-5.3057e-003,right_val:0.46218,left_val:0.68605},{features:[[10,8,2,3,-1.],[10,9,2,1,3.]],threshold:-8.1829e-004,right_val:0.54204,left_val:0.39441},{features:[[0,9,4,6,-1.],[0,11,4,2,3.]],threshold:-0.019078,right_val:0.50379,left_val:0.19626},{features:[[6,0,8,2,-1.],[6,1,8,1,2.]],threshold:3.5549e-004,right_val:0.5614,left_val:0.40863},{features:[[6,14,7,3,-1.],[6,15,7,1,3.]],threshold:1.968e-003,right_val:0.59261,left_val:0.44891},{features:[[8,10,8,9,-1.],[8,13,8,3,3.]],threshold:6.9189e-003,right_val:0.37284,left_val:0.53359},{features:[[5,2,3,2,-1.],[6,2,1,2,3.]],threshold:2.9873e-003,right_val:0.29756,left_val:0.51113},{features:[[14,1,6,8,-1.],[17,1,3,4,2.],[14,5,3,4,2.]],threshold:-6.2265e-003,right_val:0.48245,left_val:0.55415},{features:[[0,1,6,8,-1.],[0,1,3,4,2.],[3,5,3,4,2.]],threshold:0.013353,right_val:0.64148,left_val:0.45864},{features:[[1,2,18,6,-1.],[10,2,9,3,2.],[1,5,9,3,2.]],threshold:0.033505,right_val:0.343,left_val:0.53924},{features:[[9,3,2,1,-1.],[10,3,1,1,2.]],threshold:-2.5294e-003,right_val:0.50133,left_val:0.17037},{features:[[13,2,4,6,-1.],[15,2,2,3,2.],[13,5,2,3,2.]],threshold:-1.2802e-003,right_val:0.46974,left_val:0.53055},{features:[[5,4,3,3,-1.],[5,5,3,1,3.]],threshold:7.0687e-003,right_val:0.64365,left_val:0.46155},{features:[[13,5,1,3,-1.],[13,6,1,1,3.]],threshold:9.688e-004,right_val:0.60439,left_val:0.48336},{features:[[2,16,5,3,-1.],[2,17,5,1,3.]],threshold:3.9648e-003,right_val:0.32318,left_val:0.51876},{features:[[13,2,4,6,-1.],[15,2,2,3,2.],[13,5,2,3,2.]],threshold:-0.022058,right_val:0.5201,left_val:0.40793},{features:[[3,2,4,6,-1.],[3,2,2,3,2.],[5,5,2,3,2.]],threshold:-6.6906e-004,right_val:0.38156,left_val:0.53316},{features:[[13,5,1,2,-1.],[13,6,1,1,2.]],threshold:-6.7009e-004,right_val:0.46889,left_val:0.56554},{features:[[5,5,2,2,-1.],[5,6,2,1,2.]],threshold:7.4285e-004,right_val:0.62874,left_val:0.45344},{features:[[13,9,2,2,-1.],[13,9,1,2,2.]],threshold:2.2228e-003,right_val:0.33037,left_val:0.53506},{features:[[5,9,2,2,-1.],[6,9,1,2,2.]],threshold:-5.4131e-003,right_val:0.50054,left_val:0.11137},{features:[[13,17,3,2,-1.],[13,18,3,1,2.]],threshold:-1.452e-005,right_val:0.43251,left_val:0.56287},{features:[[6,16,4,4,-1.],[6,16,2,2,2.],[8,18,2,2,2.]],threshold:2.3369e-004,right_val:0.54478,left_val:0.41658},{features:[[9,16,2,3,-1.],[9,17,2,1,3.]],threshold:4.2895e-003,right_val:0.67786,left_val:0.48604},{features:[[0,13,9,6,-1.],[0,15,9,2,3.]],threshold:5.9103e-003,right_val:0.36121,left_val:0.52623},{features:[[9,14,2,6,-1.],[9,17,2,3,2.]],threshold:0.012901,right_val:0.32503,left_val:0.53194},{features:[[9,15,2,3,-1.],[9,16,2,1,3.]],threshold:4.6983e-003,right_val:0.66659,left_val:0.46182},{features:[[1,10,18,6,-1.],[1,12,18,2,3.]],threshold:0.01044,right_val:0.38836,left_val:0.55057},{features:[[8,11,4,2,-1.],[8,12,4,1,2.]],threshold:3.0443e-003,right_val:0.73018,left_val:0.46979},{features:[[7,9,6,2,-1.],[7,10,6,1,2.]],threshold:-6.1594e-004,right_val:0.5465,left_val:0.38308},{features:[[8,8,2,3,-1.],[8,9,2,1,3.]],threshold:-3.4247e-003,right_val:0.50895,left_val:0.25663},{features:[[17,5,3,4,-1.],[18,5,1,4,3.]],threshold:-9.3539e-003,right_val:0.49408,left_val:0.647},{features:[[1,19,18,1,-1.],[7,19,6,1,3.]],threshold:0.052339,right_val:0.78788,left_val:0.4746},{features:[[9,0,3,2,-1.],[10,0,1,2,3.]],threshold:3.5766e-003,right_val:0.27485,left_val:0.53067},{features:[[1,8,1,6,-1.],[1,10,1,2,3.]],threshold:7.1555e-004,right_val:0.40419,left_val:0.54131},{features:[[12,17,8,3,-1.],[12,17,4,3,2.]],threshold:-0.010517,right_val:0.48153,left_val:0.61585},{features:[[0,5,3,4,-1.],[1,5,1,4,3.]],threshold:7.7348e-003,right_val:0.7029,left_val:0.46958},{features:[[9,7,2,3,-1.],[9,8,2,1,3.]],threshold:-4.3227e-003,right_val:0.53047,left_val:0.28496},{features:[[7,11,2,2,-1.],[7,11,1,1,2.],[8,12,1,1,2.]],threshold:-2.5534e-003,right_val:0.46889,left_val:0.7057},{features:[[11,3,2,5,-1.],[11,3,1,5,2.]],threshold:1.0269e-004,right_val:0.55735,left_val:0.39029},{features:[[7,3,2,5,-1.],[8,3,1,5,2.]],threshold:7.1395e-006,right_val:0.5264,left_val:0.36842},{features:[[15,13,2,3,-1.],[15,14,2,1,3.]],threshold:-1.6712e-003,right_val:0.53873,left_val:0.38492},{features:[[5,6,2,3,-1.],[5,7,2,1,3.]],threshold:4.926e-003,right_val:0.74473,left_val:0.47298},{features:[[4,19,15,1,-1.],[9,19,5,1,3.]],threshold:4.3909e-003,right_val:0.55919,left_val:0.48092},{features:[[1,19,15,1,-1.],[6,19,5,1,3.]],threshold:-0.017794,right_val:0.46769,left_val:0.69037},{features:[[15,13,2,3,-1.],[15,14,2,1,3.]],threshold:2.047e-003,right_val:0.33082,left_val:0.53707},{features:[[5,0,4,15,-1.],[7,0,2,15,2.]],threshold:0.029891,right_val:0.33091,left_val:0.51399},{features:[[9,6,2,5,-1.],[9,6,1,5,2.]],threshold:1.5495e-003,right_val:0.60783,left_val:0.46602},{features:[[9,5,2,7,-1.],[10,5,1,7,2.]],threshold:1.4957e-003,right_val:0.58639,left_val:0.44048},{features:[[16,11,3,3,-1.],[16,12,3,1,3.]],threshold:9.5886e-004,right_val:0.42085,left_val:0.5436},{features:[[1,11,3,3,-1.],[1,12,3,1,3.]],threshold:4.9644e-004,right_val:0.40006,left_val:0.53706},{features:[[6,6,8,3,-1.],[6,7,8,1,3.]],threshold:-2.7281e-003,right_val:0.42596,left_val:0.56594},{features:[[0,15,6,2,-1.],[0,16,6,1,2.]],threshold:2.3026e-003,right_val:0.33509,left_val:0.51617},{features:[[1,0,18,6,-1.],[7,0,6,6,3.]],threshold:0.25152,right_val:0.71473,left_val:0.48697},{features:[[6,0,3,4,-1.],[7,0,1,4,3.]],threshold:-4.6328e-003,right_val:0.50838,left_val:0.27274},{features:[[14,10,4,10,-1.],[16,10,2,5,2.],[14,15,2,5,2.]],threshold:-0.040434,right_val:0.50218,left_val:0.68514},{features:[[3,2,3,2,-1.],[4,2,1,2,3.]],threshold:1.4972e-005,right_val:0.55226,left_val:0.42845},{features:[[11,2,2,2,-1.],[11,3,2,1,2.]],threshold:-2.405e-004,right_val:0.53901,left_val:0.42261},{features:[[2,10,4,10,-1.],[2,10,2,5,2.],[4,15,2,5,2.]],threshold:0.023658,right_val:0.75044,left_val:0.47446},{features:[[0,13,20,6,-1.],[10,13,10,3,2.],[0,16,10,3,2.]],threshold:-8.1449e-003,right_val:0.55384,left_val:0.42451},{features:[[0,5,2,15,-1.],[1,5,1,15,2.]],threshold:-3.6992e-003,right_val:0.45297,left_val:0.59524},{features:[[1,7,18,4,-1.],[10,7,9,2,2.],[1,9,9,2,2.]],threshold:-6.7719e-003,right_val:0.54734,left_val:0.41378},{features:[[0,0,2,17,-1.],[1,0,1,17,2.]],threshold:4.267e-003,right_val:0.5798,left_val:0.44841},{features:[[2,6,16,6,-1.],[10,6,8,3,2.],[2,9,8,3,2.]],threshold:1.7792e-003,right_val:0.44324,left_val:0.56249},{features:[[8,14,1,3,-1.],[8,15,1,1,3.]],threshold:1.6775e-003,right_val:0.63642,left_val:0.46378},{features:[[8,15,4,2,-1.],[8,16,4,1,2.]],threshold:1.1733e-003,right_val:0.59144,left_val:0.45445},{features:[[5,2,8,2,-1.],[5,2,4,1,2.],[9,3,4,1,2.]],threshold:8.6998e-004,right_val:0.38859,left_val:0.53348},{features:[[6,11,8,6,-1.],[6,14,8,3,2.]],threshold:7.6378e-004,right_val:0.37449,left_val:0.53986},{features:[[9,13,2,2,-1.],[9,14,2,1,2.]],threshold:1.5685e-004,right_val:0.56146,left_val:0.43179},{features:[[18,4,2,6,-1.],[18,6,2,2,3.]],threshold:-0.021511,right_val:0.51855,left_val:0.17859},{features:[[9,12,2,2,-1.],[9,13,2,1,2.]],threshold:1.3081e-004,right_val:0.56828,left_val:0.43425},{features:[[18,4,2,6,-1.],[18,6,2,2,3.]],threshold:0.021992,right_val:0.23794,left_val:0.51617},{features:[[9,13,1,3,-1.],[9,14,1,1,3.]],threshold:-8.0137e-004,right_val:0.44664,left_val:0.59868},{features:[[18,4,2,6,-1.],[18,6,2,2,3.]],threshold:-8.2736e-003,right_val:0.52511,left_val:0.41082},{features:[[0,4,2,6,-1.],[0,6,2,2,3.]],threshold:3.6832e-003,right_val:0.33975,left_val:0.51738},{features:[[9,12,3,3,-1.],[9,13,3,1,3.]],threshold:-7.9526e-003,right_val:0.48459,left_val:0.6889},{features:[[3,13,2,3,-1.],[3,14,2,1,3.]],threshold:1.5382e-003,right_val:0.34541,left_val:0.51786},{features:[[13,13,4,3,-1.],[13,14,4,1,3.]],threshold:-0.014044,right_val:0.51887,left_val:0.16784},{features:[[5,4,3,3,-1.],[5,5,3,1,3.]],threshold:1.4316e-003,right_val:0.56558,left_val:0.43683},{features:[[5,2,10,6,-1.],[5,4,10,2,3.]],threshold:-0.034014,right_val:0.49592,left_val:0.78023},{features:[[3,13,4,3,-1.],[3,14,4,1,3.]],threshold:-0.012027,right_val:0.50322,left_val:0.15851},{features:[[3,7,15,5,-1.],[8,7,5,5,3.]],threshold:0.13317,right_val:0.27551,left_val:0.51633},{features:[[3,7,12,2,-1.],[7,7,4,2,3.]],threshold:-1.5222e-003,right_val:0.52146,left_val:0.37283},{features:[[10,3,3,9,-1.],[11,3,1,9,3.]],threshold:-9.3929e-004,right_val:0.45112,left_val:0.58384},{features:[[8,6,4,6,-1.],[10,6,2,6,2.]],threshold:0.02772,right_val:0.73315,left_val:0.47283},{features:[[9,7,4,3,-1.],[9,8,4,1,3.]],threshold:3.103e-003,right_val:0.41016,left_val:0.53022},{features:[[0,9,4,9,-1.],[2,9,2,9,2.]],threshold:0.077861,right_val:0.1273,left_val:0.49983},{features:[[9,13,3,5,-1.],[10,13,1,5,3.]],threshold:-0.015855,right_val:0.51657,left_val:0.050833},{features:[[7,7,6,3,-1.],[9,7,2,3,3.]],threshold:-4.9725e-003,right_val:0.46842,left_val:0.67981},{features:[[9,7,3,5,-1.],[10,7,1,5,3.]],threshold:-9.7677e-004,right_val:0.47889,left_val:0.60108},{features:[[5,7,8,2,-1.],[9,7,4,2,2.]],threshold:-2.4648e-003,right_val:0.52205,left_val:0.33934},{features:[[5,9,12,2,-1.],[9,9,4,2,3.]],threshold:-6.7938e-003,right_val:0.52397,left_val:0.43651},{features:[[5,6,10,3,-1.],[10,6,5,3,2.]],threshold:0.032608,right_val:0.24252,left_val:0.50527},{features:[[10,12,3,1,-1.],[11,12,1,1,3.]],threshold:-5.8514e-004,right_val:0.47586,left_val:0.5734},{features:[[0,1,11,15,-1.],[0,6,11,5,3.]],threshold:-0.029633,right_val:0.52636,left_val:0.38923}],threshold:66.669},{simpleClassifiers:[{features:[[1,0,18,6,-1.],[7,0,6,6,3.]],threshold:0.046551,right_val:0.62405,left_val:0.3277},{features:[[7,7,6,1,-1.],[9,7,2,1,3.]],threshold:7.9537e-003,right_val:0.69429,left_val:0.42565},{features:[[5,16,6,4,-1.],[5,16,3,2,2.],[8,18,3,2,2.]],threshold:6.8222e-004,right_val:0.59007,left_val:0.37115},{features:[[6,5,9,8,-1.],[6,9,9,4,2.]],threshold:-1.9348e-004,right_val:0.53005,left_val:0.20411},{features:[[5,10,2,6,-1.],[5,13,2,3,2.]],threshold:-2.6711e-004,right_val:0.31032,left_val:0.54161},{features:[[7,6,8,10,-1.],[11,6,4,5,2.],[7,11,4,5,2.]],threshold:2.7818e-003,right_val:0.34671,left_val:0.52778},{features:[[5,6,8,10,-1.],[5,6,4,5,2.],[9,11,4,5,2.]],threshold:-4.6779e-004,right_val:0.32945,left_val:0.53082},{features:[[9,5,2,2,-1.],[9,6,2,1,2.]],threshold:-3.0335e-005,right_val:0.38521,left_val:0.57739},{features:[[5,12,8,2,-1.],[5,13,8,1,2.]],threshold:7.8038e-004,right_val:0.61501,left_val:0.43174},{features:[[10,2,8,2,-1.],[10,3,8,1,2.]],threshold:-4.2554e-003,right_val:0.53243,left_val:0.29339},{features:[[4,0,2,10,-1.],[4,0,1,5,2.],[5,5,1,5,2.]],threshold:-2.4736e-004,right_val:0.3843,left_val:0.54688},{features:[[9,10,2,2,-1.],[9,11,2,1,2.]],threshold:-1.4724e-004,right_val:0.57556,left_val:0.42815},{features:[[2,8,15,3,-1.],[2,9,15,1,3.]],threshold:1.1865e-003,right_val:0.54715,left_val:0.37473},{features:[[8,13,4,3,-1.],[8,14,4,1,3.]],threshold:2.3937e-003,right_val:0.61115,left_val:0.45378},{features:[[7,2,3,2,-1.],[8,2,1,2,3.]],threshold:-1.5391e-003,right_val:0.51895,left_val:0.29713},{features:[[7,13,6,3,-1.],[7,14,6,1,3.]],threshold:-7.1969e-003,right_val:0.47265,left_val:0.66991},{features:[[9,9,2,2,-1.],[9,10,2,1,2.]],threshold:-4.15e-004,right_val:0.52603,left_val:0.3385},{features:[[17,2,3,6,-1.],[17,4,3,2,3.]],threshold:4.436e-003,right_val:0.39201,left_val:0.53991},{features:[[1,5,3,4,-1.],[2,5,1,4,3.]],threshold:2.6606e-003,right_val:0.61196,left_val:0.44826},{features:[[14,8,4,6,-1.],[14,10,4,2,3.]],threshold:-1.5287e-003,right_val:0.53403,left_val:0.37112},{features:[[1,4,3,8,-1.],[2,4,1,8,3.]],threshold:-4.7397e-003,right_val:0.44551,left_val:0.60311},{features:[[8,13,4,6,-1.],[8,16,4,3,2.]],threshold:-0.014829,right_val:0.53419,left_val:0.28388},{features:[[3,14,2,2,-1.],[3,15,2,1,2.]],threshold:9.2276e-004,right_val:0.33617,left_val:0.52095},{features:[[14,8,4,6,-1.],[14,10,4,2,3.]],threshold:0.08353,right_val:0.081164,left_val:0.512},{features:[[2,8,4,6,-1.],[2,10,4,2,3.]],threshold:-7.5633e-004,right_val:0.51898,left_val:0.33171},{features:[[10,14,1,6,-1.],[10,17,1,3,2.]],threshold:9.8404e-003,right_val:0.2335,left_val:0.52476},{features:[[7,5,3,6,-1.],[8,5,1,6,3.]],threshold:-1.5954e-003,right_val:0.42956,left_val:0.57501},{features:[[11,2,2,6,-1.],[12,2,1,3,2.],[11,5,1,3,2.]],threshold:3.4766e-005,right_val:0.5564,left_val:0.43424},{features:[[6,6,6,5,-1.],[8,6,2,5,3.]],threshold:0.029863,right_val:0.65792,left_val:0.45791},{features:[[17,1,3,6,-1.],[17,3,3,2,3.]],threshold:0.011326,right_val:0.36739,left_val:0.52743},{features:[[8,7,3,5,-1.],[9,7,1,5,3.]],threshold:-8.7829e-003,right_val:0.46422,left_val:0.71004},{features:[[9,18,3,2,-1.],[10,18,1,2,3.]],threshold:4.364e-003,right_val:0.27059,left_val:0.52792},{features:[[8,18,3,2,-1.],[9,18,1,2,3.]],threshold:4.1805e-003,right_val:0.24491,left_val:0.50725},{features:[[12,3,5,2,-1.],[12,4,5,1,2.]],threshold:-4.5669e-004,right_val:0.55487,left_val:0.42831},{features:[[7,1,5,12,-1.],[7,7,5,6,2.]],threshold:-3.714e-003,right_val:0.41037,left_val:0.55194},{features:[[1,0,18,4,-1.],[7,0,6,4,3.]],threshold:-0.025304,right_val:0.48699,left_val:0.6867},{features:[[4,2,2,2,-1.],[4,3,2,1,2.]],threshold:-3.4454e-004,right_val:0.52877,left_val:0.37289},{features:[[11,14,4,2,-1.],[13,14,2,1,2.],[11,15,2,1,2.]],threshold:-8.3935e-004,right_val:0.46161,left_val:0.60602},{features:[[0,2,3,6,-1.],[0,4,3,2,3.]],threshold:0.01728,right_val:0.18198,left_val:0.50496},{features:[[9,7,2,3,-1.],[9,8,2,1,3.]],threshold:-6.3595e-003,right_val:0.52328,left_val:0.16312},{features:[[5,5,1,3,-1.],[5,6,1,1,3.]],threshold:1.0298e-003,right_val:0.61765,left_val:0.44633},{features:[[10,10,6,1,-1.],[10,10,3,1,2.]],threshold:1.0117e-003,right_val:0.43007,left_val:0.54734},{features:[[4,10,6,1,-1.],[7,10,3,1,2.]],threshold:-0.010309,right_val:0.50009,left_val:0.1167},{features:[[9,17,3,3,-1.],[9,18,3,1,3.]],threshold:5.4682e-003,right_val:0.67192,left_val:0.47693},{features:[[4,14,1,3,-1.],[4,15,1,1,3.]],threshold:-9.1696e-004,right_val:0.51782,left_val:0.34711},{features:[[12,5,3,3,-1.],[12,6,3,1,3.]],threshold:2.3923e-003,right_val:0.62163,left_val:0.47852},{features:[[4,5,12,3,-1.],[4,6,12,1,3.]],threshold:-7.5574e-003,right_val:0.44101,left_val:0.58148},{features:[[9,8,2,3,-1.],[9,9,2,1,3.]],threshold:-7.7024e-004,right_val:0.54657,left_val:0.3878},{features:[[4,9,3,3,-1.],[5,9,1,3,3.]],threshold:-8.7126e-003,right_val:0.49958,left_val:0.16601},{features:[[6,0,9,17,-1.],[9,0,3,17,3.]],threshold:-0.010306,right_val:0.52742,left_val:0.40934},{features:[[9,12,1,3,-1.],[9,13,1,1,3.]],threshold:-2.0941e-003,right_val:0.45723,left_val:0.62062},{features:[[9,5,2,15,-1.],[9,10,2,5,3.]],threshold:6.8099e-003,right_val:0.41556,left_val:0.55678},{features:[[8,14,2,3,-1.],[8,15,2,1,3.]],threshold:-1.0746e-003,right_val:0.4353,left_val:0.56389},{features:[[10,14,1,3,-1.],[10,15,1,1,3.]],threshold:2.155e-003,right_val:0.67498,left_val:0.48263},{features:[[7,1,6,5,-1.],[9,1,2,5,3.]],threshold:0.031742,right_val:0.18832,left_val:0.50484},{features:[[0,0,20,2,-1.],[0,0,10,2,2.]],threshold:-0.078383,right_val:0.52602,left_val:0.23695},{features:[[2,13,5,3,-1.],[2,14,5,1,3.]],threshold:5.7415e-003,right_val:0.27765,left_val:0.50488},{features:[[9,11,2,3,-1.],[9,12,2,1,3.]],threshold:-2.9015e-003,right_val:0.46933,left_val:0.62386},{features:[[2,5,9,15,-1.],[2,10,9,5,3.]],threshold:-2.6428e-003,right_val:0.51698,left_val:0.33141},{features:[[5,0,12,10,-1.],[11,0,6,5,2.],[5,5,6,5,2.]],threshold:-0.1095,right_val:0.51834,left_val:0.238},{features:[[5,1,2,3,-1.],[6,1,1,3,2.]],threshold:7.4076e-005,right_val:0.53622,left_val:0.40696},{features:[[10,7,6,1,-1.],[12,7,2,1,3.]],threshold:-5.0594e-004,right_val:0.43746,left_val:0.55067},{features:[[3,1,2,10,-1.],[3,1,1,5,2.],[4,6,1,5,2.]],threshold:-8.2132e-004,right_val:0.42094,left_val:0.55257},{features:[[13,7,2,1,-1.],[13,7,1,1,2.]],threshold:-6.0277e-005,right_val:0.47483,left_val:0.54555},{features:[[4,13,4,6,-1.],[4,15,4,2,3.]],threshold:6.8065e-003,right_val:0.34246,left_val:0.5158},{features:[[13,7,2,1,-1.],[13,7,1,1,2.]],threshold:1.7203e-003,right_val:0.63313,left_val:0.50132},{features:[[5,7,2,1,-1.],[6,7,1,1,2.]],threshold:-1.3017e-004,right_val:0.42269,left_val:0.55397},{features:[[2,12,18,4,-1.],[11,12,9,2,2.],[2,14,9,2,2.]],threshold:-4.8016e-003,right_val:0.54308,left_val:0.44251},{features:[[5,7,2,2,-1.],[5,7,1,1,2.],[6,8,1,1,2.]],threshold:-2.5399e-003,right_val:0.46976,left_val:0.71458},{features:[[16,3,4,2,-1.],[16,4,4,1,2.]],threshold:-1.4279e-003,right_val:0.53996,left_val:0.40704},{features:[[0,2,2,18,-1.],[0,2,1,9,2.],[1,11,1,9,2.]],threshold:-0.025143,right_val:0.47474,left_val:0.78847},{features:[[1,2,18,4,-1.],[10,2,9,2,2.],[1,4,9,2,2.]],threshold:-3.89e-003,right_val:0.55771,left_val:0.42962},{features:[[9,14,1,3,-1.],[9,15,1,1,3.]],threshold:4.3947e-003,right_val:0.70239,left_val:0.46932},{features:[[2,12,18,4,-1.],[11,12,9,2,2.],[2,14,9,2,2.]],threshold:0.024678,right_val:0.38125,left_val:0.52423},{features:[[0,12,18,4,-1.],[0,12,9,2,2.],[9,14,9,2,2.]],threshold:0.038048,right_val:0.16878,left_val:0.50117},{features:[[11,4,5,3,-1.],[11,5,5,1,3.]],threshold:7.9425e-003,right_val:0.63696,left_val:0.48286},{features:[[6,4,7,3,-1.],[6,5,7,1,3.]],threshold:-1.511e-003,right_val:0.44877,left_val:0.59065},{features:[[13,17,3,3,-1.],[13,18,3,1,3.]],threshold:6.4202e-003,right_val:0.29906,left_val:0.52411},{features:[[8,1,3,4,-1.],[9,1,1,4,3.]],threshold:-2.9802e-003,right_val:0.50785,left_val:0.30415},{features:[[11,4,2,4,-1.],[11,4,1,4,2.]],threshold:-7.458e-004,right_val:0.52568,left_val:0.41281},{features:[[0,17,9,3,-1.],[3,17,3,3,3.]],threshold:-0.010471,right_val:0.44943,left_val:0.58084},{features:[[11,0,2,8,-1.],[12,0,1,4,2.],[11,4,1,4,2.]],threshold:9.3369e-003,right_val:0.26589,left_val:0.52466},{features:[[0,8,6,12,-1.],[0,8,3,6,2.],[3,14,3,6,2.]],threshold:0.027937,right_val:0.70873,left_val:0.4675},{features:[[10,7,4,12,-1.],[10,13,4,6,2.]],threshold:7.4278e-003,right_val:0.37585,left_val:0.54095},{features:[[5,3,8,14,-1.],[5,10,8,7,2.]],threshold:-0.023585,right_val:0.52386,left_val:0.37586},{features:[[14,10,6,1,-1.],[14,10,3,1,2.]],threshold:1.1453e-003,right_val:0.58042,left_val:0.43296},{features:[[0,4,10,4,-1.],[0,6,10,2,2.]],threshold:-4.3469e-004,right_val:0.38731,left_val:0.52806},{features:[[10,0,5,8,-1.],[10,4,5,4,2.]],threshold:0.010649,right_val:0.56813,left_val:0.49021},{features:[[8,1,4,8,-1.],[8,1,2,4,2.],[10,5,2,4,2.]],threshold:-3.9418e-004,right_val:0.43183,left_val:0.55709},{features:[[9,11,6,1,-1.],[11,11,2,1,3.]],threshold:-1.327e-004,right_val:0.43436,left_val:0.56584},{features:[[8,9,3,4,-1.],[9,9,1,4,3.]],threshold:-2.0126e-003,right_val:0.45375,left_val:0.60567},{features:[[18,4,2,6,-1.],[18,6,2,2,3.]],threshold:2.4854e-003,right_val:0.4138,left_val:0.53905},{features:[[8,8,3,4,-1.],[9,8,1,4,3.]],threshold:1.8238e-003,right_val:0.57172,left_val:0.43548},{features:[[7,1,13,3,-1.],[7,2,13,1,3.]],threshold:-0.016657,right_val:0.52161,left_val:0.30109},{features:[[7,13,6,1,-1.],[9,13,2,1,3.]],threshold:8.035e-004,right_val:0.38184,left_val:0.53002},{features:[[12,11,3,6,-1.],[12,13,3,2,3.]],threshold:3.417e-003,right_val:0.42414,left_val:0.5328},{features:[[5,11,6,1,-1.],[7,11,2,1,3.]],threshold:-3.6223e-004,right_val:0.4187,left_val:0.54917},{features:[[1,4,18,10,-1.],[10,4,9,5,2.],[1,9,9,5,2.]],threshold:-0.1163,right_val:0.52265,left_val:0.14407},{features:[[8,6,4,9,-1.],[8,9,4,3,3.]],threshold:-0.014695,right_val:0.47157,left_val:0.77477},{features:[[8,6,4,3,-1.],[8,7,4,1,3.]],threshold:2.1972e-003,right_val:0.33156,left_val:0.53554},{features:[[8,7,3,3,-1.],[9,7,1,3,3.]],threshold:-4.6965e-004,right_val:0.44581,left_val:0.57672},{features:[[14,15,4,3,-1.],[14,16,4,1,3.]],threshold:6.5145e-003,right_val:0.36479,left_val:0.52157},{features:[[5,10,3,10,-1.],[6,10,1,10,3.]],threshold:0.0213,right_val:0.1568,left_val:0.49942},{features:[[8,15,4,3,-1.],[8,16,4,1,3.]],threshold:3.1881e-003,right_val:0.62873,left_val:0.47422},{features:[[0,8,1,6,-1.],[0,10,1,2,3.]],threshold:9.002e-004,right_val:0.39438,left_val:0.5348},{features:[[10,15,1,3,-1.],[10,16,1,1,3.]],threshold:-5.1772e-003,right_val:0.50131,left_val:0.67272},{features:[[2,15,4,3,-1.],[2,16,4,1,3.]],threshold:-4.3765e-003,right_val:0.51288,left_val:0.31067},{features:[[18,3,2,8,-1.],[19,3,1,4,2.],[18,7,1,4,2.]],threshold:2.63e-003,right_val:0.57552,left_val:0.48863},{features:[[0,3,2,8,-1.],[0,3,1,4,2.],[1,7,1,4,2.]],threshold:-2.0459e-003,right_val:0.45581,left_val:0.60258},{features:[[3,7,14,10,-1.],[10,7,7,5,2.],[3,12,7,5,2.]],threshold:0.069483,right_val:0.21853,left_val:0.52407},{features:[[0,7,19,3,-1.],[0,8,19,1,3.]],threshold:0.024049,right_val:0.20906,left_val:0.50119},{features:[[12,6,3,3,-1.],[12,7,3,1,3.]],threshold:3.1095e-003,right_val:0.71085,left_val:0.48667},{features:[[0,6,1,3,-1.],[0,7,1,1,3.]],threshold:-1.2503e-003,right_val:0.51562,left_val:0.34079},{features:[[12,6,3,3,-1.],[12,7,3,1,3.]],threshold:-1.0281e-003,right_val:0.44394,left_val:0.55756},{features:[[5,6,3,3,-1.],[5,7,3,1,3.]],threshold:-8.8894e-003,right_val:0.46204,left_val:0.6402},{features:[[8,2,4,2,-1.],[8,3,4,1,2.]],threshold:-6.1095e-004,right_val:0.54489,left_val:0.37664},{features:[[6,3,4,12,-1.],[8,3,2,12,2.]],threshold:-5.7686e-003,right_val:0.51337,left_val:0.33186},{features:[[13,6,2,3,-1.],[13,7,2,1,3.]],threshold:1.8506e-003,right_val:0.64069,left_val:0.49036},{features:[[0,10,20,4,-1.],[0,12,20,2,2.]],threshold:-0.099799,right_val:0.50156,left_val:0.15361},{features:[[2,0,17,14,-1.],[2,7,17,7,2.]],threshold:-0.35128,right_val:0.51744,left_val:0.058823},{features:[[0,0,6,10,-1.],[0,0,3,5,2.],[3,5,3,5,2.]],threshold:-0.045245,right_val:0.46779,left_val:0.69615},{features:[[14,6,6,4,-1.],[14,6,3,4,2.]],threshold:0.071482,right_val:0.10381,left_val:0.5168},{features:[[0,6,6,4,-1.],[3,6,3,4,2.]],threshold:2.1896e-003,right_val:0.55321,left_val:0.42731},{features:[[13,2,7,2,-1.],[13,3,7,1,2.]],threshold:-5.9243e-004,right_val:0.52764,left_val:0.46389},{features:[[0,2,7,2,-1.],[0,3,7,1,2.]],threshold:1.6788e-003,right_val:0.3932,left_val:0.53016},{features:[[6,11,14,2,-1.],[13,11,7,1,2.],[6,12,7,1,2.]],threshold:-2.2163e-003,right_val:0.4757,left_val:0.56307},{features:[[8,5,2,2,-1.],[8,5,1,1,2.],[9,6,1,1,2.]],threshold:1.1569e-004,right_val:0.55357,left_val:0.43075},{features:[[13,9,2,3,-1.],[13,9,1,3,2.]],threshold:-7.2017e-003,right_val:0.51931,left_val:0.14449},{features:[[1,1,3,12,-1.],[2,1,1,12,3.]],threshold:8.9081e-004,right_val:0.55936,left_val:0.43844},{features:[[17,4,1,3,-1.],[17,5,1,1,3.]],threshold:1.9605e-004,right_val:0.4706,left_val:0.53404},{features:[[2,4,1,3,-1.],[2,5,1,1,3.]],threshold:5.2022e-004,right_val:0.38101,left_val:0.52139},{features:[[14,5,1,3,-1.],[14,6,1,1,3.]],threshold:9.4589e-004,right_val:0.61307,left_val:0.47694},{features:[[7,16,2,3,-1.],[7,17,2,1,3.]],threshold:9.1698e-005,right_val:0.54294,left_val:0.4245},{features:[[8,13,4,6,-1.],[10,13,2,3,2.],[8,16,2,3,2.]],threshold:2.1833e-003,right_val:0.41911,left_val:0.54577},{features:[[5,5,1,3,-1.],[5,6,1,1,3.]],threshold:-8.604e-004,right_val:0.44717,left_val:0.57646},{features:[[16,0,4,20,-1.],[16,0,2,20,2.]],threshold:-0.013236,right_val:0.4695,left_val:0.63728},{features:[[5,1,2,6,-1.],[5,1,1,3,2.],[6,4,1,3,2.]],threshold:4.3377e-004,right_val:0.39458,left_val:0.53179}],threshold:67.699},{simpleClassifiers:[{features:[[5,4,10,4,-1.],[5,6,10,2,2.]],threshold:-0.024847,right_val:0.38733,left_val:0.65555},{features:[[15,2,4,12,-1.],[15,2,2,12,2.]],threshold:6.1349e-003,right_val:0.5974,left_val:0.37481},{features:[[7,6,4,12,-1.],[7,12,4,6,2.]],threshold:6.4498e-003,right_val:0.25488,left_val:0.54255},{features:[[14,5,1,8,-1.],[14,9,1,4,2.]],threshold:6.3491e-004,right_val:0.53873,left_val:0.24624},{features:[[1,4,14,10,-1.],[1,4,7,5,2.],[8,9,7,5,2.]],threshold:1.4024e-003,right_val:0.35287,left_val:0.55943},{features:[[11,6,6,14,-1.],[14,6,3,7,2.],[11,13,3,7,2.]],threshold:3.0044e-004,right_val:0.57659,left_val:0.39585},{features:[[3,6,6,14,-1.],[3,6,3,7,2.],[6,13,3,7,2.]],threshold:1.0042e-004,right_val:0.5535,left_val:0.3699},{features:[[4,9,15,2,-1.],[9,9,5,2,3.]],threshold:-5.0841e-003,right_val:0.55478,left_val:0.37111},{features:[[7,14,6,3,-1.],[7,15,6,1,3.]],threshold:-0.019537,right_val:0.45793,left_val:0.74928},{features:[[6,3,14,4,-1.],[13,3,7,2,2.],[6,5,7,2,2.]],threshold:-7.4533e-006,right_val:0.39041,left_val:0.56498},{features:[[1,9,15,2,-1.],[6,9,5,2,3.]],threshold:-3.6079e-003,right_val:0.52678,left_val:0.33811},{features:[[6,11,8,9,-1.],[6,14,8,3,3.]],threshold:2.0698e-003,right_val:0.37144,left_val:0.55193},{features:[[7,4,3,8,-1.],[8,4,1,8,3.]],threshold:-4.6464e-004,right_val:0.41136,left_val:0.56082},{features:[[14,6,2,6,-1.],[14,9,2,3,2.]],threshold:7.549e-004,right_val:0.53294,left_val:0.35592},{features:[[5,7,6,4,-1.],[5,7,3,2,2.],[8,9,3,2,2.]],threshold:-9.8322e-004,right_val:0.37632,left_val:0.54148},{features:[[1,1,18,19,-1.],[7,1,6,19,3.]],threshold:-0.019941,right_val:0.47053,left_val:0.63479},{features:[[1,2,6,5,-1.],[4,2,3,5,2.]],threshold:3.768e-003,right_val:0.55637,left_val:0.39135},{features:[[12,17,6,2,-1.],[12,18,6,1,2.]],threshold:-9.4529e-003,right_val:0.52151,left_val:0.25549},{features:[[2,17,6,2,-1.],[2,18,6,1,2.]],threshold:2.9561e-003,right_val:0.30639,left_val:0.51747},{features:[[17,3,3,6,-1.],[17,5,3,2,3.]],threshold:9.1079e-003,right_val:0.2886,left_val:0.53884},{features:[[8,17,3,3,-1.],[8,18,3,1,3.]],threshold:1.8219e-003,right_val:0.58522,left_val:0.4336},{features:[[10,13,2,6,-1.],[10,16,2,3,2.]],threshold:0.014689,right_val:0.287,left_val:0.52874},{features:[[7,13,6,3,-1.],[7,14,6,1,3.]],threshold:-0.014388,right_val:0.46474,left_val:0.70194},{features:[[17,3,3,6,-1.],[17,5,3,2,3.]],threshold:-0.018987,right_val:0.5247,left_val:0.29866},{features:[[8,13,2,3,-1.],[8,14,2,1,3.]],threshold:1.1528e-003,right_val:0.59317,left_val:0.43235},{features:[[9,3,6,2,-1.],[11,3,2,2,3.]],threshold:0.010934,right_val:0.31303,left_val:0.52869},{features:[[0,3,3,6,-1.],[0,5,3,2,3.]],threshold:-0.014933,right_val:0.50841,left_val:0.26584},{features:[[8,5,4,6,-1.],[8,7,4,2,3.]],threshold:-2.9971e-004,right_val:0.37407,left_val:0.54635},{features:[[5,5,3,2,-1.],[5,6,3,1,2.]],threshold:4.1678e-003,right_val:0.74357,left_val:0.47035},{features:[[10,1,3,4,-1.],[11,1,1,4,3.]],threshold:-6.3905e-003,right_val:0.52805,left_val:0.20693},{features:[[1,2,5,9,-1.],[1,5,5,3,3.]],threshold:4.503e-003,right_val:0.34835,left_val:0.51826},{features:[[13,6,2,3,-1.],[13,7,2,1,3.]],threshold:-9.204e-003,right_val:0.49324,left_val:0.68038},{features:[[0,6,14,3,-1.],[7,6,7,3,2.]],threshold:0.081327,right_val:0.22531,left_val:0.50584},{features:[[2,11,18,8,-1.],[2,15,18,4,2.]],threshold:-0.15079,right_val:0.52647,left_val:0.29634},{features:[[5,6,2,3,-1.],[5,7,2,1,3.]],threshold:3.3179e-003,right_val:0.70729,left_val:0.46555},{features:[[10,6,4,2,-1.],[12,6,2,1,2.],[10,7,2,1,2.]],threshold:7.7403e-004,right_val:0.56682,left_val:0.47803},{features:[[6,6,4,2,-1.],[6,6,2,1,2.],[8,7,2,1,2.]],threshold:6.82e-004,right_val:0.57222,left_val:0.4287},{features:[[10,1,3,4,-1.],[11,1,1,4,3.]],threshold:5.3672e-003,right_val:0.31146,left_val:0.52993},{features:[[7,1,2,7,-1.],[8,1,1,7,2.]],threshold:9.7019e-005,right_val:0.52695,left_val:0.36746},{features:[[4,2,15,14,-1.],[4,9,15,7,2.]],threshold:-0.12534,right_val:0.52458,left_val:0.23515},{features:[[8,7,3,2,-1.],[9,7,1,2,3.]],threshold:-5.2516e-003,right_val:0.46938,left_val:0.71159},{features:[[2,3,18,4,-1.],[11,3,9,2,2.],[2,5,9,2,2.]],threshold:-7.8342e-003,right_val:0.54091,left_val:0.44627},{features:[[9,7,2,2,-1.],[10,7,1,2,2.]],threshold:-1.131e-003,right_val:0.44177,left_val:0.59456},{features:[[13,9,2,3,-1.],[13,9,1,3,2.]],threshold:1.7601e-003,right_val:0.39735,left_val:0.53532},{features:[[5,2,6,2,-1.],[7,2,2,2,3.]],threshold:-8.1581e-004,right_val:0.52647,left_val:0.37603},{features:[[9,5,2,7,-1.],[9,5,1,7,2.]],threshold:-3.8688e-003,right_val:0.47498,left_val:0.63099},{features:[[5,9,2,3,-1.],[6,9,1,3,2.]],threshold:1.5207e-003,right_val:0.33612,left_val:0.52302},{features:[[6,0,14,18,-1.],[6,9,14,9,2.]],threshold:0.54587,right_val:0.11726,left_val:0.51671},{features:[[2,16,6,3,-1.],[2,17,6,1,3.]],threshold:0.01565,right_val:0.13933,left_val:0.49794},{features:[[9,7,3,6,-1.],[10,7,1,6,3.]],threshold:-0.011732,right_val:0.49212,left_val:0.71297},{features:[[7,8,4,3,-1.],[7,9,4,1,3.]],threshold:-6.1765e-003,right_val:0.50497,left_val:0.22881},{features:[[7,12,6,3,-1.],[7,13,6,1,3.]],threshold:2.2458e-003,right_val:0.60487,left_val:0.46324},{features:[[9,12,2,3,-1.],[9,13,2,1,3.]],threshold:-5.1916e-003,right_val:0.46022,left_val:0.64674},{features:[[7,12,6,2,-1.],[9,12,2,2,3.]],threshold:-0.023828,right_val:0.52261,left_val:0.1482},{features:[[5,11,4,6,-1.],[5,14,4,3,2.]],threshold:1.0285e-003,right_val:0.3376,left_val:0.51355},{features:[[11,12,7,2,-1.],[11,13,7,1,2.]],threshold:-0.010079,right_val:0.53036,left_val:0.27406},{features:[[6,10,8,6,-1.],[6,10,4,3,2.],[10,13,4,3,2.]],threshold:2.6169e-003,right_val:0.39725,left_val:0.53327},{features:[[11,10,3,4,-1.],[11,12,3,2,2.]],threshold:5.4385e-004,right_val:0.40634,left_val:0.53656},{features:[[9,16,2,3,-1.],[9,17,2,1,3.]],threshold:5.3511e-003,right_val:0.6889,left_val:0.46538},{features:[[13,3,1,9,-1.],[13,6,1,3,3.]],threshold:-1.5275e-003,right_val:0.36247,left_val:0.54495},{features:[[1,13,14,6,-1.],[1,15,14,2,3.]],threshold:-0.080624,right_val:0.50003,left_val:0.16561},{features:[[13,6,1,6,-1.],[13,9,1,3,2.]],threshold:0.022192,right_val:0.20028,left_val:0.51327},{features:[[0,4,3,8,-1.],[1,4,1,8,3.]],threshold:7.3101e-003,right_val:0.63665,left_val:0.46179},{features:[[18,0,2,18,-1.],[18,0,1,18,2.]],threshold:-6.4063e-003,right_val:0.48679,left_val:0.59163},{features:[[2,3,6,2,-1.],[2,4,6,1,2.]],threshold:-7.6415e-004,right_val:0.53158,left_val:0.38884},{features:[[9,0,8,6,-1.],[9,2,8,2,3.]],threshold:7.6734e-004,right_val:0.56053,left_val:0.41591},{features:[[6,6,1,6,-1.],[6,9,1,3,2.]],threshold:6.1475e-004,right_val:0.51201,left_val:0.3089},{features:[[14,8,6,3,-1.],[14,9,6,1,3.]],threshold:-5.0105e-003,right_val:0.52073,left_val:0.39722},{features:[[0,0,2,18,-1.],[1,0,1,18,2.]],threshold:-8.6909e-003,right_val:0.46086,left_val:0.62574},{features:[[1,18,18,2,-1.],[10,18,9,1,2.],[1,19,9,1,2.]],threshold:-0.016391,right_val:0.52423,left_val:0.20852},{features:[[3,15,2,2,-1.],[3,16,2,1,2.]],threshold:4.0974e-004,right_val:0.37803,left_val:0.52224},{features:[[8,14,5,3,-1.],[8,15,5,1,3.]],threshold:-2.5242e-003,right_val:0.46119,left_val:0.58039},{features:[[8,14,2,3,-1.],[8,15,2,1,3.]],threshold:5.0945e-004,right_val:0.5846,left_val:0.44013},{features:[[12,3,3,3,-1.],[13,3,1,3,3.]],threshold:1.9656e-003,right_val:0.41846,left_val:0.53223},{features:[[7,5,6,2,-1.],[9,5,2,2,3.]],threshold:5.6299e-004,right_val:0.52346,left_val:0.37418},{features:[[15,5,5,2,-1.],[15,6,5,1,2.]],threshold:-6.7947e-004,right_val:0.53565,left_val:0.4631},{features:[[0,5,5,2,-1.],[0,6,5,1,2.]],threshold:7.2856e-003,right_val:0.23776,left_val:0.50447},{features:[[17,14,1,6,-1.],[17,17,1,3,2.]],threshold:-0.017459,right_val:0.50504,left_val:0.72891},{features:[[2,9,9,3,-1.],[5,9,3,3,3.]],threshold:-0.025422,right_val:0.46781,left_val:0.66671},{features:[[12,3,3,3,-1.],[13,3,1,3,3.]],threshold:-1.5648e-003,right_val:0.53236,left_val:0.43918},{features:[[0,0,4,18,-1.],[2,0,2,18,2.]],threshold:0.011444,right_val:0.568,left_val:0.43464},{features:[[17,6,1,3,-1.],[17,7,1,1,3.]],threshold:-6.7353e-004,right_val:0.52968,left_val:0.44771},{features:[[2,14,1,6,-1.],[2,17,1,3,2.]],threshold:9.3194e-003,right_val:0.74626,left_val:0.47402},{features:[[19,8,1,2,-1.],[19,9,1,1,2.]],threshold:1.3328e-004,right_val:0.47521,left_val:0.53651},{features:[[5,3,3,3,-1.],[6,3,1,3,3.]],threshold:-7.8816e-003,right_val:0.50153,left_val:0.17522},{features:[[9,16,2,3,-1.],[9,17,2,1,3.]],threshold:-5.7986e-003,right_val:0.48962,left_val:0.72712},{features:[[2,6,1,3,-1.],[2,7,1,1,3.]],threshold:-3.8922e-004,right_val:0.53449,left_val:0.40039},{features:[[12,4,8,2,-1.],[16,4,4,1,2.],[12,5,4,1,2.]],threshold:-1.9289e-003,right_val:0.4804,left_val:0.56056},{features:[[0,4,8,2,-1.],[0,4,4,1,2.],[4,5,4,1,2.]],threshold:8.4214e-003,right_val:0.76236,left_val:0.47532},{features:[[2,16,18,4,-1.],[2,18,18,2,2.]],threshold:8.1656e-003,right_val:0.41916,left_val:0.53933},{features:[[7,15,2,4,-1.],[7,17,2,2,2.]],threshold:4.8281e-004,right_val:0.53998,left_val:0.42408},{features:[[4,0,14,3,-1.],[4,1,14,1,3.]],threshold:-2.7187e-003,right_val:0.54249,left_val:0.42446},{features:[[0,0,4,20,-1.],[2,0,2,20,2.]],threshold:-0.012507,right_val:0.45504,left_val:0.58958},{features:[[12,4,4,8,-1.],[14,4,2,4,2.],[12,8,2,4,2.]],threshold:-0.024287,right_val:0.51892,left_val:0.26471},{features:[[6,7,2,2,-1.],[6,7,1,1,2.],[7,8,1,1,2.]],threshold:-2.9676e-003,right_val:0.47497,left_val:0.73477},{features:[[10,6,2,3,-1.],[10,7,2,1,3.]],threshold:-0.012529,right_val:0.51776,left_val:0.2756},{features:[[8,7,3,2,-1.],[8,8,3,1,2.]],threshold:-1.0104e-003,right_val:0.51447,left_val:0.35106},{features:[[8,2,6,12,-1.],[8,8,6,6,2.]],threshold:-2.1349e-003,right_val:0.46673,left_val:0.56379},{features:[[4,0,11,12,-1.],[4,4,11,4,3.]],threshold:0.019564,right_val:0.61376,left_val:0.46146},{features:[[14,9,6,11,-1.],[16,9,2,11,3.]],threshold:-0.097146,right_val:0.51936,left_val:0.29984},{features:[[0,14,4,3,-1.],[0,15,4,1,3.]],threshold:4.5015e-003,right_val:0.30458,left_val:0.50779},{features:[[9,10,2,3,-1.],[9,11,2,1,3.]],threshold:6.3707e-003,right_val:0.68875,left_val:0.4861},{features:[[5,11,3,2,-1.],[5,12,3,1,2.]],threshold:-9.0722e-003,right_val:0.50176,left_val:0.16734},{features:[[9,15,3,3,-1.],[10,15,1,3,3.]],threshold:-5.3537e-003,right_val:0.52426,left_val:0.26928},{features:[[8,8,3,4,-1.],[9,8,1,4,3.]],threshold:-0.010933,right_val:0.4736,left_val:0.71839},{features:[[9,15,3,3,-1.],[10,15,1,3,3.]],threshold:8.2356e-003,right_val:0.23899,left_val:0.5224},{features:[[7,7,3,2,-1.],[8,7,1,2,3.]],threshold:-1.0038e-003,right_val:0.44339,left_val:0.57194},{features:[[2,10,16,4,-1.],[10,10,8,2,2.],[2,12,8,2,2.]],threshold:4.0859e-003,right_val:0.41488,left_val:0.54728},{features:[[2,3,4,17,-1.],[4,3,2,17,2.]],threshold:0.15485,right_val:0.061062,left_val:0.49738},{features:[[15,13,2,7,-1.],[15,13,1,7,2.]],threshold:2.0897e-004,right_val:0.54239,left_val:0.47092},{features:[[2,2,6,1,-1.],[5,2,3,1,2.]],threshold:3.3317e-004,right_val:0.5301,left_val:0.40896},{features:[[5,2,12,4,-1.],[9,2,4,4,3.]],threshold:-0.010813,right_val:0.49573,left_val:0.61044},{features:[[6,0,8,12,-1.],[6,0,4,6,2.],[10,6,4,6,2.]],threshold:0.045656,right_val:0.28667,left_val:0.50697},{features:[[13,7,2,2,-1.],[14,7,1,1,2.],[13,8,1,1,2.]],threshold:1.257e-003,right_val:0.63182,left_val:0.48469},{features:[[0,12,20,6,-1.],[0,14,20,2,3.]],threshold:-0.12015,right_val:0.4981,left_val:0.060526},{features:[[14,7,2,3,-1.],[14,7,1,3,2.]],threshold:-1.0534e-004,right_val:0.4708,left_val:0.53631},{features:[[0,8,9,12,-1.],[3,8,3,12,3.]],threshold:-0.20703,right_val:0.49791,left_val:0.05966},{features:[[3,0,16,2,-1.],[3,0,8,2,2.]],threshold:1.2909e-004,right_val:0.5378,left_val:0.4713},{features:[[6,15,3,3,-1.],[6,16,3,1,3.]],threshold:3.8819e-004,right_val:0.55342,left_val:0.43635},{features:[[8,15,6,3,-1.],[8,16,6,1,3.]],threshold:-2.9244e-003,right_val:0.48252,left_val:0.58112},{features:[[0,10,1,6,-1.],[0,12,1,2,3.]],threshold:8.3882e-004,right_val:0.40381,left_val:0.53117},{features:[[10,9,4,3,-1.],[10,10,4,1,3.]],threshold:-1.9062e-003,right_val:0.526,left_val:0.37707},{features:[[9,15,2,3,-1.],[9,16,2,1,3.]],threshold:8.9514e-003,right_val:0.76822,left_val:0.47662},{features:[[5,7,10,1,-1.],[5,7,5,1,2.]],threshold:0.013083,right_val:0.30622,left_val:0.52645},{features:[[4,0,12,19,-1.],[10,0,6,19,2.]],threshold:-0.21159,right_val:0.46958,left_val:0.67372},{features:[[0,6,20,6,-1.],[10,6,10,3,2.],[0,9,10,3,2.]],threshold:3.1493e-003,right_val:0.4387,left_val:0.56448},{features:[[3,6,2,2,-1.],[3,6,1,1,2.],[4,7,1,1,2.]],threshold:3.9754e-004,right_val:0.58956,left_val:0.45261},{features:[[15,6,2,2,-1.],[16,6,1,1,2.],[15,7,1,1,2.]],threshold:-1.3814e-003,right_val:0.49424,left_val:0.60706},{features:[[3,6,2,2,-1.],[3,6,1,1,2.],[4,7,1,1,2.]],threshold:-5.8122e-004,right_val:0.45083,left_val:0.59982},{features:[[14,4,1,12,-1.],[14,10,1,6,2.]],threshold:-2.3905e-003,right_val:0.52238,left_val:0.42056},{features:[[2,5,16,10,-1.],[2,5,8,5,2.],[10,10,8,5,2.]],threshold:0.027269,right_val:0.35633,left_val:0.52064},{features:[[9,17,3,2,-1.],[10,17,1,2,3.]],threshold:-3.7658e-003,right_val:0.52188,left_val:0.31447},{features:[[1,4,2,2,-1.],[1,5,2,1,2.]],threshold:-1.4903e-003,right_val:0.51244,left_val:0.33802},{features:[[5,0,15,5,-1.],[10,0,5,5,3.]],threshold:-0.017428,right_val:0.49197,left_val:0.583},{features:[[0,0,15,5,-1.],[5,0,5,5,3.]],threshold:-0.015278,right_val:0.46179,left_val:0.61631},{features:[[11,2,2,17,-1.],[11,2,1,17,2.]],threshold:0.031996,right_val:0.17128,left_val:0.51664},{features:[[7,2,2,17,-1.],[8,2,1,17,2.]],threshold:-3.8257e-003,right_val:0.51314,left_val:0.3408},{features:[[15,11,2,9,-1.],[15,11,1,9,2.]],threshold:-8.5186e-003,right_val:0.49979,left_val:0.61055},{features:[[3,11,2,9,-1.],[4,11,1,9,2.]],threshold:9.0642e-004,right_val:0.55823,left_val:0.43273},{features:[[5,16,14,4,-1.],[5,16,7,4,2.]],threshold:0.010345,right_val:0.54524,left_val:0.48557}],threshold:69.23},{simpleClassifiers:[{features:[[1,4,18,1,-1.],[7,4,6,1,3.]],threshold:7.8982e-003,right_val:0.59465,left_val:0.33325},{features:[[13,7,6,4,-1.],[16,7,3,2,2.],[13,9,3,2,2.]],threshold:1.617e-003,right_val:0.55779,left_val:0.34906},{features:[[9,8,2,12,-1.],[9,12,2,4,3.]],threshold:-5.545e-004,right_val:0.32915,left_val:0.55426},{features:[[12,1,6,6,-1.],[12,3,6,2,3.]],threshold:1.5429e-003,right_val:0.5546,left_val:0.36126},{features:[[5,2,6,6,-1.],[5,2,3,3,2.],[8,5,3,3,2.]],threshold:-1.0329e-003,right_val:0.55761,left_val:0.35301},{features:[[9,16,6,4,-1.],[12,16,3,2,2.],[9,18,3,2,2.]],threshold:7.7698e-004,right_val:0.56453,left_val:0.39168},{features:[[1,2,18,3,-1.],[7,2,6,3,3.]],threshold:0.1432,right_val:0.70236,left_val:0.46675},{features:[[7,4,9,10,-1.],[7,9,9,5,2.]],threshold:-7.3866e-003,right_val:0.52893,left_val:0.30737},{features:[[5,9,4,4,-1.],[7,9,2,4,2.]],threshold:-6.2937e-004,right_val:0.4037,left_val:0.56221},{features:[[11,10,3,6,-1.],[11,13,3,3,2.]],threshold:7.8894e-004,right_val:0.35579,left_val:0.52677},{features:[[7,11,5,3,-1.],[7,12,5,1,3.]],threshold:-0.012228,right_val:0.46255,left_val:0.66683},{features:[[7,11,6,6,-1.],[10,11,3,3,2.],[7,14,3,3,2.]],threshold:3.542e-003,right_val:0.38697,left_val:0.55214},{features:[[0,0,10,9,-1.],[0,3,10,3,3.]],threshold:-1.0585e-003,right_val:0.53209,left_val:0.36287},{features:[[13,14,1,6,-1.],[13,16,1,2,3.]],threshold:1.4936e-005,right_val:0.53633,left_val:0.46324},{features:[[0,2,3,6,-1.],[0,4,3,2,3.]],threshold:5.2538e-003,right_val:0.32657,left_val:0.51322},{features:[[8,14,4,3,-1.],[8,15,4,1,3.]],threshold:-8.2338e-003,right_val:0.47741,left_val:0.66937},{features:[[6,14,1,6,-1.],[6,16,1,2,3.]],threshold:2.1867e-005,right_val:0.54579,left_val:0.40539},{features:[[9,15,2,3,-1.],[9,16,2,1,3.]],threshold:-3.815e-003,right_val:0.47932,left_val:0.6455},{features:[[6,4,3,3,-1.],[7,4,1,3,3.]],threshold:1.1106e-003,right_val:0.35297,left_val:0.52704},{features:[[9,0,11,3,-1.],[9,1,11,1,3.]],threshold:-5.7708e-003,right_val:0.5353,left_val:0.38035},{features:[[0,6,20,3,-1.],[0,7,20,1,3.]],threshold:-3.0158e-003,right_val:0.38871,left_val:0.53394},{features:[[10,1,1,2,-1.],[10,2,1,1,2.]],threshold:-8.5454e-004,right_val:0.52736,left_val:0.35646},{features:[[9,6,2,6,-1.],[10,6,1,6,2.]],threshold:0.011051,right_val:0.68497,left_val:0.46719},{features:[[5,8,12,1,-1.],[9,8,4,1,3.]],threshold:0.042606,right_val:0.07022,left_val:0.51515},{features:[[3,8,12,1,-1.],[7,8,4,1,3.]],threshold:-3.0782e-003,right_val:0.51526,left_val:0.30417},{features:[[9,7,3,5,-1.],[10,7,1,5,3.]],threshold:-5.4816e-003,right_val:0.48972,left_val:0.64303},{features:[[3,9,6,2,-1.],[6,9,3,2,2.]],threshold:3.1882e-003,right_val:0.38262,left_val:0.53075},{features:[[12,9,3,3,-1.],[12,10,3,1,3.]],threshold:3.5947e-004,right_val:0.54219,left_val:0.465},{features:[[7,0,6,1,-1.],[9,0,2,1,3.]],threshold:-4.0705e-003,right_val:0.50791,left_val:0.28497},{features:[[12,9,3,3,-1.],[12,10,3,1,3.]],threshold:-0.014594,right_val:0.51285,left_val:0.29716},{features:[[7,10,2,1,-1.],[8,10,1,1,2.]],threshold:-1.1948e-004,right_val:0.43431,left_val:0.56311},{features:[[6,4,9,13,-1.],[9,4,3,13,3.]],threshold:-6.9345e-004,right_val:0.536,left_val:0.44036},{features:[[6,8,4,2,-1.],[6,9,4,1,2.]],threshold:1.4835e-005,right_val:0.51647,left_val:0.3421},{features:[[16,2,4,6,-1.],[16,2,2,6,2.]],threshold:9.0297e-003,right_val:0.61141,left_val:0.46393},{features:[[0,17,6,3,-1.],[0,18,6,1,3.]],threshold:-8.0641e-003,right_val:0.50755,left_val:0.28202},{features:[[10,10,3,10,-1.],[10,15,3,5,2.]],threshold:0.026062,right_val:0.26888,left_val:0.52089},{features:[[8,7,3,5,-1.],[9,7,1,5,3.]],threshold:0.017315,right_val:0.67385,left_val:0.46637},{features:[[10,4,4,3,-1.],[10,4,2,3,2.]],threshold:0.022667,right_val:0.22127,left_val:0.52093},{features:[[8,4,3,8,-1.],[9,4,1,8,3.]],threshold:-2.1966e-003,right_val:0.45382,left_val:0.60631},{features:[[6,6,9,13,-1.],[9,6,3,13,3.]],threshold:-9.5282e-003,right_val:0.52474,left_val:0.46352},{features:[[6,0,8,12,-1.],[6,0,4,6,2.],[10,6,4,6,2.]],threshold:8.0944e-003,right_val:0.39139,left_val:0.52894},{features:[[14,2,6,8,-1.],[16,2,2,8,3.]],threshold:-0.072877,right_val:0.49902,left_val:0.7752},{features:[[6,0,3,6,-1.],[7,0,1,6,3.]],threshold:-6.901e-003,right_val:0.50481,left_val:0.2428},{features:[[14,2,6,8,-1.],[16,2,2,8,3.]],threshold:-0.011308,right_val:0.48424,left_val:0.57344},{features:[[0,5,6,6,-1.],[0,8,6,3,2.]],threshold:0.059613,right_val:0.2525,left_val:0.50298},{features:[[9,12,6,2,-1.],[12,12,3,1,2.],[9,13,3,1,2.]],threshold:-2.8625e-003,right_val:0.48985,left_val:0.6073},{features:[[8,17,3,2,-1.],[9,17,1,2,3.]],threshold:4.4781e-003,right_val:0.22203,left_val:0.50153},{features:[[11,6,2,2,-1.],[12,6,1,1,2.],[11,7,1,1,2.]],threshold:-1.7513e-003,right_val:0.49339,left_val:0.66144},{features:[[1,9,18,2,-1.],[7,9,6,2,3.]],threshold:0.040163,right_val:0.3741,left_val:0.51809},{features:[[11,6,2,2,-1.],[12,6,1,1,2.],[11,7,1,1,2.]],threshold:3.4769e-004,right_val:0.5818,left_val:0.47204},{features:[[3,4,12,8,-1.],[7,4,4,8,3.]],threshold:2.6552e-003,right_val:0.52213,left_val:0.3805},{features:[[13,11,5,3,-1.],[13,12,5,1,3.]],threshold:-8.7706e-003,right_val:0.52313,left_val:0.29442},{features:[[9,10,2,3,-1.],[9,11,2,1,3.]],threshold:-5.5122e-003,right_val:0.47228,left_val:0.73462},{features:[[14,7,2,3,-1.],[14,7,1,3,2.]],threshold:6.8672e-004,right_val:0.42424,left_val:0.54529},{features:[[5,4,1,3,-1.],[5,5,1,1,3.]],threshold:5.602e-004,right_val:0.56013,left_val:0.43989},{features:[[13,4,2,3,-1.],[13,5,2,1,3.]],threshold:2.4144e-003,right_val:0.61366,left_val:0.47417},{features:[[5,4,2,3,-1.],[5,5,2,1,3.]],threshold:-1.5681e-003,right_val:0.45164,left_val:0.60446},{features:[[9,8,2,3,-1.],[9,9,2,1,3.]],threshold:-3.6827e-003,right_val:0.5295,left_val:0.24525},{features:[[8,9,2,2,-1.],[8,10,2,1,2.]],threshold:-2.9409e-004,right_val:0.52515,left_val:0.37328},{features:[[15,14,1,4,-1.],[15,16,1,2,2.]],threshold:4.2848e-004,right_val:0.40655,left_val:0.54988},{features:[[3,12,2,2,-1.],[3,13,2,1,2.]],threshold:-4.8817e-003,right_val:0.5,left_val:0.21399},{features:[[12,15,2,2,-1.],[13,15,1,1,2.],[12,16,1,1,2.]],threshold:2.7272e-004,right_val:0.58134,left_val:0.46503},{features:[[9,13,2,2,-1.],[9,14,2,1,2.]],threshold:2.0947e-004,right_val:0.55728,left_val:0.43875},{features:[[4,11,14,9,-1.],[4,14,14,3,3.]],threshold:0.048501,right_val:0.32129,left_val:0.5245},{features:[[7,13,4,3,-1.],[7,14,4,1,3.]],threshold:-4.5166e-003,right_val:0.45459,left_val:0.60568},{features:[[15,14,1,4,-1.],[15,16,1,2,2.]],threshold:-0.012292,right_val:0.51522,left_val:0.20409},{features:[[4,14,1,4,-1.],[4,16,1,2,2.]],threshold:4.855e-004,right_val:0.37395,left_val:0.52376},{features:[[14,0,6,13,-1.],[16,0,2,13,3.]],threshold:0.030556,right_val:0.59382,left_val:0.49605},{features:[[4,1,2,12,-1.],[4,1,1,6,2.],[5,7,1,6,2.]],threshold:-1.5105e-004,right_val:0.41452,left_val:0.53513},{features:[[11,14,6,6,-1.],[14,14,3,3,2.],[11,17,3,3,2.]],threshold:2.4937e-003,right_val:0.55149,left_val:0.46934},{features:[[3,14,6,6,-1.],[3,14,3,3,2.],[6,17,3,3,2.]],threshold:-0.012382,right_val:0.46817,left_val:0.67914},{features:[[14,17,3,2,-1.],[14,18,3,1,2.]],threshold:-5.1333e-003,right_val:0.52292,left_val:0.36087},{features:[[3,17,3,2,-1.],[3,18,3,1,2.]],threshold:5.1919e-004,right_val:0.36336,left_val:0.53001},{features:[[14,0,6,13,-1.],[16,0,2,13,3.]],threshold:0.1506,right_val:0.22118,left_val:0.51573},{features:[[0,0,6,13,-1.],[2,0,2,13,3.]],threshold:7.7144e-003,right_val:0.57766,left_val:0.44105},{features:[[10,10,7,6,-1.],[10,12,7,2,3.]],threshold:9.4444e-003,right_val:0.37567,left_val:0.54019},{features:[[6,15,2,2,-1.],[6,15,1,1,2.],[7,16,1,1,2.]],threshold:2.5006e-004,right_val:0.56074,left_val:0.43683},{features:[[6,11,8,6,-1.],[10,11,4,3,2.],[6,14,4,3,2.]],threshold:-3.3077e-003,right_val:0.55182,left_val:0.42448},{features:[[7,6,2,2,-1.],[7,6,1,1,2.],[8,7,1,1,2.]],threshold:7.4049e-004,right_val:0.59006,left_val:0.4497},{features:[[2,2,16,6,-1.],[10,2,8,3,2.],[2,5,8,3,2.]],threshold:0.044092,right_val:0.31564,left_val:0.52935},{features:[[5,4,3,3,-1.],[5,5,3,1,3.]],threshold:3.364e-003,right_val:0.58487,left_val:0.44833},{features:[[11,7,3,10,-1.],[11,12,3,5,2.]],threshold:-3.976e-003,right_val:0.54836,left_val:0.45595},{features:[[6,7,3,10,-1.],[6,12,3,5,2.]],threshold:2.7717e-003,right_val:0.37925,left_val:0.53418},{features:[[10,7,3,2,-1.],[11,7,1,2,3.]],threshold:-2.4123e-004,right_val:0.4577,left_val:0.56672},{features:[[8,12,4,2,-1.],[8,13,4,1,2.]],threshold:4.9426e-004,right_val:0.56288,left_val:0.44212},{features:[[10,1,1,3,-1.],[10,2,1,1,3.]],threshold:-3.8876e-004,right_val:0.53911,left_val:0.42884},{features:[[1,2,4,18,-1.],[1,2,2,9,2.],[3,11,2,9,2.]],threshold:-0.050049,right_val:0.47037,left_val:0.68995},{features:[[12,4,4,12,-1.],[12,10,4,6,2.]],threshold:-0.036635,right_val:0.51918,left_val:0.22178},{features:[[0,0,1,6,-1.],[0,2,1,2,3.]],threshold:2.4274e-003,right_val:0.34974,left_val:0.51362},{features:[[9,11,2,3,-1.],[9,12,2,1,3.]],threshold:1.9558e-003,right_val:0.64084,left_val:0.48262},{features:[[8,7,4,3,-1.],[8,8,4,1,3.]],threshold:-1.7495e-003,right_val:0.52727,left_val:0.39228},{features:[[10,7,3,2,-1.],[11,7,1,2,3.]],threshold:0.013955,right_val:0.84165,left_val:0.50782},{features:[[7,7,3,2,-1.],[8,7,1,2,3.]],threshold:-2.1897e-004,right_val:0.43142,left_val:0.55205},{features:[[9,4,6,1,-1.],[11,4,2,1,3.]],threshold:-1.5131e-003,right_val:0.53826,left_val:0.39346},{features:[[8,7,2,3,-1.],[9,7,1,3,2.]],threshold:-4.3623e-003,right_val:0.47365,left_val:0.73706},{features:[[12,7,8,6,-1.],[16,7,4,3,2.],[12,10,4,3,2.]],threshold:0.065161,right_val:0.32816,left_val:0.51593},{features:[[0,7,8,6,-1.],[0,7,4,3,2.],[4,10,4,3,2.]],threshold:-2.3567e-003,right_val:0.51729,left_val:0.36728},{features:[[18,2,2,10,-1.],[19,2,1,5,2.],[18,7,1,5,2.]],threshold:0.015147,right_val:0.66876,left_val:0.50315},{features:[[0,2,6,4,-1.],[3,2,3,4,2.]],threshold:-0.022851,right_val:0.47096,left_val:0.67675},{features:[[9,4,6,1,-1.],[11,4,2,1,3.]],threshold:4.8868e-003,right_val:0.40599,left_val:0.5258},{features:[[7,15,2,2,-1.],[7,15,1,1,2.],[8,16,1,1,2.]],threshold:1.762e-003,right_val:0.66883,left_val:0.46963},{features:[[11,13,1,6,-1.],[11,16,1,3,2.]],threshold:-1.2943e-003,right_val:0.53443,left_val:0.43207},{features:[[8,13,1,6,-1.],[8,16,1,3,2.]],threshold:0.01093,right_val:0.16375,left_val:0.49977},{features:[[14,3,2,1,-1.],[14,3,1,1,2.]],threshold:2.9958e-005,right_val:0.56332,left_val:0.42824},{features:[[8,15,2,3,-1.],[8,16,2,1,3.]],threshold:-6.5884e-003,right_val:0.47005,left_val:0.67721},{features:[[12,15,7,4,-1.],[12,17,7,2,2.]],threshold:3.2528e-003,right_val:0.45361,left_val:0.53134},{features:[[4,14,12,3,-1.],[4,15,12,1,3.]],threshold:-4.0436e-003,right_val:0.44134,left_val:0.56601},{features:[[10,3,3,2,-1.],[11,3,1,2,3.]],threshold:-1.2524e-003,right_val:0.53565,left_val:0.37319},{features:[[4,12,2,2,-1.],[4,13,2,1,2.]],threshold:1.9247e-004,right_val:0.37388,left_val:0.519},{features:[[10,11,4,6,-1.],[10,14,4,3,2.]],threshold:-0.03859,right_val:0.51888,left_val:0.29564},{features:[[7,13,2,2,-1.],[7,13,1,1,2.],[8,14,1,1,2.]],threshold:1.549e-004,right_val:0.55095,left_val:0.43471},{features:[[4,11,14,4,-1.],[11,11,7,2,2.],[4,13,7,2,2.]],threshold:-0.033764,right_val:0.51955,left_val:0.32303},{features:[[1,18,18,2,-1.],[7,18,6,2,3.]],threshold:-8.2657e-003,right_val:0.45521,left_val:0.59755},{features:[[11,18,2,2,-1.],[12,18,1,1,2.],[11,19,1,1,2.]],threshold:1.4481e-005,right_val:0.54974,left_val:0.47457},{features:[[7,18,2,2,-1.],[7,18,1,1,2.],[8,19,1,1,2.]],threshold:1.4951e-005,right_val:0.54806,left_val:0.43245},{features:[[12,18,8,2,-1.],[12,19,8,1,2.]],threshold:-0.018742,right_val:0.51785,left_val:0.15801},{features:[[7,14,6,2,-1.],[7,15,6,1,2.]],threshold:1.7572e-003,right_val:0.57738,left_val:0.45176},{features:[[8,12,4,8,-1.],[10,12,2,4,2.],[8,16,2,4,2.]],threshold:-3.1391e-003,right_val:0.54608,left_val:0.41496},{features:[[4,9,3,3,-1.],[4,10,3,1,3.]],threshold:6.6657e-005,right_val:0.52931,left_val:0.40391},{features:[[7,10,6,2,-1.],[9,10,2,2,3.]],threshold:6.7743e-003,right_val:0.6122,left_val:0.47677},{features:[[5,0,4,15,-1.],[7,0,2,15,2.]],threshold:-7.3868e-003,right_val:0.51873,left_val:0.35863},{features:[[8,6,12,14,-1.],[12,6,4,14,3.]],threshold:0.014041,right_val:0.55762,left_val:0.47121},{features:[[5,16,3,3,-1.],[5,17,3,1,3.]],threshold:-5.5258e-003,right_val:0.50393,left_val:0.2661},{features:[[8,1,12,19,-1.],[12,1,4,19,3.]],threshold:0.38684,right_val:0.25259,left_val:0.51443},{features:[[3,0,3,2,-1.],[3,1,3,1,2.]],threshold:1.1459e-004,right_val:0.54234,left_val:0.4285},{features:[[10,12,4,5,-1.],[10,12,2,5,2.]],threshold:-0.018468,right_val:0.52131,left_val:0.38858},{features:[[6,12,4,5,-1.],[8,12,2,5,2.]],threshold:-4.5907e-004,right_val:0.42359,left_val:0.54126},{features:[[11,11,2,2,-1.],[12,11,1,1,2.],[11,12,1,1,2.]],threshold:1.2528e-003,right_val:0.66241,left_val:0.48993},{features:[[0,2,3,6,-1.],[0,4,3,2,3.]],threshold:1.4911e-003,right_val:0.40401,left_val:0.52868},{features:[[11,11,2,2,-1.],[12,11,1,1,2.],[11,12,1,1,2.]],threshold:-7.5436e-004,right_val:0.47951,left_val:0.6033},{features:[[7,6,4,10,-1.],[7,11,4,5,2.]],threshold:-6.9479e-003,right_val:0.53735,left_val:0.40844},{features:[[11,11,2,2,-1.],[12,11,1,1,2.],[11,12,1,1,2.]],threshold:2.8093e-004,right_val:0.57594,left_val:0.48461},{features:[[2,13,5,2,-1.],[2,14,5,1,2.]],threshold:9.6074e-004,right_val:0.3555,left_val:0.51647},{features:[[11,11,2,2,-1.],[12,11,1,1,2.],[11,12,1,1,2.]],threshold:-2.6884e-004,right_val:0.47318,left_val:0.56776},{features:[[7,11,2,2,-1.],[7,11,1,1,2.],[8,12,1,1,2.]],threshold:2.1599e-003,right_val:0.70706,left_val:0.47315},{features:[[14,13,3,3,-1.],[14,14,3,1,3.]],threshold:5.6235e-003,right_val:0.27818,left_val:0.52402},{features:[[3,13,3,3,-1.],[3,14,3,1,3.]],threshold:-5.0244e-003,right_val:0.50623,left_val:0.2837},{features:[[9,14,2,3,-1.],[9,15,2,1,3.]],threshold:-9.7612e-003,right_val:0.49346,left_val:0.74007},{features:[[8,7,3,3,-1.],[8,8,3,1,3.]],threshold:4.1515e-003,right_val:0.3407,left_val:0.51191},{features:[[13,5,3,3,-1.],[13,6,3,1,3.]],threshold:6.2465e-003,right_val:0.65791,left_val:0.49238},{features:[[0,9,5,3,-1.],[0,10,5,1,3.]],threshold:-7.0597e-003,right_val:0.50328,left_val:0.24347},{features:[[13,5,3,3,-1.],[13,6,3,1,3.]],threshold:-2.0588e-003,right_val:0.46951,left_val:0.59003},{features:[[9,12,2,8,-1.],[9,12,1,4,2.],[10,16,1,4,2.]],threshold:-2.4146e-003,right_val:0.51892,left_val:0.36473},{features:[[11,7,2,2,-1.],[12,7,1,1,2.],[11,8,1,1,2.]],threshold:-1.4818e-003,right_val:0.49401,left_val:0.60349},{features:[[0,16,6,4,-1.],[3,16,3,4,2.]],threshold:-6.3016e-003,right_val:0.45604,left_val:0.5819},{features:[[10,6,2,3,-1.],[10,7,2,1,3.]],threshold:3.4763e-003,right_val:0.3484,left_val:0.52175},{features:[[9,5,2,6,-1.],[9,7,2,2,3.]],threshold:-0.022251,right_val:0.50321,left_val:0.23607},{features:[[12,15,8,4,-1.],[12,15,4,4,2.]],threshold:-0.030613,right_val:0.49149,left_val:0.64992},{features:[[0,14,8,6,-1.],[4,14,4,6,2.]],threshold:0.013057,right_val:0.56838,left_val:0.44133},{features:[[9,0,3,2,-1.],[10,0,1,2,3.]],threshold:-6.0096e-004,right_val:0.53335,left_val:0.43597},{features:[[4,15,4,2,-1.],[6,15,2,2,2.]],threshold:-4.1514e-004,right_val:0.43261,left_val:0.55041},{features:[[12,7,3,13,-1.],[13,7,1,13,3.]],threshold:-0.013776,right_val:0.52015,left_val:0.40641},{features:[[5,7,3,13,-1.],[6,7,1,13,3.]],threshold:-0.032297,right_val:0.49772,left_val:0.047352},{features:[[9,6,3,9,-1.],[9,9,3,3,3.]],threshold:0.053557,right_val:0.66669,left_val:0.48817},{features:[[4,4,7,12,-1.],[4,10,7,6,2.]],threshold:8.189e-003,right_val:0.42408,left_val:0.54},{features:[[12,12,2,2,-1.],[13,12,1,1,2.],[12,13,1,1,2.]],threshold:2.1055e-004,right_val:0.55639,left_val:0.4802},{features:[[6,12,2,2,-1.],[6,12,1,1,2.],[7,13,1,1,2.]],threshold:-2.4383e-003,right_val:0.47737,left_val:0.73878},{features:[[8,9,4,2,-1.],[10,9,2,1,2.],[8,10,2,1,2.]],threshold:3.2836e-003,right_val:0.31713,left_val:0.52885},{features:[[3,6,2,2,-1.],[3,6,1,1,2.],[4,7,1,1,2.]],threshold:2.373e-003,right_val:0.70602,left_val:0.47508},{features:[[16,6,3,2,-1.],[16,7,3,1,2.]],threshold:-1.4542e-003,right_val:0.53307,left_val:0.38117}],threshold:79.249},{simpleClassifiers:[{features:[[0,7,19,4,-1.],[0,9,19,2,2.]],threshold:0.055755,right_val:0.6806,left_val:0.40192},{features:[[10,2,10,1,-1.],[10,2,5,1,2.]],threshold:2.473e-003,right_val:0.59657,left_val:0.33511},{features:[[9,4,2,12,-1.],[9,10,2,6,2.]],threshold:-3.5032e-004,right_val:0.34823,left_val:0.55577},{features:[[12,18,4,1,-1.],[12,18,2,1,2.]],threshold:5.4168e-004,right_val:0.56934,left_val:0.42609},{features:[[1,7,6,4,-1.],[1,7,3,2,2.],[4,9,3,2,2.]],threshold:7.7194e-004,right_val:0.54337,left_val:0.34942},{features:[[12,0,6,13,-1.],[14,0,2,13,3.]],threshold:-1.5999e-003,right_val:0.54844,left_val:0.40285},{features:[[2,0,6,13,-1.],[4,0,2,13,3.]],threshold:-1.1832e-004,right_val:0.54255,left_val:0.38069},{features:[[10,5,8,8,-1.],[10,9,8,4,2.]],threshold:3.2909e-004,right_val:0.54295,left_val:0.26201},{features:[[8,3,2,5,-1.],[9,3,1,5,2.]],threshold:2.9518e-004,right_val:0.53993,left_val:0.37998},{features:[[8,4,9,1,-1.],[11,4,3,1,3.]],threshold:9.0467e-005,right_val:0.54402,left_val:0.44336},{features:[[3,4,9,1,-1.],[6,4,3,1,3.]],threshold:1.5007e-005,right_val:0.54091,left_val:0.37197},{features:[[1,0,18,10,-1.],[7,0,6,10,3.]],threshold:0.13936,right_val:0.4479,left_val:0.55254},{features:[[7,17,5,3,-1.],[7,18,5,1,3.]],threshold:1.6462e-003,right_val:0.57722,left_val:0.42645},{features:[[7,11,6,1,-1.],[9,11,2,1,3.]],threshold:4.9984e-004,right_val:0.56859,left_val:0.43595},{features:[[2,2,3,2,-1.],[2,3,3,1,2.]],threshold:-1.0971e-003,right_val:0.52054,left_val:0.33901},{features:[[8,12,4,2,-1.],[8,13,4,1,2.]],threshold:6.692e-004,right_val:0.59807,left_val:0.45575},{features:[[6,10,3,6,-1.],[6,13,3,3,2.]],threshold:8.6471e-004,right_val:0.2944,left_val:0.51348},{features:[[11,4,2,4,-1.],[11,4,1,4,2.]],threshold:-2.7183e-004,right_val:0.53772,left_val:0.39066},{features:[[7,4,2,4,-1.],[8,4,1,4,2.]],threshold:3.0249e-005,right_val:0.52257,left_val:0.36796},{features:[[9,6,2,4,-1.],[9,6,1,4,2.]],threshold:-8.5226e-003,right_val:0.48924,left_val:0.72931},{features:[[6,13,8,3,-1.],[6,14,8,1,3.]],threshold:1.6706e-003,right_val:0.56961,left_val:0.43453},{features:[[9,15,3,4,-1.],[10,15,1,4,3.]],threshold:-7.1434e-003,right_val:0.52256,left_val:0.25913},{features:[[9,2,2,17,-1.],[10,2,1,17,2.]],threshold:-0.016319,right_val:0.46516,left_val:0.69223},{features:[[7,0,6,1,-1.],[9,0,2,1,3.]],threshold:4.8034e-003,right_val:0.32863,left_val:0.53523},{features:[[8,15,3,4,-1.],[9,15,1,4,3.]],threshold:-7.5422e-003,right_val:0.50345,left_val:0.20405},{features:[[7,13,7,3,-1.],[7,14,7,1,3.]],threshold:-0.014363,right_val:0.48891,left_val:0.68049},{features:[[8,16,3,3,-1.],[9,16,1,3,3.]],threshold:8.9064e-004,right_val:0.38955,left_val:0.53107},{features:[[6,2,8,10,-1.],[6,7,8,5,2.]],threshold:-4.406e-003,right_val:0.43724,left_val:0.57416},{features:[[2,5,8,8,-1.],[2,9,8,4,2.]],threshold:-1.8863e-004,right_val:0.50982,left_val:0.28318},{features:[[14,16,2,2,-1.],[14,17,2,1,2.]],threshold:-3.7979e-003,right_val:0.52466,left_val:0.33725},{features:[[4,16,2,2,-1.],[4,17,2,1,2.]],threshold:1.4627e-004,right_val:0.39117,left_val:0.53067},{features:[[10,11,4,6,-1.],[10,14,4,3,2.]],threshold:-4.9165e-005,right_val:0.39427,left_val:0.54625},{features:[[6,11,4,6,-1.],[6,14,4,3,2.]],threshold:-0.033583,right_val:0.50482,left_val:0.21578},{features:[[10,14,1,3,-1.],[10,15,1,1,3.]],threshold:-3.5339e-003,right_val:0.48727,left_val:0.64653},{features:[[8,14,4,3,-1.],[8,15,4,1,3.]],threshold:5.0144e-003,right_val:0.62481,left_val:0.46177},{features:[[10,0,4,6,-1.],[12,0,2,3,2.],[10,3,2,3,2.]],threshold:0.018817,right_val:0.20001,left_val:0.52207},{features:[[0,3,20,2,-1.],[0,4,20,1,2.]],threshold:-1.3434e-003,right_val:0.53016,left_val:0.40145},{features:[[12,0,8,2,-1.],[16,0,4,1,2.],[12,1,4,1,2.]],threshold:1.7558e-003,right_val:0.56532,left_val:0.4794},{features:[[2,12,10,8,-1.],[2,16,10,4,2.]],threshold:-0.095637,right_val:0.50067,left_val:0.20342},{features:[[17,7,2,10,-1.],[18,7,1,5,2.],[17,12,1,5,2.]],threshold:-0.022241,right_val:0.50463,left_val:0.76725},{features:[[1,7,2,10,-1.],[1,7,1,5,2.],[2,12,1,5,2.]],threshold:-0.015576,right_val:0.47559,left_val:0.74903},{features:[[15,10,3,6,-1.],[15,12,3,2,3.]],threshold:5.3599e-003,right_val:0.40047,left_val:0.53653},{features:[[4,4,6,2,-1.],[6,4,2,2,3.]],threshold:-0.021763,right_val:0.49642,left_val:0.074015},{features:[[0,5,20,6,-1.],[0,7,20,2,3.]],threshold:-0.16562,right_val:0.52181,left_val:0.28591},{features:[[0,0,8,2,-1.],[0,0,4,1,2.],[4,1,4,1,2.]],threshold:1.6461e-004,right_val:0.53808,left_val:0.41916},{features:[[1,0,18,4,-1.],[7,0,6,4,3.]],threshold:-8.9078e-003,right_val:0.48774,left_val:0.62732},{features:[[1,13,6,2,-1.],[1,14,6,1,2.]],threshold:8.6346e-004,right_val:0.3671,left_val:0.51599},{features:[[10,8,3,4,-1.],[11,8,1,4,3.]],threshold:-1.3752e-003,right_val:0.45791,left_val:0.58844},{features:[[6,1,6,1,-1.],[8,1,2,1,3.]],threshold:-1.4081e-003,right_val:0.51399,left_val:0.35605},{features:[[8,14,4,3,-1.],[8,15,4,1,3.]],threshold:-3.9343e-003,right_val:0.46643,left_val:0.59943},{features:[[1,6,18,2,-1.],[10,6,9,2,2.]],threshold:-0.031967,right_val:0.51442,left_val:0.33455},{features:[[15,11,1,2,-1.],[15,12,1,1,2.]],threshold:-1.5089e-005,right_val:0.44141,left_val:0.55827},{features:[[6,5,1,2,-1.],[6,6,1,1,2.]],threshold:5.1994e-004,right_val:0.6169,left_val:0.46237},{features:[[13,4,1,3,-1.],[13,5,1,1,3.]],threshold:-3.422e-003,right_val:0.49748,left_val:0.65571},{features:[[2,15,1,2,-1.],[2,16,1,1,2.]],threshold:1.7723e-004,right_val:0.39019,left_val:0.52695},{features:[[12,4,4,3,-1.],[12,5,4,1,3.]],threshold:1.5717e-003,right_val:0.57905,left_val:0.46334},{features:[[0,0,7,3,-1.],[0,1,7,1,3.]],threshold:-8.9041e-003,right_val:0.50536,left_val:0.26896},{features:[[9,12,6,2,-1.],[9,12,3,2,2.]],threshold:4.0678e-004,right_val:0.43299,left_val:0.54566},{features:[[5,4,2,3,-1.],[5,5,2,1,3.]],threshold:6.7605e-003,right_val:0.66898,left_val:0.4649},{features:[[18,4,2,3,-1.],[18,5,2,1,3.]],threshold:2.91e-003,right_val:0.33778,left_val:0.53097},{features:[[3,0,8,6,-1.],[3,2,8,2,3.]],threshold:1.3885e-003,right_val:0.53491,left_val:0.40747},{features:[[0,2,20,6,-1.],[10,2,10,3,2.],[0,5,10,3,2.]],threshold:-0.076764,right_val:0.52282,left_val:0.19922},{features:[[4,7,2,4,-1.],[5,7,1,4,2.]],threshold:-2.2688e-004,right_val:0.42531,left_val:0.54385},{features:[[3,10,15,2,-1.],[8,10,5,2,3.]],threshold:-6.3094e-003,right_val:0.53789,left_val:0.42592},{features:[[3,0,12,11,-1.],[9,0,6,11,2.]],threshold:-0.11007,right_val:0.47217,left_val:0.69042},{features:[[13,0,2,6,-1.],[13,0,1,6,2.]],threshold:2.862e-004,right_val:0.55483,left_val:0.45249},{features:[[0,19,2,1,-1.],[1,19,1,1,2.]],threshold:2.9425e-005,right_val:0.42365,left_val:0.53704},{features:[[16,10,4,10,-1.],[18,10,2,5,2.],[16,15,2,5,2.]],threshold:-0.024887,right_val:0.49693,left_val:0.64236},{features:[[4,8,10,3,-1.],[4,9,10,1,3.]],threshold:0.033149,right_val:0.16138,left_val:0.49885},{features:[[14,12,3,3,-1.],[14,13,3,1,3.]],threshold:7.8492e-004,right_val:0.4223,left_val:0.5416},{features:[[0,10,4,10,-1.],[0,10,2,5,2.],[2,15,2,5,2.]],threshold:4.7087e-003,right_val:0.60276,left_val:0.45763},{features:[[18,3,2,6,-1.],[18,5,2,2,3.]],threshold:2.4144e-003,right_val:0.44225,left_val:0.5309},{features:[[6,6,1,3,-1.],[6,7,1,1,3.]],threshold:1.9523e-003,right_val:0.66633,left_val:0.47056},{features:[[7,7,7,2,-1.],[7,8,7,1,2.]],threshold:1.3032e-003,right_val:0.5527,left_val:0.44061},{features:[[0,3,2,6,-1.],[0,5,2,2,3.]],threshold:4.4735e-003,right_val:0.33015,left_val:0.5129},{features:[[11,1,3,1,-1.],[12,1,1,1,3.]],threshold:-2.6653e-003,right_val:0.5175,left_val:0.31355},{features:[[5,0,2,6,-1.],[6,0,1,6,2.]],threshold:1.3667e-004,right_val:0.53069,left_val:0.41194},{features:[[1,1,18,14,-1.],[7,1,6,14,3.]],threshold:-0.017126,right_val:0.48366,left_val:0.61778},{features:[[4,6,8,3,-1.],[8,6,4,3,2.]],threshold:-2.6601e-004,right_val:0.51697,left_val:0.36543},{features:[[9,12,6,2,-1.],[9,12,3,2,2.]],threshold:-0.022932,right_val:0.5164,left_val:0.34909},{features:[[5,12,6,2,-1.],[8,12,3,2,2.]],threshold:2.3317e-003,right_val:0.37094,left_val:0.51663},{features:[[10,7,3,5,-1.],[11,7,1,5,3.]],threshold:0.016926,right_val:0.8054,left_val:0.50147},{features:[[7,7,3,5,-1.],[8,7,1,5,3.]],threshold:-8.9859e-003,right_val:0.4657,left_val:0.64708},{features:[[13,0,3,10,-1.],[14,0,1,10,3.]],threshold:-0.011875,right_val:0.52588,left_val:0.32464},{features:[[4,11,3,2,-1.],[4,12,3,1,2.]],threshold:1.9351e-004,right_val:0.38396,left_val:0.51919},{features:[[17,3,3,6,-1.],[18,3,1,6,3.]],threshold:5.8713e-003,right_val:0.6187,left_val:0.49181},{features:[[1,8,18,10,-1.],[1,13,18,5,2.]],threshold:-0.24839,right_val:0.49882,left_val:0.18368},{features:[[13,0,3,10,-1.],[14,0,1,10,3.]],threshold:0.012256,right_val:0.3632,left_val:0.52271},{features:[[9,14,2,3,-1.],[9,15,2,1,3.]],threshold:8.399e-004,right_val:0.57741,left_val:0.44903},{features:[[16,3,3,7,-1.],[17,3,1,7,3.]],threshold:2.5407e-003,right_val:0.58583,left_val:0.48048},{features:[[4,0,3,10,-1.],[5,0,1,10,3.]],threshold:-0.014822,right_val:0.50235,left_val:0.2521},{features:[[16,3,3,7,-1.],[17,3,1,7,3.]],threshold:-5.7974e-003,right_val:0.48537,left_val:0.59967},{features:[[0,9,1,2,-1.],[0,10,1,1,2.]],threshold:7.2662e-004,right_val:0.36718,left_val:0.51537},{features:[[18,1,2,10,-1.],[18,1,1,10,2.]],threshold:-0.017233,right_val:0.49947,left_val:0.66217},{features:[[0,1,2,10,-1.],[1,1,1,10,2.]],threshold:7.8624e-003,right_val:0.62561,left_val:0.46334},{features:[[10,16,3,4,-1.],[11,16,1,4,3.]],threshold:-4.7344e-003,right_val:0.52819,left_val:0.36156},{features:[[2,8,3,3,-1.],[3,8,1,3,3.]],threshold:8.3048e-004,right_val:0.5551,left_val:0.44429},{features:[[11,0,2,6,-1.],[12,0,1,3,2.],[11,3,1,3,2.]],threshold:7.6602e-003,right_val:0.26134,left_val:0.51629},{features:[[7,0,2,6,-1.],[7,0,1,3,2.],[8,3,1,3,2.]],threshold:-4.1048e-003,right_val:0.5019,left_val:0.27896},{features:[[16,3,3,7,-1.],[17,3,1,7,3.]],threshold:4.8513e-003,right_val:0.56617,left_val:0.4969},{features:[[1,3,3,7,-1.],[2,3,1,7,3.]],threshold:9.9896e-004,right_val:0.55518,left_val:0.44456},{features:[[14,1,6,16,-1.],[16,1,2,16,3.]],threshold:-0.27024,right_val:0.51513,left_val:0.029388},{features:[[0,1,6,16,-1.],[2,1,2,16,3.]],threshold:-0.013091,right_val:0.44475,left_val:0.56994},{features:[[2,0,16,8,-1.],[10,0,8,4,2.],[2,4,8,4,2.]],threshold:-9.4343e-003,right_val:0.54879,left_val:0.43055},{features:[[6,8,5,3,-1.],[6,9,5,1,3.]],threshold:-1.5482e-003,right_val:0.51281,left_val:0.36803},{features:[[9,7,3,3,-1.],[10,7,1,3,3.]],threshold:5.3746e-003,right_val:0.61016,left_val:0.48389},{features:[[8,8,4,3,-1.],[8,9,4,1,3.]],threshold:1.5787e-003,right_val:0.41185,left_val:0.53252},{features:[[9,6,2,4,-1.],[9,6,1,4,2.]],threshold:3.6856e-003,right_val:0.62523,left_val:0.48109},{features:[[0,7,15,1,-1.],[5,7,5,1,3.]],threshold:9.3887e-003,right_val:0.36294,left_val:0.52002},{features:[[8,2,7,9,-1.],[8,5,7,3,3.]],threshold:0.012793,right_val:0.6738,left_val:0.49617},{features:[[1,7,16,4,-1.],[1,7,8,2,2.],[9,9,8,2,2.]],threshold:-3.3661e-003,right_val:0.52836,left_val:0.40603},{features:[[6,12,8,2,-1.],[6,13,8,1,2.]],threshold:3.9771e-004,right_val:0.59008,left_val:0.46741},{features:[[8,11,3,3,-1.],[8,12,3,1,3.]],threshold:1.4868e-003,right_val:0.60821,left_val:0.45191},{features:[[4,5,14,10,-1.],[11,5,7,5,2.],[4,10,7,5,2.]],threshold:-0.088687,right_val:0.5181,left_val:0.28079},{features:[[4,12,3,2,-1.],[4,13,3,1,2.]],threshold:-7.4296e-005,right_val:0.40876,left_val:0.52956},{features:[[9,11,6,1,-1.],[11,11,2,1,3.]],threshold:-1.4933e-005,right_val:0.45385,left_val:0.54614},{features:[[4,9,7,6,-1.],[4,11,7,2,3.]],threshold:5.9162e-003,right_val:0.41921,left_val:0.53292},{features:[[7,10,6,3,-1.],[7,11,6,1,3.]],threshold:1.1142e-003,right_val:0.57062,left_val:0.4512},{features:[[9,11,2,2,-1.],[9,12,2,1,2.]],threshold:8.9249e-005,right_val:0.58976,left_val:0.45778},{features:[[0,5,20,6,-1.],[0,7,20,2,3.]],threshold:2.532e-003,right_val:0.33576,left_val:0.52996},{features:[[6,4,6,1,-1.],[8,4,2,1,3.]],threshold:0.012426,right_val:0.13466,left_val:0.49591},{features:[[9,11,6,1,-1.],[11,11,2,1,3.]],threshold:0.028336,right_val:6.1044e-004,left_val:0.51171},{features:[[5,11,6,1,-1.],[7,11,2,1,3.]],threshold:6.6166e-003,right_val:0.70116,left_val:0.47363},{features:[[10,16,3,4,-1.],[11,16,1,4,3.]],threshold:8.0469e-003,right_val:0.32828,left_val:0.52164},{features:[[8,7,3,3,-1.],[9,7,1,3,3.]],threshold:-1.1194e-003,right_val:0.45637,left_val:0.58099},{features:[[2,12,16,8,-1.],[2,16,16,4,2.]],threshold:0.013278,right_val:0.41039,left_val:0.53984},{features:[[0,15,15,2,-1.],[0,16,15,1,2.]],threshold:4.8795e-004,right_val:0.54106,left_val:0.42493},{features:[[15,4,5,6,-1.],[15,6,5,2,3.]],threshold:0.011243,right_val:0.34382,left_val:0.527},{features:[[9,5,2,4,-1.],[10,5,1,4,2.]],threshold:-8.9897e-004,right_val:0.44566,left_val:0.56331},{features:[[8,10,9,6,-1.],[8,12,9,2,3.]],threshold:6.6677e-003,right_val:0.43627,left_val:0.53129},{features:[[2,19,15,1,-1.],[7,19,5,1,3.]],threshold:0.028947,right_val:0.65758,left_val:0.47018},{features:[[10,16,3,4,-1.],[11,16,1,4,3.]],threshold:-0.0234,right_val:0.51374,left_val:0.},{features:[[0,15,20,4,-1.],[0,17,20,2,2.]],threshold:-0.089117,right_val:0.49424,left_val:0.023745},{features:[[10,16,3,4,-1.],[11,16,1,4,3.]],threshold:-0.014055,right_val:0.51175,left_val:0.31273},{features:[[7,16,3,4,-1.],[8,16,1,4,3.]],threshold:8.1239e-003,right_val:0.252,left_val:0.5009},{features:[[9,16,3,3,-1.],[9,17,3,1,3.]],threshold:-4.9965e-003,right_val:0.49278,left_val:0.63871},{features:[[8,11,4,6,-1.],[8,14,4,3,2.]],threshold:3.1254e-003,right_val:0.36805,left_val:0.51368},{features:[[9,6,2,12,-1.],[9,10,2,4,3.]],threshold:6.767e-003,right_val:0.43636,left_val:0.55098},{features:[[8,17,4,3,-1.],[8,18,4,1,3.]],threshold:-2.3711e-003,right_val:0.45869,left_val:0.61623},{features:[[9,18,8,2,-1.],[13,18,4,1,2.],[9,19,4,1,2.]],threshold:-5.3523e-003,right_val:0.49205,left_val:0.61855},{features:[[1,18,8,2,-1.],[1,19,8,1,2.]],threshold:-0.015969,right_val:0.49833,left_val:0.13826},{features:[[13,5,6,15,-1.],[15,5,2,15,3.]],threshold:4.7676e-003,right_val:0.549,left_val:0.46881},{features:[[9,8,2,2,-1.],[9,9,2,1,2.]],threshold:-2.4715e-003,right_val:0.5004,left_val:0.23685},{features:[[9,5,2,3,-1.],[9,5,1,3,2.]],threshold:-7.1034e-004,right_val:0.47215,left_val:0.58564},{features:[[1,5,6,15,-1.],[3,5,2,15,3.]],threshold:-0.14118,right_val:0.49616,left_val:0.0869},{features:[[4,1,14,8,-1.],[11,1,7,4,2.],[4,5,7,4,2.]],threshold:0.10652,right_val:0.1741,left_val:0.51388},{features:[[2,4,4,16,-1.],[2,4,2,8,2.],[4,12,2,8,2.]],threshold:-0.052745,right_val:0.47729,left_val:0.73536},{features:[[12,4,3,12,-1.],[12,10,3,6,2.]],threshold:-4.7432e-003,right_val:0.52927,left_val:0.38844},{features:[[4,5,10,12,-1.],[4,5,5,6,2.],[9,11,5,6,2.]],threshold:9.9677e-004,right_val:0.40034,left_val:0.52235},{features:[[9,14,2,3,-1.],[9,15,2,1,3.]],threshold:8.0284e-003,right_val:0.7213,left_val:0.49591},{features:[[5,4,2,3,-1.],[5,5,2,1,3.]],threshold:8.6026e-004,right_val:0.55385,left_val:0.44449},{features:[[12,2,4,10,-1.],[14,2,2,5,2.],[12,7,2,5,2.]],threshold:9.3192e-004,right_val:0.41632,left_val:0.53984},{features:[[6,4,7,3,-1.],[6,5,7,1,3.]],threshold:-2.5082e-003,right_val:0.45625,left_val:0.58543},{features:[[2,0,18,2,-1.],[11,0,9,1,2.],[2,1,9,1,2.]],threshold:-2.1379e-003,right_val:0.52803,left_val:0.46081},{features:[[0,0,18,2,-1.],[0,0,9,1,2.],[9,1,9,1,2.]],threshold:-2.1546e-003,right_val:0.5256,left_val:0.37911},{features:[[13,13,4,6,-1.],[15,13,2,3,2.],[13,16,2,3,2.]],threshold:-7.6214e-003,right_val:0.49521,left_val:0.59986},{features:[[3,13,4,6,-1.],[3,13,2,3,2.],[5,16,2,3,2.]],threshold:2.2055e-003,right_val:0.55885,left_val:0.44842},{features:[[10,12,2,6,-1.],[10,15,2,3,2.]],threshold:1.2587e-003,right_val:0.44238,left_val:0.54507},{features:[[5,9,10,10,-1.],[5,9,5,5,2.],[10,14,5,5,2.]],threshold:-5.0927e-003,right_val:0.5263,left_val:0.41183},{features:[[11,4,4,2,-1.],[13,4,2,1,2.],[11,5,2,1,2.]],threshold:-2.5096e-003,right_val:0.49985,left_val:0.57879},{features:[[7,12,6,8,-1.],[10,12,3,8,2.]],threshold:-0.077328,right_val:0.48111,left_val:0.83979},{features:[[12,2,4,10,-1.],[14,2,2,5,2.],[12,7,2,5,2.]],threshold:-0.041486,right_val:0.5177,left_val:0.24086},{features:[[8,11,2,1,-1.],[9,11,1,1,2.]],threshold:1.0356e-004,right_val:0.54171,left_val:0.43554},{features:[[10,5,1,12,-1.],[10,9,1,4,3.]],threshold:1.3256e-003,right_val:0.48941,left_val:0.5454},{features:[[0,11,6,9,-1.],[3,11,3,9,2.]],threshold:-8.0599e-003,right_val:0.45779,left_val:0.5771},{features:[[12,2,4,10,-1.],[14,2,2,5,2.],[12,7,2,5,2.]],threshold:0.019059,right_val:0.34005,left_val:0.51699},{features:[[4,2,4,10,-1.],[4,2,2,5,2.],[6,7,2,5,2.]],threshold:-0.035058,right_val:0.50005,left_val:0.22032},{features:[[11,4,4,2,-1.],[13,4,2,1,2.],[11,5,2,1,2.]],threshold:5.7296e-003,right_val:0.65976,left_val:0.50434},{features:[[0,14,6,3,-1.],[0,15,6,1,3.]],threshold:-0.011648,right_val:0.49967,left_val:0.21863},{features:[[11,4,4,2,-1.],[13,4,2,1,2.],[11,5,2,1,2.]],threshold:1.4544e-003,right_val:0.55037,left_val:0.50077},{features:[[6,1,3,2,-1.],[7,1,1,2,3.]],threshold:-2.5031e-004,right_val:0.52417,left_val:0.41298},{features:[[11,4,4,2,-1.],[13,4,2,1,2.],[11,5,2,1,2.]],threshold:-8.2907e-004,right_val:0.49745,left_val:0.54129},{features:[[5,4,4,2,-1.],[5,4,2,1,2.],[7,5,2,1,2.]],threshold:1.0862e-003,right_val:0.58792,left_val:0.46055},{features:[[13,0,2,12,-1.],[14,0,1,6,2.],[13,6,1,6,2.]],threshold:2.0001e-004,right_val:0.47052,left_val:0.52789},{features:[[6,0,3,10,-1.],[7,0,1,10,3.]],threshold:2.9213e-003,right_val:0.37555,left_val:0.51296},{features:[[3,0,17,8,-1.],[3,4,17,4,2.]],threshold:0.025387,right_val:0.57908,left_val:0.48227},{features:[[0,4,20,4,-1.],[0,6,20,2,2.]],threshold:-3.1968e-003,right_val:0.39628,left_val:0.52484}],threshold:87.696},{simpleClassifiers:[{features:[[0,3,8,2,-1.],[4,3,4,2,2.]],threshold:5.8032e-003,right_val:0.5962,left_val:0.3499},{features:[[8,11,4,3,-1.],[8,12,4,1,3.]],threshold:-9.0003e-003,right_val:0.44786,left_val:0.68166},{features:[[5,7,6,4,-1.],[5,7,3,2,2.],[8,9,3,2,2.]],threshold:-1.155e-003,right_val:0.35783,left_val:0.55857},{features:[[8,3,4,9,-1.],[8,6,4,3,3.]],threshold:-1.107e-003,right_val:0.30504,left_val:0.5365},{features:[[8,15,1,4,-1.],[8,17,1,2,2.]],threshold:1.0308e-004,right_val:0.53446,left_val:0.36391},{features:[[4,5,12,7,-1.],[8,5,4,7,3.]],threshold:-5.0985e-003,right_val:0.55043,left_val:0.28592},{features:[[4,2,4,10,-1.],[4,2,2,5,2.],[6,7,2,5,2.]],threshold:8.2572e-004,right_val:0.3476,left_val:0.52365},{features:[[3,0,17,2,-1.],[3,1,17,1,2.]],threshold:9.9783e-003,right_val:0.62196,left_val:0.47503},{features:[[2,2,16,15,-1.],[2,7,16,5,3.]],threshold:-0.037403,right_val:0.52781,left_val:0.33434},{features:[[15,2,5,2,-1.],[15,3,5,1,2.]],threshold:4.8548e-003,right_val:0.37004,left_val:0.51922},{features:[[9,3,2,2,-1.],[10,3,1,2,2.]],threshold:-1.8664e-003,right_val:0.50919,left_val:0.29298},{features:[[4,5,16,15,-1.],[4,10,16,5,3.]],threshold:0.016889,right_val:0.54312,left_val:0.36868},{features:[[7,13,5,6,-1.],[7,16,5,3,2.]],threshold:-5.8373e-003,right_val:0.52213,left_val:0.36322},{features:[[10,7,3,2,-1.],[11,7,1,2,3.]],threshold:-1.4714e-003,right_val:0.47007,left_val:0.58707},{features:[[8,3,3,1,-1.],[9,3,1,1,3.]],threshold:-1.1523e-003,right_val:0.5141,left_val:0.31959},{features:[[9,16,3,3,-1.],[9,17,3,1,3.]],threshold:-4.256e-003,right_val:0.48149,left_val:0.63019},{features:[[0,2,5,2,-1.],[0,3,5,1,2.]],threshold:-6.7378e-003,right_val:0.50258,left_val:0.1977},{features:[[12,5,4,3,-1.],[12,6,4,1,3.]],threshold:0.011383,right_val:0.6867,left_val:0.49541},{features:[[1,7,12,1,-1.],[5,7,4,1,3.]],threshold:5.1795e-003,right_val:0.33506,left_val:0.51644},{features:[[7,5,6,14,-1.],[7,12,6,7,2.]],threshold:-0.11744,right_val:0.52344,left_val:0.23152},{features:[[0,0,8,10,-1.],[0,0,4,5,2.],[4,5,4,5,2.]],threshold:0.028703,right_val:0.67225,left_val:0.46643},{features:[[9,1,3,2,-1.],[10,1,1,2,3.]],threshold:4.8231e-003,right_val:0.27235,left_val:0.52209},{features:[[8,1,3,2,-1.],[9,1,1,2,3.]],threshold:2.6799e-003,right_val:0.29069,left_val:0.50793},{features:[[12,4,3,3,-1.],[12,5,3,1,3.]],threshold:8.0504e-003,right_val:0.6395,left_val:0.4886},{features:[[7,4,6,16,-1.],[7,12,6,8,2.]],threshold:4.8055e-003,right_val:0.36567,left_val:0.51973},{features:[[12,4,3,3,-1.],[12,5,3,1,3.]],threshold:-2.242e-003,right_val:0.47637,left_val:0.61535},{features:[[2,3,2,6,-1.],[2,5,2,2,3.]],threshold:-0.013758,right_val:0.50309,left_val:0.26373},{features:[[14,2,6,9,-1.],[14,5,6,3,3.]],threshold:-0.10338,right_val:0.51825,left_val:0.22875},{features:[[5,4,3,3,-1.],[5,5,3,1,3.]],threshold:-9.4432e-003,right_val:0.46949,left_val:0.69533},{features:[[9,17,3,2,-1.],[10,17,1,2,3.]],threshold:8.0271e-004,right_val:0.42688,left_val:0.54507},{features:[[5,5,2,3,-1.],[5,6,2,1,3.]],threshold:-4.1946e-003,right_val:0.45716,left_val:0.60914},{features:[[13,11,3,6,-1.],[13,13,3,2,3.]],threshold:0.010942,right_val:0.32845,left_val:0.52411},{features:[[3,14,2,6,-1.],[3,17,2,3,2.]],threshold:-5.7841e-004,right_val:0.41794,left_val:0.53879},{features:[[14,3,6,2,-1.],[14,4,6,1,2.]],threshold:-2.0889e-003,right_val:0.53017,left_val:0.42927},{features:[[0,8,16,2,-1.],[0,9,16,1,2.]],threshold:3.2384e-003,right_val:0.52207,left_val:0.37923},{features:[[14,3,6,2,-1.],[14,4,6,1,2.]],threshold:4.9075e-003,right_val:0.41268,left_val:0.52373},{features:[[0,0,5,6,-1.],[0,2,5,2,3.]],threshold:-0.032278,right_val:0.49945,left_val:0.19477},{features:[[12,5,4,3,-1.],[12,6,4,1,3.]],threshold:-8.9711e-003,right_val:0.4929,left_val:0.60113},{features:[[4,11,3,6,-1.],[4,13,3,2,3.]],threshold:0.015321,right_val:0.20398,left_val:0.50098},{features:[[12,5,4,3,-1.],[12,6,4,1,3.]],threshold:2.0856e-003,right_val:0.57217,left_val:0.48622},{features:[[9,5,1,3,-1.],[9,6,1,1,3.]],threshold:5.0615e-003,right_val:0.18018,left_val:0.50002},{features:[[12,5,4,3,-1.],[12,6,4,1,3.]],threshold:-3.7175e-003,right_val:0.48976,left_val:0.55301},{features:[[6,6,8,12,-1.],[6,12,8,6,2.]],threshold:-0.012171,right_val:0.53837,left_val:0.41786},{features:[[12,5,4,3,-1.],[12,6,4,1,3.]],threshold:4.6248e-003,right_val:0.57613,left_val:0.49972},{features:[[5,12,9,2,-1.],[8,12,3,2,3.]],threshold:-2.104e-004,right_val:0.40977,left_val:0.53318},{features:[[12,5,4,3,-1.],[12,6,4,1,3.]],threshold:-0.014642,right_val:0.50518,left_val:0.57559},{features:[[4,5,4,3,-1.],[4,6,4,1,3.]],threshold:3.3199e-003,right_val:0.60318,left_val:0.4577},{features:[[6,6,9,2,-1.],[9,6,3,2,3.]],threshold:3.7237e-003,right_val:0.54159,left_val:0.43804},{features:[[4,11,1,3,-1.],[4,12,1,1,3.]],threshold:8.2951e-004,right_val:0.37022,left_val:0.5163},{features:[[14,12,6,6,-1.],[14,12,3,6,2.]],threshold:-0.011408,right_val:0.48626,left_val:0.60729},{features:[[7,0,3,7,-1.],[8,0,1,7,3.]],threshold:-4.532e-003,right_val:0.5089,left_val:0.32925},{features:[[9,8,3,3,-1.],[10,8,1,3,3.]],threshold:5.1276e-003,right_val:0.61227,left_val:0.48298},{features:[[8,8,3,3,-1.],[9,8,1,3,3.]],threshold:9.8583e-003,right_val:0.65562,left_val:0.46607},{features:[[5,10,11,3,-1.],[5,11,11,1,3.]],threshold:0.036986,right_val:0.16905,left_val:0.52048},{features:[[5,7,10,1,-1.],[10,7,5,1,2.]],threshold:4.6491e-003,right_val:0.37252,left_val:0.51673},{features:[[9,7,3,2,-1.],[10,7,1,2,3.]],threshold:-4.2665e-003,right_val:0.49873,left_val:0.64065},{features:[[8,7,3,2,-1.],[9,7,1,2,3.]],threshold:-4.7957e-004,right_val:0.44649,left_val:0.58973},{features:[[11,9,4,2,-1.],[11,9,2,2,2.]],threshold:3.6827e-003,right_val:0.34727,left_val:0.54416},{features:[[5,9,4,2,-1.],[7,9,2,2,2.]],threshold:-0.01006,right_val:0.50048,left_val:0.21432},{features:[[14,10,2,4,-1.],[14,12,2,2,2.]],threshold:-3.0362e-004,right_val:0.45903,left_val:0.53864},{features:[[7,7,3,2,-1.],[8,7,1,2,3.]],threshold:-1.4545e-003,right_val:0.44971,left_val:0.57512},{features:[[14,17,6,3,-1.],[14,18,6,1,3.]],threshold:1.6515e-003,right_val:0.42385,left_val:0.54219},{features:[[4,5,12,12,-1.],[4,5,6,6,2.],[10,11,6,6,2.]],threshold:-7.8469e-003,right_val:0.52582,left_val:0.40779},{features:[[6,9,8,8,-1.],[10,9,4,4,2.],[6,13,4,4,2.]],threshold:-5.126e-003,right_val:0.54795,left_val:0.42293},{features:[[0,4,15,4,-1.],[5,4,5,4,3.]],threshold:-0.036891,right_val:0.46747,left_val:0.65964},{features:[[13,2,4,1,-1.],[13,2,2,1,2.]],threshold:2.4036e-004,right_val:0.55732,left_val:0.42511},{features:[[4,12,2,2,-1.],[4,13,2,1,2.]],threshold:-1.515e-005,right_val:0.40741,left_val:0.52592},{features:[[8,13,4,3,-1.],[8,14,4,1,3.]],threshold:2.2108e-003,right_val:0.58864,left_val:0.46717},{features:[[9,13,2,3,-1.],[9,14,2,1,3.]],threshold:-1.1569e-003,right_val:0.44872,left_val:0.57111},{features:[[13,11,2,3,-1.],[13,12,2,1,3.]],threshold:4.9996e-003,right_val:0.28983,left_val:0.52642},{features:[[7,12,4,4,-1.],[7,12,2,2,2.],[9,14,2,2,2.]],threshold:-1.4656e-003,right_val:0.51979,left_val:0.38917},{features:[[10,11,2,2,-1.],[11,11,1,1,2.],[10,12,1,1,2.]],threshold:-1.1975e-003,right_val:0.4928,left_val:0.57959},{features:[[8,17,3,2,-1.],[9,17,1,2,3.]],threshold:-4.4954e-003,right_val:0.50126,left_val:0.23776},{features:[[10,11,2,2,-1.],[11,11,1,1,2.],[10,12,1,1,2.]],threshold:1.4997e-004,right_val:0.56176,left_val:0.48766},{features:[[0,17,6,3,-1.],[0,18,6,1,3.]],threshold:2.6392e-003,right_val:0.37655,left_val:0.51681},{features:[[10,11,2,2,-1.],[11,11,1,1,2.],[10,12,1,1,2.]],threshold:-2.9368e-004,right_val:0.48746,left_val:0.54466},{features:[[8,11,2,2,-1.],[8,11,1,1,2.],[9,12,1,1,2.]],threshold:1.4212e-003,right_val:0.66913,left_val:0.46879},{features:[[12,5,8,4,-1.],[12,5,4,4,2.]],threshold:0.079428,right_val:0.27329,left_val:0.51934},{features:[[0,5,8,4,-1.],[4,5,4,4,2.]],threshold:0.079938,right_val:0.17821,left_val:0.49717},{features:[[13,2,4,1,-1.],[13,2,2,1,2.]],threshold:0.011089,right_val:0.32095,left_val:0.5166},{features:[[3,2,4,1,-1.],[5,2,2,1,2.]],threshold:1.6561e-004,right_val:0.53073,left_val:0.40585},{features:[[10,0,4,2,-1.],[12,0,2,1,2.],[10,1,2,1,2.]],threshold:-5.3354e-003,right_val:0.51581,left_val:0.34451},{features:[[7,12,3,1,-1.],[8,12,1,1,3.]],threshold:1.1287e-003,right_val:0.60755,left_val:0.45949},{features:[[8,11,4,8,-1.],[10,11,2,4,2.],[8,15,2,4,2.]],threshold:-0.021969,right_val:0.52286,left_val:0.16804},{features:[[9,9,2,2,-1.],[9,10,2,1,2.]],threshold:-2.1775e-004,right_val:0.52157,left_val:0.38616},{features:[[3,18,15,2,-1.],[3,19,15,1,2.]],threshold:2.02e-004,right_val:0.4363,left_val:0.5518},{features:[[2,6,2,12,-1.],[2,6,1,6,2.],[3,12,1,6,2.]],threshold:-0.021733,right_val:0.47899,left_val:0.79995},{features:[[9,8,2,3,-1.],[9,9,2,1,3.]],threshold:-8.44e-004,right_val:0.53748,left_val:0.4086},{features:[[7,10,3,2,-1.],[8,10,1,2,3.]],threshold:-4.3895e-004,right_val:0.43661,left_val:0.54704},{features:[[11,11,3,1,-1.],[12,11,1,1,3.]],threshold:1.5092e-003,right_val:0.58421,left_val:0.4989},{features:[[6,11,3,1,-1.],[7,11,1,1,3.]],threshold:-3.5548e-003,right_val:0.4721,left_val:0.67537},{features:[[9,2,4,2,-1.],[11,2,2,1,2.],[9,3,2,1,2.]],threshold:4.8191e-004,right_val:0.43571,left_val:0.54159},{features:[[4,12,2,3,-1.],[4,13,2,1,3.]],threshold:-6.0264e-003,right_val:0.49919,left_val:0.22585},{features:[[2,1,18,3,-1.],[8,1,6,3,3.]],threshold:-0.011668,right_val:0.49275,left_val:0.62566},{features:[[5,1,4,14,-1.],[7,1,2,14,2.]],threshold:-2.8718e-003,right_val:0.52458,left_val:0.39478},{features:[[8,16,12,3,-1.],[8,16,6,3,2.]],threshold:0.017051,right_val:0.57942,left_val:0.47525},{features:[[1,17,18,3,-1.],[7,17,6,3,3.]],threshold:-0.013352,right_val:0.45445,left_val:0.60411},{features:[[9,14,2,6,-1.],[9,17,2,3,2.]],threshold:-3.9302e-004,right_val:0.55449,left_val:0.42583},{features:[[9,12,1,8,-1.],[9,16,1,4,2.]],threshold:3.0483e-003,right_val:0.37803,left_val:0.52334},{features:[[9,14,2,3,-1.],[9,15,2,1,3.]],threshold:-4.3579e-003,right_val:0.48387,left_val:0.63719},{features:[[9,6,2,12,-1.],[9,10,2,4,3.]],threshold:5.6661e-003,right_val:0.41637,left_val:0.53747},{features:[[12,9,3,3,-1.],[12,10,3,1,3.]],threshold:6.0677e-005,right_val:0.53116,left_val:0.46388},{features:[[0,1,4,8,-1.],[2,1,2,8,2.]],threshold:0.036738,right_val:0.64665,left_val:0.46887},{features:[[9,1,6,2,-1.],[12,1,3,1,2.],[9,2,3,1,2.]],threshold:8.6528e-003,right_val:0.21887,left_val:0.52043},{features:[[1,3,12,14,-1.],[1,10,12,7,2.]],threshold:-0.15371,right_val:0.49588,left_val:0.16304},{features:[[8,12,4,2,-1.],[10,12,2,1,2.],[8,13,2,1,2.]],threshold:-4.156e-004,right_val:0.46965,left_val:0.57745},{features:[[1,9,10,2,-1.],[1,9,5,1,2.],[6,10,5,1,2.]],threshold:-1.264e-003,right_val:0.52172,left_val:0.39772},{features:[[8,15,4,3,-1.],[8,16,4,1,3.]],threshold:-3.5473e-003,right_val:0.48083,left_val:0.60465},{features:[[6,8,8,3,-1.],[6,9,8,1,3.]],threshold:3.0019e-005,right_val:0.52282,left_val:0.39967},{features:[[9,15,5,3,-1.],[9,16,5,1,3.]],threshold:1.3113e-003,right_val:0.5766,left_val:0.47122},{features:[[8,7,4,3,-1.],[8,8,4,1,3.]],threshold:-1.3375e-003,right_val:0.52532,left_val:0.41096},{features:[[7,7,6,2,-1.],[7,8,6,1,2.]],threshold:0.020877,right_val:0.1758,left_val:0.5203},{features:[[5,7,8,2,-1.],[5,7,4,1,2.],[9,8,4,1,2.]],threshold:-7.5498e-003,right_val:0.4695,left_val:0.65666},{features:[[12,9,3,3,-1.],[12,10,3,1,3.]],threshold:0.024189,right_val:0.33702,left_val:0.51287},{features:[[4,7,4,2,-1.],[4,8,4,1,2.]],threshold:-2.9359e-003,right_val:0.46945,left_val:0.65808},{features:[[14,2,6,9,-1.],[14,5,6,3,3.]],threshold:0.057558,right_val:0.27753,left_val:0.51464},{features:[[4,9,3,3,-1.],[5,9,1,3,3.]],threshold:-1.1343e-003,right_val:0.51927,left_val:0.38366},{features:[[12,9,3,3,-1.],[12,10,3,1,3.]],threshold:0.016817,right_val:0.61773,left_val:0.50856},{features:[[0,2,6,9,-1.],[0,5,6,3,3.]],threshold:5.0535e-003,right_val:0.36848,left_val:0.51388},{features:[[17,3,3,6,-1.],[18,3,1,6,3.]],threshold:-4.5875e-003,right_val:0.48352,left_val:0.59897},{features:[[0,3,3,6,-1.],[1,3,1,6,3.]],threshold:1.6882e-003,right_val:0.57231,left_val:0.45095},{features:[[17,14,1,2,-1.],[17,15,1,1,2.]],threshold:-1.6554e-003,right_val:0.52433,left_val:0.34968},{features:[[4,9,4,3,-1.],[6,9,2,3,2.]],threshold:-0.019374,right_val:0.49687,left_val:0.11205},{features:[[12,9,3,3,-1.],[12,10,3,1,3.]],threshold:0.010374,right_val:0.43952,left_val:0.51482},{features:[[5,9,3,3,-1.],[5,10,3,1,3.]],threshold:1.4973e-004,right_val:0.52699,left_val:0.4085},{features:[[9,5,6,8,-1.],[12,5,3,4,2.],[9,9,3,4,2.]],threshold:-0.042982,right_val:0.50185,left_val:0.63941},{features:[[5,5,6,8,-1.],[5,5,3,4,2.],[8,9,3,4,2.]],threshold:8.3066e-003,right_val:0.66984,left_val:0.47076},{features:[[16,1,4,6,-1.],[16,4,4,3,2.]],threshold:-4.1286e-003,right_val:0.53236,left_val:0.45414},{features:[[1,0,6,20,-1.],[3,0,2,20,3.]],threshold:1.7399e-003,right_val:0.54399,left_val:0.4334},{features:[[12,11,3,2,-1.],[13,11,1,2,3.]],threshold:1.174e-004,right_val:0.55434,left_val:0.45797},{features:[[5,11,3,2,-1.],[6,11,1,2,3.]],threshold:1.8586e-004,right_val:0.54268,left_val:0.43246},{features:[[9,4,6,1,-1.],[11,4,2,1,3.]],threshold:5.5588e-003,right_val:0.35506,left_val:0.52572},{features:[[0,0,8,3,-1.],[4,0,4,3,2.]],threshold:-7.9852e-003,right_val:0.46306,left_val:0.6043},{features:[[15,0,2,5,-1.],[15,0,1,5,2.]],threshold:6.0594e-004,right_val:0.55332,left_val:0.45983},{features:[[4,1,3,2,-1.],[5,1,1,2,3.]],threshold:-2.2983e-004,right_val:0.53225,left_val:0.41308},{features:[[7,0,6,15,-1.],[9,0,2,15,3.]],threshold:4.374e-004,right_val:0.54093,left_val:0.4043},{features:[[6,11,3,1,-1.],[7,11,1,1,3.]],threshold:2.9482e-004,right_val:0.56289,left_val:0.4495},{features:[[12,0,3,4,-1.],[13,0,1,4,3.]],threshold:0.010313,right_val:0.27043,left_val:0.51775},{features:[[5,4,6,1,-1.],[7,4,2,1,3.]],threshold:-7.7241e-003,right_val:0.49806,left_val:0.1988},{features:[[12,7,3,2,-1.],[12,8,3,1,2.]],threshold:-4.6797e-003,right_val:0.50183,left_val:0.66448},{features:[[0,1,4,6,-1.],[0,4,4,3,2.]],threshold:-5.0755e-003,right_val:0.51853,left_val:0.38983},{features:[[12,7,3,2,-1.],[12,8,3,1,2.]],threshold:2.248e-003,right_val:0.56603,left_val:0.48018},{features:[[2,16,3,3,-1.],[2,17,3,1,3.]],threshold:8.3327e-004,right_val:0.39572,left_val:0.52109},{features:[[13,8,6,10,-1.],[16,8,3,5,2.],[13,13,3,5,2.]],threshold:-0.041279,right_val:0.50071,left_val:0.61545},{features:[[0,9,5,2,-1.],[0,10,5,1,2.]],threshold:-5.093e-004,right_val:0.52284,left_val:0.39759},{features:[[12,11,2,2,-1.],[13,11,1,1,2.],[12,12,1,1,2.]],threshold:1.2569e-003,right_val:0.59392,left_val:0.49791},{features:[[3,15,3,3,-1.],[3,16,3,1,3.]],threshold:8.0048e-003,right_val:0.16334,left_val:0.49845},{features:[[12,7,3,2,-1.],[12,8,3,1,2.]],threshold:-1.1879e-003,right_val:0.49426,left_val:0.5905},{features:[[5,7,3,2,-1.],[5,8,3,1,2.]],threshold:6.1949e-004,right_val:0.53287,left_val:0.41996},{features:[[9,5,9,9,-1.],[9,8,9,3,3.]],threshold:6.683e-003,right_val:0.49059,left_val:0.54186},{features:[[5,0,3,7,-1.],[6,0,1,7,3.]],threshold:-3.7062e-003,right_val:0.5138,left_val:0.37259},{features:[[5,2,12,5,-1.],[9,2,4,5,3.]],threshold:-0.039739,right_val:0.50503,left_val:0.6479},{features:[[6,11,2,2,-1.],[6,11,1,1,2.],[7,12,1,1,2.]],threshold:1.4085e-003,right_val:0.63779,left_val:0.46823},{features:[[15,15,3,2,-1.],[15,16,3,1,2.]],threshold:3.9323e-004,right_val:0.41505,left_val:0.54585},{features:[[2,15,3,2,-1.],[2,16,3,1,2.]],threshold:-1.898e-003,right_val:0.51497,left_val:0.36902},{features:[[14,12,6,8,-1.],[17,12,3,4,2.],[14,16,3,4,2.]],threshold:-0.01397,right_val:0.48114,left_val:0.60506},{features:[[2,8,15,6,-1.],[7,8,5,6,3.]],threshold:-0.10101,right_val:0.49924,left_val:0.20171},{features:[[2,2,18,17,-1.],[8,2,6,17,3.]],threshold:-0.017347,right_val:0.48995,left_val:0.57131},{features:[[5,1,4,1,-1.],[7,1,2,1,2.]],threshold:1.562e-004,right_val:0.53926,left_val:0.42154},{features:[[5,2,12,5,-1.],[9,2,4,5,3.]],threshold:0.13439,right_val:0.37676,left_val:0.51362},{features:[[3,2,12,5,-1.],[7,2,4,5,3.]],threshold:-0.024582,right_val:0.47479,left_val:0.70274},{features:[[4,9,12,4,-1.],[10,9,6,2,2.],[4,11,6,2,2.]],threshold:-3.8554e-003,right_val:0.54277,left_val:0.43174},{features:[[5,15,6,2,-1.],[5,15,3,1,2.],[8,16,3,1,2.]],threshold:-2.3165e-003,right_val:0.46186,left_val:0.59427},{features:[[10,14,2,3,-1.],[10,15,2,1,3.]],threshold:-4.8518e-003,right_val:0.48849,left_val:0.61916},{features:[[0,13,20,2,-1.],[0,13,10,1,2.],[10,14,10,1,2.]],threshold:2.47e-003,right_val:0.40172,left_val:0.52567},{features:[[4,9,12,8,-1.],[10,9,6,4,2.],[4,13,6,4,2.]],threshold:0.045497,right_val:0.26858,left_val:0.52379},{features:[[8,13,3,6,-1.],[8,16,3,3,2.]],threshold:-0.02032,right_val:0.49797,left_val:0.21304},{features:[[10,12,2,2,-1.],[10,13,2,1,2.]],threshold:2.6995e-004,right_val:0.55431,left_val:0.4814},{features:[[9,12,2,2,-1.],[9,12,1,1,2.],[10,13,1,1,2.]],threshold:-1.8233e-003,right_val:0.471,left_val:0.64826},{features:[[4,11,14,4,-1.],[11,11,7,2,2.],[4,13,7,2,2.]],threshold:-6.3016e-003,right_val:0.53062,left_val:0.45819},{features:[[8,5,4,2,-1.],[8,6,4,1,2.]],threshold:-2.4139e-004,right_val:0.40518,left_val:0.52321},{features:[[10,10,6,3,-1.],[12,10,2,3,3.]],threshold:-1.033e-003,right_val:0.47892,left_val:0.55562},{features:[[2,14,1,2,-1.],[2,15,1,1,2.]],threshold:1.8041e-004,right_val:0.40118,left_val:0.52294},{features:[[13,8,6,12,-1.],[16,8,3,6,2.],[13,14,3,6,2.]],threshold:-0.061408,right_val:0.50107,left_val:0.62987},{features:[[1,8,6,12,-1.],[1,8,3,6,2.],[4,14,3,6,2.]],threshold:-0.069544,right_val:0.47732,left_val:0.72283},{features:[[10,0,6,10,-1.],[12,0,2,10,3.]],threshold:-0.070543,right_val:0.51825,left_val:0.22695},{features:[[5,11,8,4,-1.],[5,11,4,2,2.],[9,13,4,2,2.]],threshold:2.4424e-003,right_val:0.40982,left_val:0.52371},{features:[[10,16,8,4,-1.],[14,16,4,2,2.],[10,18,4,2,2.]],threshold:1.5494e-003,right_val:0.5468,left_val:0.47738},{features:[[7,7,6,6,-1.],[9,7,2,6,3.]],threshold:-0.023914,right_val:0.47838,left_val:0.7147},{features:[[10,2,4,10,-1.],[10,2,2,10,2.]],threshold:-0.012454,right_val:0.52411,left_val:0.26353},{features:[[6,1,4,9,-1.],[8,1,2,9,2.]],threshold:-2.076e-004,right_val:0.51136,left_val:0.36238},{features:[[12,19,2,1,-1.],[12,19,1,1,2.]],threshold:2.9781e-005,right_val:0.54328,left_val:0.47059}],threshold:90.253},{simpleClassifiers:[{features:[[1,2,4,9,-1.],[3,2,2,9,2.]],threshold:0.011773,right_val:0.64212,left_val:0.38605},{features:[[7,5,6,4,-1.],[9,5,2,4,3.]],threshold:0.027038,right_val:0.6754,left_val:0.43857},{features:[[9,4,2,4,-1.],[9,6,2,2,2.]],threshold:-3.642e-005,right_val:0.34233,left_val:0.54871},{features:[[14,5,2,8,-1.],[14,9,2,4,2.]],threshold:1.9995e-003,right_val:0.54003,left_val:0.32305},{features:[[7,6,5,12,-1.],[7,12,5,6,2.]],threshold:4.5278e-003,right_val:0.2935,left_val:0.50916},{features:[[14,6,2,6,-1.],[14,9,2,3,2.]],threshold:4.7891e-004,right_val:0.53441,left_val:0.41782},{features:[[4,6,2,6,-1.],[4,9,2,3,2.]],threshold:1.1721e-003,right_val:0.51321,left_val:0.28992},{features:[[8,15,10,4,-1.],[13,15,5,2,2.],[8,17,5,2,2.]],threshold:9.5306e-004,right_val:0.55608,left_val:0.42801},{features:[[6,18,2,2,-1.],[7,18,1,2,2.]],threshold:1.5099e-005,right_val:0.54048,left_val:0.40449},{features:[[11,3,6,2,-1.],[11,4,6,1,2.]],threshold:-6.0818e-004,right_val:0.55035,left_val:0.42718},{features:[[2,0,16,6,-1.],[2,2,16,2,3.]],threshold:3.3225e-003,right_val:0.53697,left_val:0.39627},{features:[[11,3,6,2,-1.],[11,4,6,1,2.]],threshold:-1.1037e-003,right_val:0.52377,left_val:0.47272},{features:[[4,11,10,3,-1.],[4,12,10,1,3.]],threshold:-1.435e-003,right_val:0.42235,left_val:0.5603},{features:[[11,3,6,2,-1.],[11,4,6,1,2.]],threshold:2.0767e-003,right_val:0.47327,left_val:0.52259},{features:[[3,3,6,2,-1.],[3,4,6,1,2.]],threshold:-1.6413e-004,right_val:0.54327,left_val:0.39991},{features:[[16,0,4,7,-1.],[16,0,2,7,2.]],threshold:8.8302e-003,right_val:0.60273,left_val:0.46784},{features:[[0,14,9,6,-1.],[0,16,9,2,3.]],threshold:-0.010552,right_val:0.5214,left_val:0.3494},{features:[[9,16,3,3,-1.],[9,17,3,1,3.]],threshold:-2.2732e-003,right_val:0.47491,left_val:0.61858},{features:[[4,6,6,2,-1.],[6,6,2,2,3.]],threshold:-8.4786e-004,right_val:0.38435,left_val:0.52853},{features:[[15,11,1,3,-1.],[15,12,1,1,3.]],threshold:1.2081e-003,right_val:0.34473,left_val:0.53606},{features:[[5,5,2,3,-1.],[5,6,2,1,3.]],threshold:2.6513e-003,right_val:0.6194,left_val:0.45583},{features:[[10,9,2,2,-1.],[10,10,2,1,2.]],threshold:-1.1012e-003,right_val:0.53276,left_val:0.36802},{features:[[3,1,4,3,-1.],[5,1,2,3,2.]],threshold:4.9562e-004,right_val:0.52749,left_val:0.39606},{features:[[16,0,4,7,-1.],[16,0,2,7,2.]],threshold:-0.043902,right_val:0.49928,left_val:0.70204},{features:[[0,0,20,1,-1.],[10,0,10,1,2.]],threshold:0.03469,right_val:0.27666,left_val:0.50492},{features:[[15,11,1,3,-1.],[15,12,1,1,3.]],threshold:-2.7442e-003,right_val:0.5275,left_val:0.26726},{features:[[0,4,3,4,-1.],[1,4,1,4,3.]],threshold:3.3317e-003,right_val:0.60011,left_val:0.45795},{features:[[16,3,3,6,-1.],[16,5,3,2,3.]],threshold:-0.020045,right_val:0.52357,left_val:0.31716},{features:[[1,3,3,6,-1.],[1,5,3,2,3.]],threshold:1.3492e-003,right_val:0.40343,left_val:0.52654},{features:[[6,2,12,6,-1.],[12,2,6,3,2.],[6,5,6,3,2.]],threshold:2.9702e-003,right_val:0.4572,left_val:0.53325},{features:[[8,10,4,3,-1.],[8,11,4,1,3.]],threshold:6.304e-003,right_val:0.60346,left_val:0.45933},{features:[[4,2,14,6,-1.],[11,2,7,3,2.],[4,5,7,3,2.]],threshold:-0.012937,right_val:0.5373,left_val:0.4438},{features:[[9,11,2,3,-1.],[9,12,2,1,3.]],threshold:4.0149e-003,right_val:0.64378,left_val:0.46803},{features:[[15,13,2,3,-1.],[15,14,2,1,3.]],threshold:-2.6402e-003,right_val:0.53143,left_val:0.37096},{features:[[8,12,4,3,-1.],[8,13,4,1,3.]],threshold:0.013918,right_val:0.71308,left_val:0.47236},{features:[[15,11,1,3,-1.],[15,12,1,1,3.]],threshold:-4.5088e-004,right_val:0.53704,left_val:0.44924},{features:[[7,13,5,2,-1.],[7,14,5,1,2.]],threshold:2.5384e-004,right_val:0.55144,left_val:0.44069},{features:[[7,12,6,3,-1.],[7,13,6,1,3.]],threshold:2.271e-003,right_val:0.5968,left_val:0.46824},{features:[[5,11,4,4,-1.],[5,13,4,2,2.]],threshold:2.4121e-003,right_val:0.30186,left_val:0.50794},{features:[[11,4,3,3,-1.],[12,4,1,3,3.]],threshold:-3.6026e-005,right_val:0.44711,left_val:0.5601},{features:[[6,4,3,3,-1.],[7,4,1,3,3.]],threshold:-7.4906e-003,right_val:0.49899,left_val:0.22075},{features:[[16,5,3,6,-1.],[17,5,1,6,3.]],threshold:-0.017513,right_val:0.50176,left_val:0.65312},{features:[[3,6,12,7,-1.],[7,6,4,7,3.]],threshold:0.14282,right_val:0.14821,left_val:0.4968},{features:[[16,5,3,6,-1.],[17,5,1,6,3.]],threshold:5.5345e-003,right_val:0.59542,left_val:0.48989},{features:[[3,13,2,3,-1.],[3,14,2,1,3.]],threshold:-9.6324e-004,right_val:0.51961,left_val:0.39271},{features:[[16,5,3,6,-1.],[17,5,1,6,3.]],threshold:-2.037e-003,right_val:0.48849,left_val:0.56133},{features:[[1,5,3,6,-1.],[2,5,1,6,3.]],threshold:1.6615e-003,right_val:0.55789,left_val:0.44729},{features:[[1,9,18,1,-1.],[7,9,6,1,3.]],threshold:-3.1188e-003,right_val:0.53975,left_val:0.38405},{features:[[0,9,8,7,-1.],[4,9,4,7,2.]],threshold:-6.4001e-003,right_val:0.45332,left_val:0.5844},{features:[[12,11,8,2,-1.],[12,12,8,1,2.]],threshold:3.132e-004,right_val:0.42347,left_val:0.54392},{features:[[0,11,8,2,-1.],[0,12,8,1,2.]],threshold:-0.018222,right_val:0.49584,left_val:0.12885},{features:[[9,13,2,3,-1.],[9,14,2,1,3.]],threshold:8.7969e-003,right_val:0.71535,left_val:0.49513},{features:[[4,10,12,4,-1.],[4,10,6,2,2.],[10,12,6,2,2.]],threshold:-4.2395e-003,right_val:0.51949,left_val:0.39466},{features:[[9,3,3,7,-1.],[10,3,1,7,3.]],threshold:9.7086e-003,right_val:0.60649,left_val:0.48975},{features:[[7,2,3,5,-1.],[8,2,1,5,3.]],threshold:-3.9934e-003,right_val:0.50608,left_val:0.32454},{features:[[9,12,4,6,-1.],[11,12,2,3,2.],[9,15,2,3,2.]],threshold:-0.016785,right_val:0.52038,left_val:0.1582},{features:[[8,7,3,6,-1.],[9,7,1,6,3.]],threshold:0.018272,right_val:0.6627,left_val:0.46809},{features:[[15,4,4,2,-1.],[15,5,4,1,2.]],threshold:5.6873e-003,right_val:0.35122,left_val:0.52117},{features:[[8,7,3,3,-1.],[9,7,1,3,3.]],threshold:-1.0739e-003,right_val:0.45298,left_val:0.57684},{features:[[14,2,6,4,-1.],[14,4,6,2,2.]],threshold:-3.7094e-003,right_val:0.53136,left_val:0.45078},{features:[[7,16,6,1,-1.],[9,16,2,1,3.]],threshold:-2.1111e-004,right_val:0.43334,left_val:0.54608},{features:[[15,13,2,3,-1.],[15,14,2,1,3.]],threshold:1.067e-003,right_val:0.40784,left_val:0.53719},{features:[[8,7,3,10,-1.],[9,7,1,10,3.]],threshold:3.5943e-003,right_val:0.56438,left_val:0.44713},{features:[[11,10,2,6,-1.],[11,12,2,2,3.]],threshold:-5.1776e-003,right_val:0.52803,left_val:0.44994},{features:[[6,10,4,1,-1.],[8,10,2,1,2.]],threshold:-2.5414e-004,right_val:0.44077,left_val:0.55162},{features:[[10,9,2,2,-1.],[10,10,2,1,2.]],threshold:6.3523e-003,right_val:0.24652,left_val:0.51942},{features:[[8,9,2,2,-1.],[8,10,2,1,2.]],threshold:-4.4205e-004,right_val:0.51397,left_val:0.38307},{features:[[12,7,2,2,-1.],[13,7,1,1,2.],[12,8,1,1,2.]],threshold:7.4489e-004,right_val:0.59748,left_val:0.48911},{features:[[5,7,2,2,-1.],[5,7,1,1,2.],[6,8,1,1,2.]],threshold:-3.5116e-003,right_val:0.47688,left_val:0.74137},{features:[[13,0,3,14,-1.],[14,0,1,14,3.]],threshold:-0.012541,right_val:0.52528,left_val:0.36488},{features:[[4,0,3,14,-1.],[5,0,1,14,3.]],threshold:9.4932e-003,right_val:0.36296,left_val:0.51005},{features:[[13,4,3,14,-1.],[14,4,1,14,3.]],threshold:0.012961,right_val:0.43336,left_val:0.52324},{features:[[9,14,2,3,-1.],[9,15,2,1,3.]],threshold:4.7209e-003,right_val:0.63311,left_val:0.46481},{features:[[8,14,4,3,-1.],[8,15,4,1,3.]],threshold:-2.3119e-003,right_val:0.45311,left_val:0.59303},{features:[[4,2,3,16,-1.],[5,2,1,16,3.]],threshold:-2.8262e-003,right_val:0.52571,left_val:0.38705},{features:[[7,2,8,10,-1.],[7,7,8,5,2.]],threshold:-1.4311e-003,right_val:0.45619,left_val:0.55225},{features:[[6,14,7,3,-1.],[6,15,7,1,3.]],threshold:1.9378e-003,right_val:0.5737,left_val:0.45462},{features:[[9,2,10,12,-1.],[14,2,5,6,2.],[9,8,5,6,2.]],threshold:2.6344e-004,right_val:0.45719,left_val:0.53457},{features:[[6,7,8,2,-1.],[6,8,8,1,2.]],threshold:7.8258e-004,right_val:0.52202,left_val:0.39678},{features:[[8,13,4,6,-1.],[8,16,4,3,2.]],threshold:-0.01955,right_val:0.52435,left_val:0.28296},{features:[[6,6,1,3,-1.],[6,7,1,1,3.]],threshold:4.3915e-004,right_val:0.58991,left_val:0.45901},{features:[[16,2,4,6,-1.],[16,4,4,2,3.]],threshold:0.021452,right_val:0.28554,left_val:0.52314},{features:[[6,6,4,2,-1.],[6,6,2,1,2.],[8,7,2,1,2.]],threshold:5.8974e-004,right_val:0.55064,left_val:0.43973},{features:[[16,2,4,6,-1.],[16,4,4,2,3.]],threshold:-0.026158,right_val:0.51892,left_val:0.31351},{features:[[0,2,4,6,-1.],[0,4,4,2,3.]],threshold:-0.01396,right_val:0.50407,left_val:0.32133},{features:[[9,6,2,6,-1.],[9,6,1,6,2.]],threshold:-6.3699e-003,right_val:0.48495,left_val:0.63875},{features:[[3,4,6,10,-1.],[3,9,6,5,2.]],threshold:-8.5614e-003,right_val:0.5032,left_val:0.27591},{features:[[9,5,2,6,-1.],[9,5,1,6,2.]],threshold:9.6623e-004,right_val:0.58349,left_val:0.46856},{features:[[3,13,2,3,-1.],[3,14,2,1,3.]],threshold:7.655e-004,right_val:0.38964,left_val:0.51752},{features:[[13,13,3,2,-1.],[13,14,3,1,2.]],threshold:-8.1833e-003,right_val:0.52081,left_val:0.20691},{features:[[2,16,10,4,-1.],[2,16,5,2,2.],[7,18,5,2,2.]],threshold:-9.3977e-003,right_val:0.46412,left_val:0.61341},{features:[[5,6,10,6,-1.],[10,6,5,3,2.],[5,9,5,3,2.]],threshold:4.8029e-003,right_val:0.43952,left_val:0.54541},{features:[[7,14,1,3,-1.],[7,15,1,1,3.]],threshold:-3.5681e-003,right_val:0.46811,left_val:0.63445},{features:[[14,16,6,3,-1.],[14,17,6,1,3.]],threshold:4.0733e-003,right_val:0.40156,left_val:0.52927},{features:[[5,4,3,3,-1.],[5,5,3,1,3.]],threshold:1.2568e-003,right_val:0.54528,left_val:0.4393},{features:[[7,4,10,3,-1.],[7,5,10,1,3.]],threshold:-2.9065e-003,right_val:0.48634,left_val:0.58988},{features:[[0,4,5,4,-1.],[0,6,5,2,2.]],threshold:-2.4409e-003,right_val:0.52474,left_val:0.40694},{features:[[13,11,3,9,-1.],[13,14,3,3,3.]],threshold:0.024831,right_val:0.36825,left_val:0.51827},{features:[[4,11,3,9,-1.],[4,14,3,3,3.]],threshold:-0.048854,right_val:0.49613,left_val:0.13076},{features:[[9,7,2,1,-1.],[9,7,1,1,2.]],threshold:-1.611e-003,right_val:0.48727,left_val:0.6421},{features:[[5,0,6,17,-1.],[7,0,2,17,3.]],threshold:-0.097009,right_val:0.4951,left_val:0.047769},{features:[[10,3,6,3,-1.],[10,3,3,3,2.]],threshold:1.1209e-003,right_val:0.53547,left_val:0.46163},{features:[[2,2,15,4,-1.],[7,2,5,4,3.]],threshold:-1.3064e-003,right_val:0.46388,left_val:0.62619},{features:[[8,2,8,2,-1.],[12,2,4,1,2.],[8,3,4,1,2.]],threshold:4.5772e-004,right_val:0.46466,left_val:0.53844},{features:[[8,1,3,6,-1.],[8,3,3,2,3.]],threshold:-6.315e-004,right_val:0.51303,left_val:0.3804},{features:[[9,17,2,2,-1.],[9,18,2,1,2.]],threshold:1.4506e-004,right_val:0.56645,left_val:0.45543},{features:[[0,0,2,14,-1.],[1,0,1,14,2.]],threshold:-0.016475,right_val:0.47159,left_val:0.6597},{features:[[12,0,7,3,-1.],[12,1,7,1,3.]],threshold:0.01337,right_val:0.3036,left_val:0.51955},{features:[[1,14,1,2,-1.],[1,15,1,1,2.]],threshold:1.0272e-004,right_val:0.41071,left_val:0.52292},{features:[[14,12,2,8,-1.],[15,12,1,4,2.],[14,16,1,4,2.]],threshold:-5.5312e-003,right_val:0.49609,left_val:0.63529},{features:[[1,0,7,3,-1.],[1,1,7,1,3.]],threshold:-2.6187e-003,right_val:0.5141,left_val:0.38245},{features:[[14,12,2,8,-1.],[15,12,1,4,2.],[14,16,1,4,2.]],threshold:5.0834e-003,right_val:0.62208,left_val:0.49504},{features:[[6,0,8,12,-1.],[6,0,4,6,2.],[10,6,4,6,2.]],threshold:0.079818,right_val:0.13225,left_val:0.49523},{features:[[6,1,8,9,-1.],[6,4,8,3,3.]],threshold:-0.099227,right_val:0.50084,left_val:0.75427},{features:[[5,2,2,2,-1.],[5,3,2,1,2.]],threshold:-6.5174e-004,right_val:0.51301,left_val:0.36993},{features:[[13,14,6,6,-1.],[16,14,3,3,2.],[13,17,3,3,2.]],threshold:-0.018997,right_val:0.49212,left_val:0.66892},{features:[[0,17,20,2,-1.],[0,17,10,1,2.],[10,18,10,1,2.]],threshold:0.017347,right_val:0.18592,left_val:0.49833},{features:[[10,3,2,6,-1.],[11,3,1,3,2.],[10,6,1,3,2.]],threshold:5.5082e-004,right_val:0.55221,left_val:0.45744},{features:[[5,12,6,2,-1.],[8,12,3,2,2.]],threshold:2.0056e-003,right_val:0.38565,left_val:0.51317},{features:[[10,7,6,13,-1.],[10,7,3,13,2.]],threshold:-7.7688e-003,right_val:0.54343,left_val:0.43617},{features:[[5,15,10,5,-1.],[10,15,5,5,2.]],threshold:0.050878,right_val:0.68406,left_val:0.46827},{features:[[10,4,4,10,-1.],[10,4,2,10,2.]],threshold:-2.2902e-003,right_val:0.53061,left_val:0.43292},{features:[[5,7,2,1,-1.],[6,7,1,1,2.]],threshold:-1.5715e-004,right_val:0.43782,left_val:0.53701},{features:[[10,3,6,7,-1.],[10,3,3,7,2.]],threshold:0.10519,right_val:0.067361,left_val:0.51373},{features:[[4,3,6,7,-1.],[7,3,3,7,2.]],threshold:2.7199e-003,right_val:0.52557,left_val:0.41121},{features:[[1,7,18,5,-1.],[7,7,6,5,3.]],threshold:0.048338,right_val:0.4439,left_val:0.54046},{features:[[3,17,4,3,-1.],[5,17,2,3,2.]],threshold:9.5704e-004,right_val:0.53995,left_val:0.4356},{features:[[8,14,12,6,-1.],[14,14,6,3,2.],[8,17,6,3,2.]],threshold:-0.025371,right_val:0.5031,left_val:0.59952},{features:[[0,13,20,4,-1.],[0,13,10,2,2.],[10,15,10,2,2.]],threshold:0.052458,right_val:0.13984,left_val:0.49503},{features:[[4,5,14,2,-1.],[11,5,7,1,2.],[4,6,7,1,2.]],threshold:-0.012366,right_val:0.49641,left_val:0.63973},{features:[[1,2,10,12,-1.],[1,2,5,6,2.],[6,8,5,6,2.]],threshold:-0.1459,right_val:0.49463,left_val:0.10017},{features:[[6,1,14,3,-1.],[6,2,14,1,3.]],threshold:-0.015909,right_val:0.52083,left_val:0.33123},{features:[[8,16,2,3,-1.],[8,17,2,1,3.]],threshold:3.9486e-004,right_val:0.54261,left_val:0.44064},{features:[[9,17,3,2,-1.],[10,17,1,2,3.]],threshold:-5.2454e-003,right_val:0.519,left_val:0.27996},{features:[[5,15,4,2,-1.],[5,15,2,1,2.],[7,16,2,1,2.]],threshold:-5.0422e-003,right_val:0.47521,left_val:0.69876},{features:[[10,15,1,3,-1.],[10,16,1,1,3.]],threshold:2.9812e-003,right_val:0.63075,left_val:0.49833},{features:[[8,16,4,4,-1.],[8,16,2,2,2.],[10,18,2,2,2.]],threshold:-7.2884e-003,right_val:0.50269,left_val:0.29823},{features:[[6,11,8,6,-1.],[6,14,8,3,2.]],threshold:1.5094e-003,right_val:0.3833,left_val:0.53084},{features:[[2,13,5,2,-1.],[2,14,5,1,2.]],threshold:-9.3341e-003,right_val:0.49698,left_val:0.2038},{features:[[13,14,6,6,-1.],[16,14,3,3,2.],[13,17,3,3,2.]],threshold:0.028667,right_val:0.6928,left_val:0.50257},{features:[[1,9,18,4,-1.],[7,9,6,4,3.]],threshold:0.1702,right_val:0.14764,left_val:0.49601},{features:[[13,14,6,6,-1.],[16,14,3,3,2.],[13,17,3,3,2.]],threshold:-3.2614e-003,right_val:0.48261,left_val:0.56031},{features:[[0,2,1,6,-1.],[0,4,1,2,3.]],threshold:5.5769e-004,right_val:0.41296,left_val:0.52056},{features:[[5,0,15,20,-1.],[5,10,15,10,2.]],threshold:0.36258,right_val:0.37686,left_val:0.52217},{features:[[1,14,6,6,-1.],[1,14,3,3,2.],[4,17,3,3,2.]],threshold:-0.011615,right_val:0.46375,left_val:0.60227},{features:[[8,14,4,6,-1.],[10,14,2,3,2.],[8,17,2,3,2.]],threshold:-4.0795e-003,right_val:0.53375,left_val:0.40704},{features:[[7,11,2,1,-1.],[8,11,1,1,2.]],threshold:5.7204e-004,right_val:0.59004,left_val:0.46018},{features:[[9,17,3,2,-1.],[10,17,1,2,3.]],threshold:6.7543e-004,right_val:0.43454,left_val:0.53983},{features:[[8,17,3,2,-1.],[9,17,1,2,3.]],threshold:6.3296e-004,right_val:0.40514,left_val:0.52016},{features:[[12,14,4,6,-1.],[14,14,2,3,2.],[12,17,2,3,2.]],threshold:1.2435e-003,right_val:0.55474,left_val:0.46424},{features:[[4,14,4,6,-1.],[4,14,2,3,2.],[6,17,2,3,2.]],threshold:-4.7364e-003,right_val:0.46726,left_val:0.61986},{features:[[13,14,2,6,-1.],[14,14,1,3,2.],[13,17,1,3,2.]],threshold:-6.4658e-003,right_val:0.5019,left_val:0.68373},{features:[[5,14,2,6,-1.],[5,14,1,3,2.],[6,17,1,3,2.]],threshold:3.5017e-004,right_val:0.53636,left_val:0.43448},{features:[[7,0,6,12,-1.],[7,4,6,4,3.]],threshold:1.5755e-004,right_val:0.5732,left_val:0.47601},{features:[[0,7,12,2,-1.],[4,7,4,2,3.]],threshold:9.9774e-003,right_val:0.3635,left_val:0.5091},{features:[[10,3,3,13,-1.],[11,3,1,13,3.]],threshold:-4.1465e-004,right_val:0.45938,left_val:0.55701},{features:[[7,3,3,13,-1.],[8,3,1,13,3.]],threshold:-3.5889e-004,right_val:0.43391,left_val:0.53568},{features:[[10,8,6,3,-1.],[10,9,6,1,3.]],threshold:4.0463e-004,right_val:0.54368,left_val:0.44398},{features:[[3,11,3,2,-1.],[4,11,1,2,3.]],threshold:-8.2185e-004,right_val:0.51763,left_val:0.40423},{features:[[13,12,6,8,-1.],[16,12,3,4,2.],[13,16,3,4,2.]],threshold:5.9467e-003,right_val:0.56338,left_val:0.49277},{features:[[7,6,6,5,-1.],[9,6,2,5,3.]],threshold:-0.021753,right_val:0.48008,left_val:0.80063},{features:[[17,11,2,7,-1.],[17,11,1,7,2.]],threshold:-0.01454,right_val:0.51822,left_val:0.39461},{features:[[3,13,8,2,-1.],[7,13,4,2,2.]],threshold:-0.040511,right_val:0.49358,left_val:0.021325},{features:[[6,9,8,3,-1.],[6,10,8,1,3.]],threshold:-5.8458e-004,right_val:0.5314,left_val:0.40128},{features:[[4,3,4,3,-1.],[4,4,4,1,3.]],threshold:5.5152e-003,right_val:0.58963,left_val:0.46424},{features:[[11,3,4,3,-1.],[11,4,4,1,3.]],threshold:-6.0626e-003,right_val:0.50165,left_val:0.65022},{features:[[1,4,17,12,-1.],[1,8,17,4,3.]],threshold:0.094536,right_val:0.41268,left_val:0.52647},{features:[[11,3,4,3,-1.],[11,4,4,1,3.]],threshold:4.7315e-003,right_val:0.58924,left_val:0.48792},{features:[[4,8,6,3,-1.],[4,9,6,1,3.]],threshold:-5.2571e-004,right_val:0.51894,left_val:0.39173},{features:[[12,3,5,3,-1.],[12,4,5,1,3.]],threshold:-2.5464e-003,right_val:0.49857,left_val:0.58376},{features:[[1,11,2,7,-1.],[2,11,1,7,2.]],threshold:-0.026076,right_val:0.49558,left_val:0.1262},{features:[[15,12,2,8,-1.],[16,12,1,4,2.],[15,16,1,4,2.]],threshold:-5.478e-003,right_val:0.50103,left_val:0.57225},{features:[[4,8,11,3,-1.],[4,9,11,1,3.]],threshold:5.1338e-003,right_val:0.42264,left_val:0.52733},{features:[[9,13,6,2,-1.],[12,13,3,1,2.],[9,14,3,1,2.]],threshold:4.7945e-004,right_val:0.58196,left_val:0.44501},{features:[[6,13,4,3,-1.],[6,14,4,1,3.]],threshold:-2.1114e-003,right_val:0.45117,left_val:0.57577},{features:[[9,12,3,3,-1.],[10,12,1,3,3.]],threshold:-0.01318,right_val:0.51607,left_val:0.18844},{features:[[5,3,3,3,-1.],[5,4,3,1,3.]],threshold:-4.7968e-003,right_val:0.47361,left_val:0.65898},{features:[[9,4,2,3,-1.],[9,5,2,1,3.]],threshold:6.7483e-003,right_val:0.33564,left_val:0.52594},{features:[[0,2,16,3,-1.],[0,3,16,1,3.]],threshold:1.4623e-003,right_val:0.42641,left_val:0.53553},{features:[[15,12,2,8,-1.],[16,12,1,4,2.],[15,16,1,4,2.]],threshold:4.7645e-003,right_val:0.57868,left_val:0.50344},{features:[[3,12,2,8,-1.],[3,12,1,4,2.],[4,16,1,4,2.]],threshold:6.8067e-003,right_val:0.66778,left_val:0.47566},{features:[[14,13,3,6,-1.],[14,15,3,2,3.]],threshold:3.6609e-003,right_val:0.43115,left_val:0.53696},{features:[[3,13,3,6,-1.],[3,15,3,2,3.]],threshold:0.02145,right_val:0.18888,left_val:0.49686},{features:[[6,5,10,2,-1.],[11,5,5,1,2.],[6,6,5,1,2.]],threshold:4.1679e-003,right_val:0.58154,left_val:0.49307},{features:[[2,14,14,6,-1.],[2,17,14,3,2.]],threshold:8.6468e-003,right_val:0.41326,left_val:0.52052},{features:[[10,14,1,3,-1.],[10,15,1,1,3.]],threshold:-3.6114e-004,right_val:0.48009,left_val:0.54836},{features:[[4,16,2,2,-1.],[4,16,1,1,2.],[5,17,1,1,2.]],threshold:1.0809e-003,right_val:0.60414,left_val:0.46899},{features:[[10,6,2,3,-1.],[10,7,2,1,3.]],threshold:5.772e-003,right_val:0.30533,left_val:0.51711},{features:[[0,17,20,2,-1.],[0,17,10,1,2.],[10,18,10,1,2.]],threshold:1.5721e-003,right_val:0.41788,left_val:0.522},{features:[[13,6,1,3,-1.],[13,7,1,1,3.]],threshold:-1.9308e-003,right_val:0.48129,left_val:0.58604},{features:[[8,13,3,2,-1.],[9,13,1,2,3.]],threshold:-7.8926e-003,right_val:0.49717,left_val:0.17493},{features:[[12,2,3,3,-1.],[13,2,1,3,3.]],threshold:-2.2225e-003,right_val:0.52128,left_val:0.43426},{features:[[3,18,2,2,-1.],[3,18,1,1,2.],[4,19,1,1,2.]],threshold:1.9012e-003,right_val:0.68921,left_val:0.47652},{features:[[9,16,3,4,-1.],[10,16,1,4,3.]],threshold:2.7576e-003,right_val:0.43375,left_val:0.52622},{features:[[6,6,1,3,-1.],[6,7,1,1,3.]],threshold:5.1787e-003,right_val:0.78437,left_val:0.48041},{features:[[13,1,5,2,-1.],[13,2,5,1,2.]],threshold:-9.0273e-004,right_val:0.53534,left_val:0.41208},{features:[[7,14,6,2,-1.],[7,14,3,1,2.],[10,15,3,1,2.]],threshold:5.1798e-003,right_val:0.6426,left_val:0.47404},{features:[[11,3,3,4,-1.],[12,3,1,4,3.]],threshold:-0.010114,right_val:0.5175,left_val:0.24688},{features:[[1,13,12,6,-1.],[5,13,4,6,3.]],threshold:-0.018617,right_val:0.4629,left_val:0.57563},{features:[[14,11,5,2,-1.],[14,12,5,1,2.]],threshold:5.9226e-003,right_val:0.32143,left_val:0.51696},{features:[[2,15,14,4,-1.],[2,15,7,2,2.],[9,17,7,2,2.]],threshold:-6.2945e-003,right_val:0.51416,left_val:0.3872},{features:[[3,7,14,2,-1.],[10,7,7,1,2.],[3,8,7,1,2.]],threshold:6.5353e-003,right_val:0.63105,left_val:0.4853},{features:[[1,11,4,2,-1.],[1,12,4,1,2.]],threshold:1.0878e-003,right_val:0.37233,left_val:0.51173},{features:[[14,0,6,14,-1.],[16,0,2,14,3.]],threshold:-0.022542,right_val:0.48871,left_val:0.56927},{features:[[4,11,1,3,-1.],[4,12,1,1,3.]],threshold:-3.0066e-003,right_val:0.5004,left_val:0.2556},{features:[[14,0,6,14,-1.],[16,0,2,14,3.]],threshold:7.4741e-003,right_val:0.56759,left_val:0.48109},{features:[[1,10,3,7,-1.],[2,10,1,7,3.]],threshold:0.026162,right_val:0.17772,left_val:0.49712},{features:[[8,12,9,2,-1.],[8,13,9,1,2.]],threshold:9.4353e-004,right_val:0.54913,left_val:0.494},{features:[[0,6,20,1,-1.],[10,6,10,1,2.]],threshold:0.033363,right_val:0.27907,left_val:0.50076},{features:[[8,4,4,4,-1.],[8,4,2,4,2.]],threshold:-0.015119,right_val:0.4973,left_val:0.70596},{features:[[0,0,2,2,-1.],[0,1,2,1,2.]],threshold:9.8649e-004,right_val:0.37768,left_val:0.51286}],threshold:104.75},{simpleClassifiers:[{features:[[5,3,10,9,-1.],[5,6,10,3,3.]],threshold:-0.095151,right_val:0.40173,left_val:0.64708},{features:[[15,2,4,10,-1.],[15,2,2,10,2.]],threshold:6.2702e-003,right_val:0.57464,left_val:0.39998},{features:[[8,2,2,7,-1.],[9,2,1,7,2.]],threshold:3.0018e-004,right_val:0.55388,left_val:0.35588},{features:[[7,4,12,1,-1.],[11,4,4,1,3.]],threshold:1.1757e-003,right_val:0.53826,left_val:0.42565},{features:[[3,4,9,1,-1.],[6,4,3,1,3.]],threshold:4.4235e-005,right_val:0.55899,left_val:0.36829},{features:[[15,10,1,4,-1.],[15,12,1,2,2.]],threshold:-2.9937e-005,right_val:0.40204,left_val:0.54525},{features:[[4,10,6,4,-1.],[7,10,3,4,2.]],threshold:3.0073e-003,right_val:0.33178,left_val:0.52391},{features:[[15,9,1,6,-1.],[15,12,1,3,2.]],threshold:-0.010514,right_val:0.5308,left_val:0.43207},{features:[[7,17,6,3,-1.],[7,18,6,1,3.]],threshold:8.3477e-003,right_val:0.64533,left_val:0.45046},{features:[[14,3,2,16,-1.],[15,3,1,8,2.],[14,11,1,8,2.]],threshold:-3.1492e-003,right_val:0.53705,left_val:0.43134},{features:[[4,9,1,6,-1.],[4,12,1,3,2.]],threshold:-1.4436e-005,right_val:0.3818,left_val:0.53266},{features:[[12,1,5,2,-1.],[12,2,5,1,2.]],threshold:-4.2855e-004,right_val:0.5382,left_val:0.43052},{features:[[6,18,4,2,-1.],[6,18,2,1,2.],[8,19,2,1,2.]],threshold:1.5062e-004,right_val:0.5545,left_val:0.4236},{features:[[2,4,16,10,-1.],[10,4,8,5,2.],[2,9,8,5,2.]],threshold:0.07156,right_val:0.26788,left_val:0.53031},{features:[[6,5,1,10,-1.],[6,10,1,5,2.]],threshold:8.4095e-004,right_val:0.52054,left_val:0.35571},{features:[[4,8,15,2,-1.],[9,8,5,2,3.]],threshold:0.062987,right_val:0.28614,left_val:0.52254},{features:[[1,8,15,2,-1.],[6,8,5,2,3.]],threshold:-3.3799e-003,right_val:0.52017,left_val:0.36242},{features:[[9,5,3,6,-1.],[9,7,3,2,3.]],threshold:-1.1811e-004,right_val:0.39599,left_val:0.54745},{features:[[5,7,8,2,-1.],[9,7,4,2,2.]],threshold:-5.4506e-004,right_val:0.52157,left_val:0.37404},{features:[[9,11,2,3,-1.],[9,12,2,1,3.]],threshold:-1.8455e-003,right_val:0.45844,left_val:0.58931},{features:[[1,0,16,3,-1.],[1,1,16,1,3.]],threshold:-4.3832e-004,right_val:0.53854,left_val:0.40846},{features:[[11,2,7,2,-1.],[11,3,7,1,2.]],threshold:-2.4001e-003,right_val:0.52936,left_val:0.37775},{features:[[5,1,10,18,-1.],[5,7,10,6,3.]],threshold:-0.098796,right_val:0.50701,left_val:0.29636},{features:[[17,4,3,2,-1.],[18,4,1,2,3.]],threshold:3.1798e-003,right_val:0.67264,left_val:0.48776},{features:[[8,13,1,3,-1.],[8,14,1,1,3.]],threshold:3.2406e-004,right_val:0.55611,left_val:0.43669},{features:[[3,14,14,6,-1.],[3,16,14,2,3.]],threshold:-0.032547,right_val:0.53086,left_val:0.31282},{features:[[0,2,3,4,-1.],[1,2,1,4,3.]],threshold:-7.7561e-003,right_val:0.46399,left_val:0.65602},{features:[[12,1,5,2,-1.],[12,2,5,1,2.]],threshold:0.016027,right_val:0.31419,left_val:0.51727},{features:[[3,1,5,2,-1.],[3,2,5,1,2.]],threshold:7.1002e-006,right_val:0.53363,left_val:0.40844},{features:[[10,13,2,3,-1.],[10,14,2,1,3.]],threshold:7.3423e-003,right_val:0.66035,left_val:0.49669},{features:[[8,13,2,3,-1.],[8,14,2,1,3.]],threshold:-1.697e-003,right_val:0.45002,left_val:0.59082},{features:[[14,12,2,3,-1.],[14,13,2,1,3.]],threshold:2.4118e-003,right_val:0.35997,left_val:0.53152},{features:[[7,2,2,3,-1.],[7,3,2,1,3.]],threshold:-5.5301e-003,right_val:0.49968,left_val:0.2334},{features:[[5,6,10,4,-1.],[10,6,5,2,2.],[5,8,5,2,2.]],threshold:-2.6479e-003,right_val:0.46847,left_val:0.58809},{features:[[9,13,1,6,-1.],[9,16,1,3,2.]],threshold:0.011296,right_val:0.18846,left_val:0.49838},{features:[[10,12,2,2,-1.],[11,12,1,1,2.],[10,13,1,1,2.]],threshold:-6.6953e-004,right_val:0.4799,left_val:0.58721},{features:[[4,12,2,3,-1.],[4,13,2,1,3.]],threshold:1.4411e-003,right_val:0.3501,left_val:0.51312},{features:[[14,4,6,6,-1.],[14,6,6,2,3.]],threshold:2.4638e-003,right_val:0.41176,left_val:0.53394},{features:[[8,17,2,3,-1.],[8,18,2,1,3.]],threshold:3.3115e-004,right_val:0.53982,left_val:0.43134},{features:[[16,4,4,6,-1.],[16,6,4,2,3.]],threshold:-0.033557,right_val:0.51792,left_val:0.26753},{features:[[0,4,4,6,-1.],[0,6,4,2,3.]],threshold:0.018539,right_val:0.23172,left_val:0.49739},{features:[[14,6,2,3,-1.],[14,6,1,3,2.]],threshold:-2.9698e-004,right_val:0.46437,left_val:0.55297},{features:[[4,9,8,1,-1.],[8,9,4,1,2.]],threshold:-4.5577e-004,right_val:0.44692,left_val:0.56296},{features:[[8,12,4,3,-1.],[8,13,4,1,3.]],threshold:-0.010159,right_val:0.49259,left_val:0.67062},{features:[[5,12,10,6,-1.],[5,14,10,2,3.]],threshold:-2.2414e-005,right_val:0.39129,left_val:0.52394},{features:[[11,12,1,2,-1.],[11,13,1,1,2.]],threshold:7.2035e-005,right_val:0.55018,left_val:0.47994},{features:[[8,15,4,2,-1.],[8,16,4,1,2.]],threshold:-6.9267e-003,right_val:0.46981,left_val:0.693},{features:[[6,9,8,8,-1.],[10,9,4,4,2.],[6,13,4,4,2.]],threshold:-7.6998e-003,right_val:0.54809,left_val:0.40996},{features:[[7,12,4,6,-1.],[7,12,2,3,2.],[9,15,2,3,2.]],threshold:-7.3131e-003,right_val:0.50579,left_val:0.32835},{features:[[10,11,3,1,-1.],[11,11,1,1,3.]],threshold:1.9651e-003,right_val:0.63982,left_val:0.4978},{features:[[9,7,2,10,-1.],[9,7,1,5,2.],[10,12,1,5,2.]],threshold:7.1648e-003,right_val:0.62221,left_val:0.46612},{features:[[8,0,6,6,-1.],[10,0,2,6,3.]],threshold:-0.024079,right_val:0.52222,left_val:0.23346},{features:[[3,11,2,6,-1.],[3,13,2,2,3.]],threshold:-0.021028,right_val:0.49382,left_val:0.11837},{features:[[16,12,1,2,-1.],[16,13,1,1,2.]],threshold:3.6017e-004,right_val:0.41167,left_val:0.5325},{features:[[1,14,6,6,-1.],[1,14,3,3,2.],[4,17,3,3,2.]],threshold:-0.01722,right_val:0.46643,left_val:0.62788},{features:[[13,1,3,6,-1.],[14,1,1,6,3.]],threshold:-7.8672e-003,right_val:0.52497,left_val:0.34034},{features:[[8,8,2,2,-1.],[8,9,2,1,2.]],threshold:-4.4777e-004,right_val:0.50863,left_val:0.36104},{features:[[9,9,3,3,-1.],[10,9,1,3,3.]],threshold:5.5486e-003,right_val:0.62035,left_val:0.48843},{features:[[8,7,3,3,-1.],[8,8,3,1,3.]],threshold:-6.9461e-003,right_val:0.50111,left_val:0.26259},{features:[[14,0,2,3,-1.],[14,0,1,3,2.]],threshold:1.357e-004,right_val:0.56283,left_val:0.43408},{features:[[1,0,18,9,-1.],[7,0,6,9,3.]],threshold:-0.04588,right_val:0.46963,left_val:0.6508},{features:[[11,5,4,15,-1.],[11,5,2,15,2.]],threshold:-0.021583,right_val:0.52876,left_val:0.38265},{features:[[5,5,4,15,-1.],[7,5,2,15,2.]],threshold:-0.02021,right_val:0.50745,left_val:0.32334},{features:[[14,0,2,3,-1.],[14,0,1,3,2.]],threshold:5.8497e-003,right_val:0.44897,left_val:0.51776},{features:[[4,0,2,3,-1.],[5,0,1,3,2.]],threshold:-5.7476e-005,right_val:0.52464,left_val:0.40209},{features:[[11,12,2,2,-1.],[12,12,1,1,2.],[11,13,1,1,2.]],threshold:-1.1513e-003,right_val:0.49052,left_val:0.63151},{features:[[7,12,2,2,-1.],[7,12,1,1,2.],[8,13,1,1,2.]],threshold:1.9863e-003,right_val:0.64972,left_val:0.47025},{features:[[12,0,3,4,-1.],[13,0,1,4,3.]],threshold:-5.272e-003,right_val:0.52277,left_val:0.36504},{features:[[4,11,3,3,-1.],[4,12,3,1,3.]],threshold:1.2663e-003,right_val:0.38776,left_val:0.51661},{features:[[12,7,4,2,-1.],[12,8,4,1,2.]],threshold:-6.2919e-003,right_val:0.50238,left_val:0.73759},{features:[[8,10,3,2,-1.],[9,10,1,2,3.]],threshold:6.736e-004,right_val:0.54956,left_val:0.44232},{features:[[9,9,3,2,-1.],[10,9,1,2,3.]],threshold:-1.0523e-003,right_val:0.48596,left_val:0.59764},{features:[[8,9,3,2,-1.],[9,9,1,2,3.]],threshold:-4.4216e-004,right_val:0.43989,left_val:0.59559},{features:[[12,0,3,4,-1.],[13,0,1,4,3.]],threshold:1.1748e-003,right_val:0.46051,left_val:0.53499},{features:[[5,0,3,4,-1.],[6,0,1,4,3.]],threshold:5.2457e-003,right_val:0.29416,left_val:0.50492},{features:[[4,14,12,4,-1.],[10,14,6,2,2.],[4,16,6,2,2.]],threshold:-0.02454,right_val:0.52186,left_val:0.25502},{features:[[8,13,2,3,-1.],[8,14,2,1,3.]],threshold:7.3793e-004,right_val:0.54908,left_val:0.44249},{features:[[10,10,3,8,-1.],[10,14,3,4,2.]],threshold:1.4234e-003,right_val:0.40814,left_val:0.53195},{features:[[8,10,4,8,-1.],[8,10,2,4,2.],[10,14,2,4,2.]],threshold:-2.4149e-003,right_val:0.5239,left_val:0.40877},{features:[[10,8,3,1,-1.],[11,8,1,1,3.]],threshold:-1.2165e-003,right_val:0.49081,left_val:0.56746},{features:[[9,12,1,6,-1.],[9,15,1,3,2.]],threshold:-1.2439e-003,right_val:0.52561,left_val:0.41294},{features:[[10,8,3,1,-1.],[11,8,1,1,3.]],threshold:6.1943e-003,right_val:0.73137,left_val:0.50602},{features:[[7,8,3,1,-1.],[8,8,1,1,3.]],threshold:-1.6607e-003,right_val:0.45964,left_val:0.59796},{features:[[5,2,15,14,-1.],[5,9,15,7,2.]],threshold:-0.027316,right_val:0.53088,left_val:0.41744},{features:[[2,1,2,10,-1.],[2,1,1,5,2.],[3,6,1,5,2.]],threshold:-1.5846e-003,right_val:0.45195,left_val:0.56158},{features:[[14,14,2,3,-1.],[14,15,2,1,3.]],threshold:-1.5515e-003,right_val:0.53608,left_val:0.40762},{features:[[2,7,3,3,-1.],[3,7,1,3,3.]],threshold:3.8447e-004,right_val:0.54304,left_val:0.43473},{features:[[17,4,3,3,-1.],[17,5,3,1,3.]],threshold:-0.014672,right_val:0.51461,left_val:0.16593},{features:[[0,4,3,3,-1.],[0,5,3,1,3.]],threshold:8.1609e-003,right_val:0.18847,left_val:0.49618},{features:[[13,5,6,2,-1.],[16,5,3,1,2.],[13,6,3,1,2.]],threshold:1.1122e-003,right_val:0.60938,left_val:0.48683},{features:[[4,19,12,1,-1.],[8,19,4,1,3.]],threshold:-7.2604e-003,right_val:0.46904,left_val:0.62843},{features:[[12,12,2,4,-1.],[12,14,2,2,2.]],threshold:-2.4046e-004,right_val:0.4046,left_val:0.5575},{features:[[3,15,1,3,-1.],[3,16,1,1,3.]],threshold:-2.3348e-004,right_val:0.52528,left_val:0.41158},{features:[[11,16,6,4,-1.],[11,16,3,4,2.]],threshold:5.5736e-003,right_val:0.56901,left_val:0.47301},{features:[[2,10,3,10,-1.],[3,10,1,10,3.]],threshold:0.030624,right_val:0.17401,left_val:0.49719},{features:[[12,8,2,4,-1.],[12,8,1,4,2.]],threshold:9.2075e-004,right_val:0.43549,left_val:0.53721},{features:[[6,8,2,4,-1.],[7,8,1,4,2.]],threshold:-4.3551e-005,right_val:0.43473,left_val:0.53669},{features:[[10,14,2,3,-1.],[10,14,1,3,2.]],threshold:-6.6453e-003,right_val:0.51605,left_val:0.34355},{features:[[5,1,10,3,-1.],[10,1,5,3,2.]],threshold:0.043222,right_val:0.72937,left_val:0.47668},{features:[[10,7,3,2,-1.],[11,7,1,2,3.]],threshold:2.2332e-003,right_val:0.56332,left_val:0.50293},{features:[[5,6,9,2,-1.],[8,6,3,2,3.]],threshold:3.183e-003,right_val:0.51921,left_val:0.40161},{features:[[9,8,2,2,-1.],[9,9,2,1,2.]],threshold:-1.8028e-004,right_val:0.54179,left_val:0.40883},{features:[[2,11,16,6,-1.],[2,11,8,3,2.],[10,14,8,3,2.]],threshold:-5.2935e-003,right_val:0.52436,left_val:0.40757},{features:[[12,7,2,2,-1.],[13,7,1,1,2.],[12,8,1,1,2.]],threshold:1.2751e-003,right_val:0.6387,left_val:0.49133},{features:[[9,5,2,3,-1.],[9,6,2,1,3.]],threshold:4.3385e-003,right_val:0.29473,left_val:0.50317},{features:[[9,7,3,2,-1.],[10,7,1,2,3.]],threshold:8.5251e-003,right_val:0.63089,left_val:0.49498},{features:[[5,1,8,12,-1.],[5,7,8,6,2.]],threshold:-9.4266e-004,right_val:0.42856,left_val:0.53284},{features:[[13,5,2,2,-1.],[13,6,2,1,2.]],threshold:1.361e-003,right_val:0.59415,left_val:0.49915},{features:[[5,5,2,2,-1.],[5,6,2,1,2.]],threshold:4.4783e-004,right_val:0.58545,left_val:0.45735},{features:[[12,4,3,3,-1.],[12,5,3,1,3.]],threshold:1.336e-003,right_val:0.58491,left_val:0.46044},{features:[[4,14,2,3,-1.],[4,15,2,1,3.]],threshold:-6.0968e-004,right_val:0.52294,left_val:0.39694},{features:[[12,4,3,3,-1.],[12,5,3,1,3.]],threshold:-2.3657e-003,right_val:0.48984,left_val:0.58083},{features:[[5,4,3,3,-1.],[5,5,3,1,3.]],threshold:1.0734e-003,right_val:0.547,left_val:0.43512},{features:[[9,14,2,6,-1.],[10,14,1,3,2.],[9,17,1,3,2.]],threshold:2.1923e-003,right_val:0.38429,left_val:0.53551},{features:[[8,14,3,2,-1.],[9,14,1,2,3.]],threshold:5.4969e-003,right_val:0.28272,left_val:0.50181},{features:[[9,5,6,6,-1.],[11,5,2,6,3.]],threshold:-0.075369,right_val:0.51488,left_val:0.12251},{features:[[5,5,6,6,-1.],[7,5,2,6,3.]],threshold:0.025134,right_val:0.70254,left_val:0.47318},{features:[[13,13,1,2,-1.],[13,14,1,1,2.]],threshold:-2.9359e-005,right_val:0.46561,left_val:0.54305},{features:[[0,2,10,2,-1.],[0,3,10,1,2.]],threshold:-5.8356e-004,right_val:0.51901,left_val:0.4031},{features:[[13,13,1,2,-1.],[13,14,1,1,2.]],threshold:-2.6639e-003,right_val:0.51618,left_val:0.43081},{features:[[5,7,2,2,-1.],[5,7,1,1,2.],[6,8,1,1,2.]],threshold:-1.3804e-003,right_val:0.46955,left_val:0.62198},{features:[[13,5,2,7,-1.],[13,5,1,7,2.]],threshold:1.2313e-003,right_val:0.44258,left_val:0.53794},{features:[[6,13,1,2,-1.],[6,14,1,1,2.]],threshold:-1.4644e-005,right_val:0.42225,left_val:0.52816},{features:[[11,0,3,7,-1.],[12,0,1,7,3.]],threshold:-0.012819,right_val:0.51799,left_val:0.25821},{features:[[0,3,2,16,-1.],[0,3,1,8,2.],[1,11,1,8,2.]],threshold:0.022852,right_val:0.76093,left_val:0.47787},{features:[[11,0,3,7,-1.],[12,0,1,7,3.]],threshold:8.2306e-004,right_val:0.46717,left_val:0.5341},{features:[[6,0,3,7,-1.],[7,0,1,7,3.]],threshold:0.01277,right_val:0.14724,left_val:0.49658},{features:[[11,16,8,4,-1.],[11,16,4,4,2.]],threshold:-0.050052,right_val:0.50166,left_val:0.6415},{features:[[1,16,8,4,-1.],[5,16,4,4,2.]],threshold:0.015775,right_val:0.56854,left_val:0.45223},{features:[[13,5,2,7,-1.],[13,5,1,7,2.]],threshold:-0.018502,right_val:0.5138,left_val:0.27647},{features:[[5,5,2,7,-1.],[6,5,1,7,2.]],threshold:2.4626e-003,right_val:0.37954,left_val:0.51419},{features:[[18,6,2,14,-1.],[18,13,2,7,2.]],threshold:0.062916,right_val:0.65804,left_val:0.50606},{features:[[6,10,3,4,-1.],[6,12,3,2,2.]],threshold:-2.1649e-005,right_val:0.40199,left_val:0.51954},{features:[[14,7,1,2,-1.],[14,8,1,1,2.]],threshold:2.1181e-003,right_val:0.59545,left_val:0.49624},{features:[[0,1,18,6,-1.],[0,1,9,3,2.],[9,4,9,3,2.]],threshold:-0.016635,right_val:0.51754,left_val:0.37579},{features:[[14,7,1,2,-1.],[14,8,1,1,2.]],threshold:-2.8899e-003,right_val:0.50572,left_val:0.6624},{features:[[0,6,2,14,-1.],[0,13,2,7,2.]],threshold:0.076783,right_val:0.80477,left_val:0.47958},{features:[[17,0,3,12,-1.],[18,0,1,12,3.]],threshold:3.9171e-003,right_val:0.57199,left_val:0.49379},{features:[[0,6,18,3,-1.],[0,7,18,1,3.]],threshold:-0.072671,right_val:0.49439,left_val:0.053895},{features:[[6,0,14,16,-1.],[6,8,14,8,2.]],threshold:0.5404,right_val:0.11433,left_val:0.51298},{features:[[0,0,3,12,-1.],[1,0,1,12,3.]],threshold:2.951e-003,right_val:0.56986,left_val:0.45283},{features:[[13,0,3,7,-1.],[14,0,1,7,3.]],threshold:3.4508e-003,right_val:0.42187,left_val:0.53577},{features:[[5,7,1,2,-1.],[5,8,1,1,2.]],threshold:-4.2078e-004,right_val:0.46379,left_val:0.59162},{features:[[14,4,6,6,-1.],[14,6,6,2,3.]],threshold:3.3051e-003,right_val:0.4382,left_val:0.52734},{features:[[5,7,7,2,-1.],[5,8,7,1,2.]],threshold:4.7735e-004,right_val:0.51819,left_val:0.40465},{features:[[8,6,6,9,-1.],[8,9,6,3,3.]],threshold:-0.025929,right_val:0.50894,left_val:0.74522},{features:[[5,4,6,1,-1.],[7,4,2,1,3.]],threshold:-2.973e-003,right_val:0.50588,left_val:0.32954},{features:[[13,0,6,4,-1.],[16,0,3,2,2.],[13,2,3,2,2.]],threshold:5.8508e-003,right_val:0.5793,left_val:0.48571},{features:[[1,2,18,12,-1.],[1,6,18,4,3.]],threshold:-0.045968,right_val:0.53807,left_val:0.43127},{features:[[3,2,17,12,-1.],[3,6,17,4,3.]],threshold:0.15586,right_val:0.16847,left_val:0.51962},{features:[[5,14,7,3,-1.],[5,15,7,1,3.]],threshold:0.015165,right_val:0.6735,left_val:0.47358},{features:[[10,14,1,3,-1.],[10,15,1,1,3.]],threshold:-1.0604e-003,right_val:0.47757,left_val:0.58229},{features:[[3,14,3,3,-1.],[3,15,3,1,3.]],threshold:6.6476e-003,right_val:0.23195,left_val:0.49992},{features:[[14,4,6,6,-1.],[14,6,6,2,3.]],threshold:-0.012231,right_val:0.5263,left_val:0.47509},{features:[[0,4,6,6,-1.],[0,6,6,2,3.]],threshold:5.6529e-003,right_val:0.35618,left_val:0.50698},{features:[[12,5,4,3,-1.],[12,6,4,1,3.]],threshold:1.2978e-003,right_val:0.56191,left_val:0.48757},{features:[[4,5,4,3,-1.],[4,6,4,1,3.]],threshold:0.010782,right_val:0.67823,left_val:0.47508},{features:[[18,0,2,6,-1.],[18,2,2,2,3.]],threshold:2.8655e-003,right_val:0.42907,left_val:0.53055},{features:[[8,1,4,9,-1.],[10,1,2,9,2.]],threshold:2.8663e-003,right_val:0.55394,left_val:0.45185},{features:[[6,6,8,2,-1.],[6,6,4,2,2.]],threshold:-5.1983e-003,right_val:0.54342,left_val:0.41491},{features:[[6,5,4,2,-1.],[6,5,2,1,2.],[8,6,2,1,2.]],threshold:5.374e-003,right_val:0.65077,left_val:0.47179},{features:[[10,5,2,3,-1.],[10,6,2,1,3.]],threshold:-0.014642,right_val:0.51618,left_val:0.21722},{features:[[9,5,1,3,-1.],[9,6,1,1,3.]],threshold:-1.5043e-005,right_val:0.42988,left_val:0.53374},{features:[[9,10,2,2,-1.],[9,11,2,1,2.]],threshold:-1.1876e-004,right_val:0.55824,left_val:0.46046},{features:[[0,8,4,3,-1.],[0,9,4,1,3.]],threshold:0.016996,right_val:0.07388,left_val:0.49459},{features:[[6,0,8,6,-1.],[6,3,8,3,2.]],threshold:-0.035096,right_val:0.49776,left_val:0.70055},{features:[[1,0,6,4,-1.],[1,0,3,2,2.],[4,2,3,2,2.]],threshold:2.4217e-003,right_val:0.54777,left_val:0.44663},{features:[[13,0,3,7,-1.],[14,0,1,7,3.]],threshold:-9.634e-004,right_val:0.53133,left_val:0.47141},{features:[[9,16,2,2,-1.],[9,17,2,1,2.]],threshold:1.6391e-004,right_val:0.53422,left_val:0.43315},{features:[[11,4,6,10,-1.],[11,9,6,5,2.]],threshold:-0.021141,right_val:0.52045,left_val:0.26447},{features:[[0,10,19,2,-1.],[0,11,19,1,2.]],threshold:8.7775e-004,right_val:0.41527,left_val:0.52083},{features:[[9,5,8,9,-1.],[9,8,8,3,3.]],threshold:-0.027944,right_val:0.50188,left_val:0.63441},{features:[[4,0,3,7,-1.],[5,0,1,7,3.]],threshold:6.7297e-003,right_val:0.35009,left_val:0.50504},{features:[[8,6,4,12,-1.],[10,6,2,6,2.],[8,12,2,6,2.]],threshold:0.023281,right_val:0.69687,left_val:0.49663},{features:[[0,2,6,4,-1.],[0,4,6,2,2.]],threshold:-0.011645,right_val:0.50496,left_val:0.33003},{features:[[8,15,4,3,-1.],[8,16,4,1,3.]],threshold:0.015764,right_val:0.73212,left_val:0.49916},{features:[[8,0,3,7,-1.],[9,0,1,7,3.]],threshold:-1.3611e-003,right_val:0.51607,left_val:0.39117},{features:[[9,5,3,4,-1.],[10,5,1,4,3.]],threshold:-8.1522e-004,right_val:0.49497,left_val:0.56289},{features:[[8,5,3,4,-1.],[9,5,1,4,3.]],threshold:-6.0066e-004,right_val:0.45506,left_val:0.58536},{features:[[7,6,6,1,-1.],[9,6,2,1,3.]],threshold:4.9716e-004,right_val:0.54436,left_val:0.42715},{features:[[7,14,4,4,-1.],[7,14,2,2,2.],[9,16,2,2,2.]],threshold:2.3475e-003,right_val:0.38877,left_val:0.51431},{features:[[13,14,4,6,-1.],[15,14,2,3,2.],[13,17,2,3,2.]],threshold:-8.9262e-003,right_val:0.49717,left_val:0.60445},{features:[[7,8,1,8,-1.],[7,12,1,4,2.]],threshold:-0.01392,right_val:0.50004,left_val:0.25832},{features:[[16,0,2,8,-1.],[17,0,1,4,2.],[16,4,1,4,2.]],threshold:1.021e-003,right_val:0.55604,left_val:0.48574},{features:[[2,0,2,8,-1.],[2,0,1,4,2.],[3,4,1,4,2.]],threshold:-2.7442e-003,right_val:0.46458,left_val:0.59369},{features:[[6,1,14,3,-1.],[6,2,14,1,3.]],threshold:-0.0162,right_val:0.51935,left_val:0.3163},{features:[[7,9,3,10,-1.],[7,14,3,5,2.]],threshold:4.3332e-003,right_val:0.34589,left_val:0.50612},{features:[[9,14,2,2,-1.],[9,15,2,1,2.]],threshold:5.8498e-004,right_val:0.58702,left_val:0.4779},{features:[[7,7,6,8,-1.],[7,11,6,4,2.]],threshold:-2.2466e-003,right_val:0.53748,left_val:0.42979},{features:[[9,7,3,6,-1.],[9,10,3,3,2.]],threshold:2.3146e-003,right_val:0.4641,left_val:0.54387},{features:[[7,13,3,3,-1.],[7,14,3,1,3.]],threshold:8.7679e-003,right_val:0.67718,left_val:0.47269},{features:[[9,9,2,2,-1.],[9,10,2,1,2.]],threshold:-2.2448e-004,right_val:0.5428,left_val:0.42292},{features:[[0,1,18,2,-1.],[6,1,6,2,3.]],threshold:-7.4336e-003,right_val:0.46837,left_val:0.60989},{features:[[7,1,6,14,-1.],[7,8,6,7,2.]],threshold:-2.3189e-003,right_val:0.44242,left_val:0.56894},{features:[[1,9,18,1,-1.],[7,9,6,1,3.]],threshold:-2.1042e-003,right_val:0.51871,left_val:0.37622},{features:[[9,7,2,2,-1.],[9,7,1,2,2.]],threshold:4.6035e-004,right_val:0.57712,left_val:0.46994},{features:[[9,3,2,9,-1.],[10,3,1,9,2.]],threshold:1.0548e-003,right_val:0.56017,left_val:0.44652},{features:[[18,14,2,3,-1.],[18,15,2,1,3.]],threshold:8.7149e-004,right_val:0.39147,left_val:0.54498},{features:[[7,11,3,1,-1.],[8,11,1,1,3.]],threshold:3.3365e-004,right_val:0.56457,left_val:0.4564},{features:[[10,8,3,4,-1.],[11,8,1,4,3.]],threshold:-1.4853e-003,right_val:0.46928,left_val:0.57474},{features:[[7,14,3,6,-1.],[8,14,1,6,3.]],threshold:3.0252e-003,right_val:0.37628,left_val:0.51662},{features:[[10,8,3,4,-1.],[11,8,1,4,3.]],threshold:5.0281e-003,right_val:0.61515,left_val:0.50021},{features:[[7,8,3,4,-1.],[8,8,1,4,3.]],threshold:-5.8165e-004,right_val:0.43908,left_val:0.53946},{features:[[7,9,6,9,-1.],[7,12,6,3,3.]],threshold:0.045142,right_val:0.2063,left_val:0.51883},{features:[[0,14,2,3,-1.],[0,15,2,1,3.]],threshold:-1.0796e-003,right_val:0.51379,left_val:0.39047},{features:[[11,12,1,2,-1.],[11,13,1,1,2.]],threshold:1.5996e-004,right_val:0.54275,left_val:0.48953},{features:[[4,3,8,3,-1.],[8,3,4,3,2.]],threshold:-0.019359,right_val:0.47735,left_val:0.69752},{features:[[0,4,20,6,-1.],[0,4,10,6,2.]],threshold:0.20726,right_val:0.3035,left_val:0.52336},{features:[[9,14,1,3,-1.],[9,15,1,1,3.]],threshold:-4.1953e-004,right_val:0.44602,left_val:0.54194},{features:[[8,14,4,3,-1.],[8,15,4,1,3.]],threshold:2.2582e-003,right_val:0.60274,left_val:0.48158},{features:[[0,15,14,4,-1.],[0,17,14,2,2.]],threshold:-6.7811e-003,right_val:0.51833,left_val:0.39803},{features:[[1,14,18,6,-1.],[1,17,18,3,2.]],threshold:0.011154,right_val:0.41888,left_val:0.54312},{features:[[0,0,10,6,-1.],[0,0,5,3,2.],[5,3,5,3,2.]],threshold:0.043162,right_val:0.6523,left_val:0.47382}],threshold:105.76}],size:[20,20],tilted:false};

var faceDetection = function(pdmModel, params) {

	// processes an image, detects a face and returns the initial face parameters for clmtrackr
	//   calls a callback function when it's done
	//   optionally uses web workers

	if (params === undefined) params = {};
	if (params.workSize === undefined) params.workSize = 200;
	if (params.minScale === undefined) params.minScale = 2;
	if (params.scaleFactor === undefined) params.scaleFactor = 1.15;
	if (params.useCanny === undefined) params.useCanny = false;
	if (params.edgesDensity === undefined) params.edgesDensity = 0.13;
	if (params.equalizeHistogram === undefined) params.equalizeHistogram = false;
	if (params.min_neighbors === undefined) params.min_neighbors = 2;
	if (params.confidenceThreshold === undefined) params.confidenceThreshold = 106.1;
	if (params.useWebWorkers === undefined) params.useWebWorkers = true;

	// disable web workers if not exists
	if (!window.Worker) params.useWebWorkers = false;

	var msxmin, msymin, msymax;
	var msmodelheight;
	var element;

	var model = pdmModel;

	var mosseFilter = mosse.mosseFilter;
	var left_eye_filter = mosse.filters.left_eye_filter;
	var right_eye_filter = mosse.filters.right_eye_filter;
	var nose_filter = mosse.filters.nose_filter;

	var mossef_lefteye, mossef_righteye, mossef_nose;
	var right_eye_position = [0.0,0.0];
	var left_eye_position = [0.0,0.0];
	var nose_position = [0.0,0.0];

	if (model.hints && mosseFilter && left_eye_filter && right_eye_filter && nose_filter) {
		mossef_lefteye = new mosseFilter();
		mossef_lefteye.load(left_eye_filter);
		mossef_righteye = new mosseFilter();
		mossef_righteye.load(right_eye_filter);
		mossef_nose = new mosseFilter();
		mossef_nose.load(nose_filter);
	} else {
		console.log('MOSSE filters not found, using rough approximation for initialization.');
	}

	// load mean shape
	var meanShape = model.shapeModel.meanShape;
	var numPatches = model.patchModel.numPatches;

	// get max and mins, width and height of meanshape
	msymax = 0;
	msxmin = msymin = 1000000;
	for (var i = 0;i < numPatches;i++) {
		if (meanShape[i][0] < msxmin) msxmin = meanShape[i][0];
		if (meanShape[i][1] < msymin) msymin = meanShape[i][1];
		if (meanShape[i][1] > msymax) msymax = meanShape[i][1];
	}
	msmodelheight = msymax-msymin;

	var jf = new jsfeat_face(params);

	this.init = function(video) {
		element = video;

		jf.init(element);
	}

	var getBoundingBox = function(box) {
		return new Promise(function(resolve, reject) {
			if (box) {
				resolve({x : box[0], y : box[1], width : box[2], height : box[3]});
			} else {
				resolve(jf.findFace());
			}
		});
	}

	var getFinegrainedPosition = function(candidate) {
		var translateX, translateY, scaling, rotation;
		var x = candidate.x;
		var y = candidate.y;
		var w = candidate.width;
		var h = candidate.height;

		// var debugCC = document.getElementById('overlay2').getContext('2d')
		if (model.hints && mosseFilter && left_eye_filter && right_eye_filter && nose_filter) {
			var noseFilterWidth = w * 4.5/10;
			var eyeFilterWidth = w * 6/10;

			// detect position of eyes and nose via mosse filter
			var nose_result = mossef_nose.track(element, Math.round(x+(w/2)-(noseFilterWidth/2)), Math.round(y+h*(5/8)-(noseFilterWidth/2)), noseFilterWidth, noseFilterWidth, false);
			var right_result = mossef_righteye.track(element, Math.round(x+(w*3/4)-(eyeFilterWidth/2)), Math.round(y+h*(2/5)-(eyeFilterWidth/2)), eyeFilterWidth, eyeFilterWidth, false);
			var left_result = mossef_lefteye.track(element, Math.round(x+(w/4)-(eyeFilterWidth/2)), Math.round(y+h*(2/5)-(eyeFilterWidth/2)), eyeFilterWidth, eyeFilterWidth, false);
			right_eye_position[0] = Math.round(x+(w*3/4)-(eyeFilterWidth/2))+right_result[0];
			right_eye_position[1] = Math.round(y+h*(2/5)-(eyeFilterWidth/2))+right_result[1];
			left_eye_position[0] = Math.round(x+(w/4)-(eyeFilterWidth/2))+left_result[0];
			left_eye_position[1] = Math.round(y+h*(2/5)-(eyeFilterWidth/2))+left_result[1];
			nose_position[0] = Math.round(x+(w/2)-(noseFilterWidth/2))+nose_result[0];
			nose_position[1] = Math.round(y+h*(5/8)-(noseFilterWidth/2))+nose_result[1];

			// drawDetection(debugCC, candidate, [left_eye_position, right_eye_positions, nose_position]);

			// get eye and nose positions of model
			var lep = model.hints.leftEye;
			var rep = model.hints.rightEye;
			var mep = model.hints.nose;

			// get scaling, rotation, etc. via procrustes analysis
			var procrustes_params = procrustes([left_eye_position, right_eye_position, nose_position], [lep, rep, mep]);
			translateX = procrustes_params[0];
			translateY = procrustes_params[1];
			scaling = procrustes_params[2];
			rotation = procrustes_params[3];

			// drawFacialPoints(debugCC, [lep, rep, mep], procrustes_params);
		} else {
			// drawBoundingBox(debugCC, [x,y,w,h]);
			scaling = w/msmodelheight;
			rotation = 0;
			translateX = x-(msxmin*scaling)+0.1*w;
			translateY = y-(msymin*scaling)+0.25*h;
		}

		return [scaling, rotation, translateX, translateY];
	}

	// get initial starting point for model
	this.getInitialPosition = function(box) {
		return new Promise(function(resolve, reject) {
			getBoundingBox(box)
				.then(getFinegrainedPosition)
				.then(resolve)
				.catch(reject);
		});
	}

	// procrustes analysis
	function procrustes(template, shape) {
		// assume template and shape is a vector of x,y-coordinates
		//i.e. template = [[x1,y1], [x2,y2], [x3,y3]];
		var templateClone = [];
		var shapeClone = [];
		for (var i = 0;i < template.length;i++) {
			templateClone[i] = [template[i][0], template[i][1]];
		}
		for (var i = 0;i < shape.length;i++) {
			shapeClone[i] = [shape[i][0], shape[i][1]];
		}
		shape = shapeClone;
		template = templateClone;

		// calculate translation
		var templateMean = [0.0, 0.0];
		for (var i = 0;i < template.length;i++) {
			templateMean[0] += template[i][0];
			templateMean[1] += template[i][1];
		}
		templateMean[0] /= template.length;
		templateMean[1] /= template.length;

		var shapeMean = [0.0, 0.0];
		for (var i = 0;i < shape.length;i++) {
			shapeMean[0] += shape[i][0];
			shapeMean[1] += shape[i][1];
		}
		shapeMean[0] /= shape.length;
		shapeMean[1] /= shape.length;

		var translationX = templateMean[0] - shapeMean[0];
		var translationY = templateMean[1] - shapeMean[1];

		// centralize
		for (var i = 0;i < shape.length;i++) {
			shape[i][0] -= shapeMean[0];
			shape[i][1] -= shapeMean[1];
		}
		for (var i = 0;i < template.length;i++) {
			template[i][0] -= templateMean[0];
			template[i][1] -= templateMean[1];
		}

		// scaling

		var scaleS = 0.0;
		for (var i = 0;i < shape.length;i++) {
			scaleS += ((shape[i][0])*(shape[i][0]));
			scaleS += ((shape[i][1])*(shape[i][1]));
		}
		scaleS = Math.sqrt(scaleS/shape.length);

		var scaleT = 0.0;
		for (var i = 0;i < template.length;i++) {
			scaleT += ((template[i][0])*(template[i][0]));
			scaleT += ((template[i][1])*(template[i][1]));
		}
		scaleT = Math.sqrt(scaleT/template.length);

		var scaling = scaleT/scaleS;

		for (var i = 0;i < shape.length;i++) {
			shape[i][0] *= scaling;
			shape[i][1] *= scaling;
		}

		// rotation

		var top = 0.0;
		var bottom = 0.0;
		for (var i = 0;i < shape.length;i++) {
			top += (shape[i][0]*template[i][1] - shape[i][1]*template[i][0]);
			bottom += (shape[i][0]*template[i][0] + shape[i][1]*template[i][1]);
		}
		var rotation = Math.atan(top/bottom);

		translationX += (shapeMean[0]-(scaling*Math.cos(-rotation)*shapeMean[0])-(scaling*shapeMean[1]*Math.sin(-rotation)));
		translationY += (shapeMean[1]+(scaling*Math.sin(-rotation)*shapeMean[0])-(scaling*shapeMean[1]*Math.cos(-rotation)));

		return [translationX, translationY, scaling, rotation];
	}
}

// simple wrapper for jsfeat face detector that can run as a webworker
var jsfeat_face = function(parameters) {

	var params = parameters;
	var maxWorkSize = params.workSize;
	var useWebWorkers = params.useWebWorkers;

	var work_canvas = document.createElement('canvas');
	var work_ctx = work_canvas.getContext('2d');

	var videoWidth, videoHeight, scale, video, w, h;
	var img_u8, edg, ii_sum, ii_sqsum, ii_tilted, ii_canny, classifier;
	var worker;

	if (useWebWorkers) {
		Worker.createURL = function(func_or_string) {
			var str = (typeof func_or_string === 'function')?func_or_string.toString():func_or_string;
			str = str.replace("'FRONTALFACE_PLACEHOLDER'", JSON.stringify(jsfeat.haar.frontalface));
			var blob = new Blob(['\'use strict\';\nself.onmessage ='+str], { type: 'text/javascript' });
			return window.URL.createObjectURL(blob);
		};

		Worker.create = function(func_or_string) {
			return new Worker(Worker.createURL(func_or_string));
		};

		worker = Worker.create(findFaceWorker);
	}

	this.init = function(element) {
		video = element;
		videoWidth = video.width;
		videoHeight = video.height;

		// scale down canvas we do detection on (to reduce noisy detections)
		scale = Math.min(maxWorkSize/videoWidth, maxWorkSize/videoHeight);
		w = (videoWidth*scale)|0;
		h = (videoHeight*scale)|0;

		work_canvas.height = h;
		work_canvas.width = w;

		if (!useWebWorkers) {
			img_u8 = new jsfeat.matrix_t(w, h, jsfeat.U8_t | jsfeat.C1_t);
			edg = new jsfeat.matrix_t(w, h, jsfeat.U8_t | jsfeat.C1_t);
			ii_sum = new Int32Array((w+1)*(h+1));
			ii_sqsum = new Int32Array((w+1)*(h+1));
			ii_tilted = new Int32Array((w+1)*(h+1));
			ii_canny = new Int32Array((w+1)*(h+1));
			classifier = jsfeat.haar.frontalface;
		}
	}

	this.findFace = function () {
		work_ctx.drawImage(video, 0, 0, work_canvas.width, work_canvas.height);
		var imageData = work_ctx.getImageData(0, 0, work_canvas.width, work_canvas.height);

		return new Promise(function(resolve, reject) {
			if (useWebWorkers) {
				worker.addEventListener('message', function (e) {
					if (e.data.faces.length > 0) {
						resolve(e.data.faces[0]);
					} else {
						reject();
					}
				}.bind(this), false);

				worker.postMessage({
					w: work_canvas.width,
					h: work_canvas.height,
					videoWidth: videoWidth,
					imageData:imageData,
					params: params
				});
			} else {
				jsfeat.imgproc.grayscale(imageData.data, work_canvas.width, work_canvas.height, img_u8);

				// possible params
				if(params.equalizeHistogram) {
					jsfeat.imgproc.equalize_histogram(img_u8, img_u8);
				}
				//jsfeat.imgproc.gaussian_blur(img_u8, img_u8, 3);

				jsfeat.imgproc.compute_integral_image(img_u8, ii_sum, ii_sqsum, classifier.tilted ? ii_tilted : null);

				if(params.useCanny) {
					jsfeat.imgproc.canny(img_u8, edg, 10, 50);
					jsfeat.imgproc.compute_integral_image(edg, ii_canny, null, null);
				}

				jsfeat.haar.edgesDensity = params.edgesDensity;
				var rects = jsfeat.haar.detect_multi_scale(ii_sum, ii_sqsum, ii_tilted, params.useCanny? ii_canny : null, img_u8.cols, img_u8.rows, classifier, params.scaleFactor, params.minScale);
				rects = jsfeat.haar.group_rectangles(rects, params.min_neighbors);

				for (var i = rects.length-1;i >= 0;i--) {
					if (rects[i].confidence < params.confidenceThreshold) {
						rects.splice(i,1);
					}
				}

				var rl = rects.length;
				if (rl == 0) {
					reject();
				} else {
					var best = rects[0];
					for (var i = 1; i < rl; i++) {
						if (rects[i].neighbors > best.neighbors) {
							best = rects[i];
						} else if (rects[i].neighbors == best.neighbors) {
							// if (rects[i].width > best.width) best = rects[i]; // use biggest rect
							if (rects[i].confidence > best.confidence) best = rects[i]; // use most confident rect
						}
					}

					var sc = videoWidth / img_u8.cols;
					best.x = (best.x*sc)|0;
					best.y = (best.y*sc)|0;
					best.width = (best.width*sc)|0;
					best.height = (best.height*sc)|0;

					resolve(best);
				}
			}
		});
	};
};

export default faceDetection;
